+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2020-03-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1584931378/media/2020/03/sqABOCRinaldoimage0_ixibv7.jpg"
primary_image_credit = "Rinaldo, American Baroque Opera Co., 2020. Photo: Karen Almond."
related_articles = ["articles/la-traviata-shows-houston-how-to-arise.md", "articles/montezuma.md"]
related_companies = ["scene/companies/american-baroque-opera-co.md"]
related_people = []
short_description = "I felt like I was actually in a garden surrounded by drooping blossoms, or actually at the opening of a cavernous hole. Throughout I got the sense that this was a production that put a great deal of effort into engaging the senses all at once and imparting an aura of wonderment."
slug = "a-case-for-relatable-handel-abocs-rinaldo"
title = "A case for relatable Handel: ABOC's Rinaldo"
youtube_url = ""

+++
In their short yet consequential rise in the world of early music ensembles, American Baroque Opera Company have made their name on a relatable presentation of Baroque operas, and their staging of Handel’s _Rinaldo_ in Irving was no exception. However, this was the first time that I have seen them perform in a theatre with a particularly large stage, so it was interesting to see how the company would live up to the challenges posed. The production would have to make the case for the authentic Baroque spirit in highly modern theatrical surroundings, and it did so with gusto.

This production, directed by Rebecca Choate Beasley, who takes a great interest in Baroque gestures, made the most of the task. The most profound difficulty would be in figuring out just how to fill the expanse, as there was not an excess of props. Fortunately, Handel’s keen instinct for filling in musical gaps in arias was sufficient to guide the singers’ imaginations to make well-placed and –timed dramatic choices. The scenery was often suggested by extremely vivid projections, made especially lifelike and engaging by just the right amount of contrast in the editing of photos. I felt like I was actually in a garden surrounded by drooping blossoms, or actually at the opening of a cavernous hole. Throughout I got the sense that this was a production that put a great deal of effort into engaging the senses all at once and imparting an aura of wonderment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584931538/media/2020/03/ABOCRinaldoimage1_fdzvuf.jpg){{% /md %}}

<figcaption>Rinaldo, American Baroque Opera Co., 2020. Photo: Karen Almond.</figcaption>  
</figure>

While the stage was quite immense, the orchestra pit was very small. While it was quite deep even when fully raised, the biggest difficulty lay in the fact that there was very little room for players to fit: not more than two could fit abreast. It was necessary to have the trumpets and timpani offstage, which gave a very interactive effect. It was also difficult to coordinate particularly intricate passages (of which this opera has many) with the singers onstage. This was definitely the case with the incredibly rich wind writing, as the oboes were necessitated to be placed on the far side of the pit. Nevertheless, much praise is to be given for the general balance of the orchestra’s sound, a particular concern given Artistic Director Eric Smith’s double duties as conductor and principal cellist. Fortunately, the continuo ensemble had plenty of members during passages where Smith’s leading the ensemble took precedence over playing the bass line himself.

Rinaldo (Nicholas Garza) was primarily a study in character. Garza, like all the singers, was compelled to sustain our interest by making the repetitive text of the arias mean something different every time, which led to a highly spontaneous feeling throughout the whole production which I greatly enjoyed. As the production focused on Rinaldo’s tendencies to ruminate, Garza let the arias to speak for themselves without extraneous action. In “Cara sposa,” Garza exhibited, while reflecting on his powerlessness, subtle echoes of the silky tone found in such artists as Philippe Jarrousky. On the other hand, this emphasis made “Or la tromba” represent the complete about-face in Rinaldo’s self-image that it is, with Garza not only singing all the notorious coloratura with energy to spare, but visibly showing a return to normalcy in some ways likewise.

> She clearly enjoys the chase, as she ably demonstrated in “Vo far guerra,” with dazzling harpsichord solos by Brad Bennight.

As Almirena, Jendi Tarde was impressive as she is routinely with lyric soprano roles, particularly in one that is so prone to being trivialized as this one is. “Lascia ch’io pianga” was especially stark and poignant, and not resigned to being serene just because the music is so lush. Rather, it had a tinge of lamentation for all who struggle under tyranny’s yoke. On the other hand, “Bel piacere” showed her not merely being content with her Rinaldo, but delighting in her power of choice over whether to remain with him or go back to her father, who looked approvingly on the whole scene.

Goffredo (Janna Critz) and Eustazio (Kayla Nanto) were shown to be politicians who have perfected the art of diplomacy. Their interactions struck me as very “good cop/bad cop.”  Goffredo always had a very stern expression, partly the product of an ingenious use of makeup which kept the Crusader leader’s face extremely fixed; this served well for expressions of pride in having such a brave son-in-law as Rinaldo, but also for inscrutable expressions of shrewdness. This made me very interested to see what Critz would to give her arias expressively to combat this uncompromising front, and she did not disappoint. Her treatment of the arias was very ornate and ably showcased her high mezzo tessitura. Eustazio would invariably be around to soften his brother’s rather moralistic tone, and Nanto’s intimate lower register was very welcome indeed for this purpose to accompany her requisite nods.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584931559/media/2020/03/ABOCRinaldoimage2_sjzlpw.jpg){{% /md %}}

<figcaption>Rinaldo, American Baroque Opera Co., 2020. Photo: Karen Almond.</figcaption>  
</figure>

Javier Ortiz had a highly versatile voice for the notoriously wide-ranging role of Argante, even if it did take time to fully engage. Argante’s anxiety and his glittery robes certainly marked him out as a contrast to the very controlled Goffredo. Certainly Baroque opera delights in such archetypes, particularly when contrasting different cultures in the manner anything about the Crusades does, especially at the time Rinaldo was written, when European soldiers were slowly but surely pushing the Ottoman Turks out of Central Europe.

As Armida, Jennifer Youngs perfectly exemplified the concept of striking a balance between two pathways. In a costume that struck me as a blend between Maleficent and something from Game of Thrones, she delivered “Furie terribili” in a manner that showed that she reveled in her magical powers, but with not so much venom as to make her a complete harpy. There was grace in her malice. I thought, “All right, I can see why Argante finds Armida sweet and loving.” It was all very fairytale-like, yet we certainly lost nothing as a result. She clearly enjoys the chase, as she ably demonstrated in “Vo far guerra,” with dazzling harpsichord solos by Brad Bennight, and when attempting to pin down Rinaldo, she certainly did not give up easily!

> American Baroque Opera Company has effectively made the case for Baroque opera being replete with relatable characters with palpable emotions.

William Derusha as the Magician (dressed in this case as a friar with magical wands) lent that role a certain degree of awe, highlighted by the extended improvisation surrounding his entrance (for he does come from out of a cave, after all). It was highly interesting seeing these Crusaders venerate wands like holy relics, another fairytale aspect. Gabrielle Gilliam, as the alluring siren who leads Rinaldo into certain danger, was quite enchanting, so much so that she had to take care to be patient and not lay on her charms too thickly.  One could see Rinaldo slowly succumbing as he thought “That’s my jam,” for Handel is very skilled at making music that makes us all think likewise.

In allowing antique modes of expression to sound forth, yet allowing them to coexist with the practical nature of theatre, American Baroque Opera Company has effectively made the case for Baroque opera being replete with relatable characters with palpable emotions no matter the plausibility of their surroundings or their stock nature. This is in addition to the excellent case of _Rinaldo_ as a great opera for beginners. After all, it is perfect for those who like their fairy tales with just the right combination of morality and razzle-dazzle.