+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = 2020-11-17T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "You can find more information about _Rimsky Rebooted_ on the Chicago Opera Theater [website](https://chicagooperatheater.org/season/rebooted). $20 tickets are available through [Valhalla Media](https://www.valhallamedia.live/videos/kashchej-the-immortal). The show premieres Nov. 21st at 7:30 pm CST and will remain accessible for 72 hours."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1605639305/media/2020/11/sqLidiyaYankovskaya-StephanieBassos_iri4cl.jpg"
primary_image_credit = "Lidiya Yankovskaya, Music Director at Chicago Opera Theater. Photo: Stephanie Bassos."
related_articles = ["articles/the-positive-impact-of-community-created-performances.md", "articles/theres-a-new-klingon-opera-in-the-works.md", "articles/actual-magic-in-chicago-lyrics-cendrillon.md"]
related_companies = ["scene/companies/chicago-opera-theater.md"]
related_people = ["scene/people/annie-rosen.md", "scene/people/lidiya-yankovskaya.md", "scene/people/will-liverman.md"]
short_description = "In a recent Zoom conversation, Yankovskaya's pride and enthusiasm in the COT administrative and artistic staff was evident from the start. She praised their collective grit, acknowledging that their upcoming digital release, Rimsky Rebooted represents not just a \"Plan B\" pivot from live performance, but is rather a \"5th or maybe 7th reimagining\" of what they hoped to originally present to Chicago audiences."
slug = "cots-rimsky-rebooted-features-local-artists-collective-grit"
title = "COT's Rimsky Rebooted features local artists & \"collective grit\""
youtube_url = ""

+++
At this point, it almost goes without saying: for arts organizations around the world, the ever-shifting realities (and regulations) of the COVID-19 pandemic have made business as usual an impossibility. For the majority of US opera companies, live performance will not happen at all this season and no two companies are adapting to that grim truth in quite the same way. In this tough time, the tenacity of companies like [Chicago Opera Theater](/scene/companies/chicago-opera-theater/), who are pivoting to digital content, cannot be understated. The work COT is doing requires resourcefulness, organizational prowess, an abiding mutual trust from supporters and donors, and a kind of exuberant industriousness exemplified in their Orli and Bill Staley Music Director, [Lidiya Yankovskaya](/scene/people/lidiya-yankovskaya/).

> Yankovskaya is a passionate advocate for Russian operatic masterworks that have historically been under-appreciated in the West.

In a recent Zoom conversation, Yankovskaya's pride and enthusiasm in the COT administrative and artistic staff was evident from the start. She praised their collective grit, acknowledging that their upcoming digital release, [_Rimsky Rebooted_](https://chicagooperatheater.org/season/rebooted) represents not just a "Plan B" pivot from live performance, but is rather a "5th or maybe 7th reimagining" of what they hoped to originally present to Chicago audiences. Capitalizing on star talents living locally, mezzo-soprano [Annie Rosen](/scene/people/annie-rosen/), baritone [Will Liverman](/scene/people/will-liverman/), and bass Wilbur Pauley, and partnering with [Valhalla Media](https://www.valhallamedia.io/), a new company specializing in recording and livestreaming classical musicians, _Rimsky Rebooted_ features lengthy excerpts from Rimsky-Korsakov’s _Kashchej the Immortal_ and Debussy’s _Pelléas et Mélisande_ along with Russian arias and songs. In addition to being the project’s Music Director, Yankovskaya will share pianist duties with another local artist, [Michael Pecak](/authors/michael-pecak/) and the project will be filmed (with safety measures in place) at North Shore Center for the Performing Arts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605639404/media/2020/11/WillLiverman_creditJaclynSimpson_tzvq3a.jpg){{% /md %}}

<figcaption>Baritone Will Liverman, singing in Chicago Opera Theater's Rimsky Rebooted. Photo: Jaclyn Simpson.</figcaption>

</figure>

Yankovskaya is a passionate advocate for Russian operatic masterworks that have historically been under-appreciated in the West. _Rimsky Rebooted_ is the continuation of a seasons-long project to bring infrequently-performed Russian gems to the COT stage, (following _Aleko_ in 2019 and _Iolanta_ in 2018.) Like those two works, Kaschej the Immortal is also a one-act opera with its roots in Russian folklore. In _Rebooted_, audiences will hear the full second scene of the opera sung by Rosen (Kascheyevna) and Liverman (Prince Ivan). The scene is the first meeting of Kascheyevna, (the Sorcerer Kaschej's daughter), and Prince Ivan. Defying Kaschej’s command, Kascheyevna refuses to behead the beautiful Prince, setting in motion a chain of events that will ultimately lead to her own father's downfall.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1605639458/media/2020/11/AnnieRosen_creditSimonPauley_be8jzs.jpg){{% /md %}}

<figcaption>Mezzo-soprano Annie Rosen, singing in Chicago Opera Theater's Rimsky Rebooted. Photo: Simon Pauley.</figcaption>

</figure>

> Yankovskaya is confident that the concerts being produced by the company can’t be heard anywhere else, online or IRL.

The Tower Scene from _Pelléas et Mélisande_ is the other major excerpt on the program and while Yankovskaya wouldn't promise it, presenting the full opera on a future COT season would certainly fit within the company's ethos; the opera hasn’t been staged in the city in over 30 years. The scene from Debussy's dreamy, atmospheric, sensuous fairy tale features Liverman (Pélleas) and Rosen (Mélisande) in one of the opera's most romantic and musically-beautiful moments.

COT's 2020-21 digital offerings are consistent with the company's long-standing commitments to bring something new to the opera landscape -- with _Rimsky Rebooted_ and other planned releases, Yankovskaya is confident that the concerts being produced by the company can’t be heard anywhere else, online or IRL. Alongside these more visible projects, the company is continuing with its laudable [Vanguard Initiative](https://chicagooperatheater.org/vanguard), a two-year program for emerging operatic composers. While the pandemic has rendered some of the program’s usual opportunities unworkable in the short term, the company is still able to run workshops for the composers’ in-progress works and facilitate conversations and burgeoning mentorships between industry insiders and the Initiative's resident composers.