+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2019-10-23T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Houston Grand Opera's [production of _Rigoletto_](https://www.houstongrandopera.org/rigoletto) is onstage through November 1."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571884517/media/2019/10/sqHGORigolettoLynnLane-2-resized_dlrepv.jpg"
primary_image_credit = "Michael Mayes in the title role of Rigoletto, Houston Grand Opera, 2019. Photo: Lynn Lane."
related_articles = ["articles/the-price-of-vengeance-rigoletto-at-roh.md", "articles/searching-for-superlatives-locs-suberb-rigoletto.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/mané-galoyan.md", "scene/people/arturo-chacón-cruz.md", "scene/people/zoie-reams.md", "scene/people/david-shipley.md", "scene/people/michael-mayes.md"]
short_description = "As Rigoletto leaves the party, we see the true depth of his character. As Mayes interprets him, the jester is very fidgety, his routines a compulsive series of tics that he feels compelled to practice even when nobody else is around, very much the modern laborer trapped in his work. "
slug = "moral-dilemmas-an-excellent-quartet-hgos-rigoletto"
title = "Moral dilemmas & an excellent quartet: HGO's Rigoletto"
youtube_url = ""

+++
When one goes to the opera today for a season-opening warhorse such as Giuseppe Verdi's [_Rigoletto_](https://www.houstongrandopera.org/rigoletto), one senses that the motivation is often for the pleasure of listening to something with many comfortably familiar moments.

Certainly [Houston Grand Opera](/scene/companies/houston-grand-opera/)'s production of this ably provides this in spades for many persons under the impression, in their wisdom, that they know this piece like the back of their hands. And yet the whole evening provided a very striking and adventurous experience for those who sought a fresh take on what guidebooks recommend as an easily digestible first opera for newcomers to the art form. After all, "_Rigoletto_ is a short opera," as anyone who has watched the PBS show _Arthur_ can relate.

> Rigoletto hates just about every minute of gratifying the whims of these pretended socialites.

The production featured imposing Corinthian columns surrounded by many drab buildings in shades of gray, and set in a rather updated 1920s environment reminiscent of fascist Italy, conducive to the deadening of the soul. Quite intentionally naturalistic and dispensing with much of the plot elements requiring suspension of disbelief, it contributed with Maestro Jordan de Souza's organic shaping of the score to render the whole evening as visually and audibly shocking to me as an audience in 1851 Venice would have perceived it.

Indeed, as the prelude opened, one saw the chorus stealthily emerge with their animal masks, with all their attendant implications of vice and excess. There were certainly enough masks to merit comparison with Classical Theatre Company's concurrent production of [_Lysistrata_](https://classicaltheatre.org/production/lysistrata/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843195/media/2019/10/HGORigoletto2019LynnLane-1_jkzi9z.jpg){{% /md %}}

<figcaption>The HGO Chorus in HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Yet the gangsters have personalities that occasionally can be glimpsed, and one suspects they are the source of numerous epithets: Marullo (Geoffrey Hahn), the chatty one; Ceprano (Daniel Noyola), the morbid one; and Borsa (Richard Trey Smagur), the shameless one. It should be said for the reader's benefit that the chorus all had pistols which they were very eager to brandish at the slightest provocation, rendering Rigoletto's ([Michael Mayes](/scene/people/michael-mayes/)) later cries of "Assassini" as tinged with irony as anything.

> Chacón-Cruz is as fleet-footed as he is vocally nimble. 

This court is no longer a merely treacherous yet cultured Tudor-era gentlemen's club that requires Cromwellian wile to negotiate successfully, but a dystopian fortress of vice malevolent towards everyone within its grasp, especially the females. And Rigoletto hates just about every minute of gratifying the whims of these pretended socialites. (Clearly the Duchess's page - sung by Elena Villalón - has not been through orientation.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843208/media/2019/10/HGORigolettoLynnLane-20_wo7es2.jpg){{% /md %}}

<figcaption>Dorothy Gal as Countess Ceprano, Daniel Noyola as Count Ceprano, Arturo Chacón-Cruz as Duke of Mantua, and Michael Mayes as Rigoletto in HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

In this light, the Duke of Mantua (tenor [Arturo Chacón-Cruz](/scene/people/arturo-chacon-cruz/)) was metamorphosed into Il Duce, as we Latin scholars chuckle to ourselves about shared etymologies and bilingual puns. Chacón-Cruz is as fleet-footed as he is vocally nimble, and he invested his attentions wisely towards elucidating the Duke's motivations - motivations which are as much about putting on an impregnable show of bravado for his sycophantic courtiers to maintain the illusion of his cult of personality, as about gratifying his own vapid desires, all while deluding himself that his latest infatuation will actually last this time. “This is something new.”

> As Mayes interprets him, the jester is very fidgety, his routines a compulsive series of tics that he feels compelled to practice even when nobody else is around.

And the objects of his attention, the jaded yet eager-to-please Countess of Ceprano (Dorothy Gal) among them, know well that not playing along with such games is fatal.

As Rigoletto leaves the party, we see the true depth of his character. As Mayes interprets him, the jester is very fidgety, his routines a compulsive series of tics that he feels compelled to practice even when nobody else is around, very much the modern laborer trapped in his work.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843220/media/2019/10/HGORigolettoLynnLane-52_k8p5ud.jpg){{% /md %}}

<figcaption>Arturo Chacón Cruzas (Duke of Mantua) and Mané Galoyanas (Gilda) HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

It takes us a while to see him in a light any different from that bestowed by his meeting with the ominous Sparafucile ([David Shipley](/talking-with-singers-david-shipley/)): very much a lower-class entertainer, but investing what remains of his soul to protect his daughter, Gilda ([Mané Galoyan](/scene/people/mane-galoyan/)), from the lascivious and prying eyes of his employer and the world.

Too bad that his slatternly housekeeper, the disinterested Giovanna (Lindsay Kate Brown), knows that she can get more for her services and is therefore easily tempted by the Duke's bribes, which she clearly has experience in accepting.

> As this opera's production hopes we do not forget, the quest for justice is eternal.

Nicholas Newton's Monterone is perfectly imposing for the underestimated role that his character plays in accomplishing a task that he knows to be futile. Is denouncing a den of vice into which your daughter has somehow fallen and pronouncing convincing maledictions ever an easy task? Particularly when your model in Victor Hugo's original play, _Le roi s'amuse_, is by far less sympathetic.

Given that this production has him bludgeoned and stabbed multiple times before our potentate friend unceremoniously fires a pistol into his head, his appearance is all the more stark and martyrish.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843499/media/2019/10/HGORigolettoLynnLane-197_xvql2h.jpg){{% /md %}}

<figcaption>Mané Galoyanas Gilda HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

With a piece with as many numbers as this, I will restrict myself to a few to highlight a few pertinent points. "Caro nome," easily one of the more stereotyped arias in the repertoire, was very organically shaped by both Galoyan and the orchestra, which Maestro de Souza infused with a very imaginative touch of rubato. Galoyan, it should be said, is quite diminutive, and her stature contributed to Gilda's overall vulnerability throughout the work. Such freshness was emblematic of just about every number, in my perception, and led to the cohesive theatrical concept hinted at above.

Speaking of cohesion, "Bella figlia d'amore" certainly stood out in this production, particularly as Maddalena ([Zoie Reams](/scene/people/zoie-reams/)), in her sultry sonorousness, shied not from performing her game of seduction with relish. Given this production's take on the Duke's cult of personality being a vehicle for the scoundrel's own amusement, one certainly asks, who is he trying to impress here? (It's not as if anyone is watching, right?)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843249/media/2019/10/HGORigolettoLynnLane-147_qhmew6.jpg){{% /md %}}

<figcaption>Michael Mayes (Rigoletto) and Mané Galoyan (Gilda) HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

Irony aside, I certainly enjoyed this classic quartet, as the attentive accompaniment enabled my attention to go to each character's perfectly delineated layer at will, as I lamented to myself the scarcity of such contrapuntally deft ensembles in modern operas.

Most devastatingly, in the final duet following the celebrated storm, Gilda is represented by a dummy wrapped in Sparafucile's famous sack, so that in this production's final realistic touch, Gilda is sung by a representation of her spirit which slowly traverses the stage as if on an invisible, tortoise-paced conveyor belt.

It simultaneously prolongs the finality of crossing the void, and making it all the more tragic for Rigoletto to see his daughter nihilistically reduced to flesh and bone due to his thirst for vengeance - a thirst which has gradually evolved through the whole piece, and has not occurred instantaneously upon encountering his daughter disheveled at the Duke's palace.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571843275/media/2019/10/HGORigolettoLynnLane-173_t8xdoe.jpg){{% /md %}}

<figcaption>Arturo Chacón-Cruz (Duke of Mantua) and the HGO Chorus in HGO's new production of Rigoletto, 2019. Photo: Lynn Lane.</figcaption>

</figure>

And so this opera goes full circle, with numerous connected images of society forcing an oppressed character into the moral dilemma between vengeance and mercy. For as this opera's production hopes we do not forget, the quest for justice is eternal, and depends on persons of good will having the patience and endurance to seek it out actively, yet temperately.