+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-23T15:13:00+00:00"
lastmod = "2017-02-26T16:51:00+00:00"
preamble = "This weekend marks the world premiere of [*Riders of the Purple Sage*](http://www.azopera.org/performances/riders-purple-sage), the new opera by [Craig Bohmler](/new-operas-craig-bohmlers-riders-of-the-purple-sage/) and Steven Mark Kohn, based on the novel by Zane Grey. The Western-inspired opera is the first world premiere by [Arizona Opera](/scene/companies/arizona-opera/), and the distinct landscape of the American Southwest is illuminated by the set design of artist Ed Mell.\n\nWe spoke with baritones [Joshua Jeremiah](/scene/people/joshua-jeremiah/) and [Morgan Smith](/scene/people/morgan-smith/), who share the role of Lassiter, the mysterious gunman who throws a wrench in the traditions of the Mormon settlement, Short Creek. They chat about great characters, new operas, & Han Solo."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487863330758/2017-02-23---Square---MorganSmithAsLassiter---pc---TimTrumble.jpg.jpg"
primary_image_credit = "Morgan Smith as Lassiter in Riders of the Purple Sage, Arizona Opera, 2017. Photo by Tim Trumble."
publishDate = "2017-02-26T12:22:00+00:00"
related_articles = ["articles/riders-of-the-purple-sage-meet-jane.md","articles/new-operas-craig-bohmlers-riders-of-the-purple-sage.md"]
related_companies = ["scene/companies/arizona-opera.md"]
related_people = ["scene/people/morgan-smith.md","scene/people/joshua-jeremiah.md"]
short_description = "&quot;It&#039;s a rare thing to get to see a world premiere opera inspired by our local culture and history, and featuring a gorgeous set by Ed Mell that celebrates the Southwest landscape. I think audiences will find the story accessible, the scenes familiar, and the music incredibly expressive and moving.&quot;"
slug = "riders-of-the-purple-sage-meet-lassiter"
title = "Riders of the Purple Sage: meet Lassiter"
+++

## What kind of person is Lassiter?

**Joshua Jeremiah**: Lassiter reminds me a bit of Han Solo – original "shoot first" Han Solo, not the abomination from the remastered version. He is a scoundrel, but has a heart of gold. Equal parts charming and dangerous, but solely focused on business...and he is in the business of vengeance. I find him to be a completely relatable person, which is one of the beautiful things about this show. Lassiter is a man that has lost his mooring, and is adrift in a world of ambiguous morality. He used to be a religious person, but due to the religious involvement in the disappearance and death of Milly Erne, he has come to a place where he no longer believes in a god, or an objective morality. And, because these people aren't from the aristocratic class in Renaissance Europe (like so much opera), but Americans in the West, the immediacy is poignant and real.

**Morgan Smith**: Lassiter is the iconic cowboy vigilante. His heart is hardened, and he's been dealt a bum hand by life. He sees avenging the death of his sister as the only path to reconciliation and peace.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487863076037/2017-02-23---Joshua_Jeremiah.jpg.jpg)
<figcaption>Joshua Jeremiah, baritone, singing Lassiter in the world premiere of *Riders of the Purple Sage* at Arizone Opera.</figcaption>
</figure>

## What can audiences expect from the premiere of *Riders of the Purple Sage*?

**MS**: It's a rare thing to get to see a world premiere opera inspired by our local culture and history, and featuring a gorgeous set by Ed Mell that celebrates the Southwest landscape. I think audiences will find the story accessible, the scenes familiar, and the music incredibly expressive and moving. 

**JJ**: Riders reminds me a bit of a movie, but with very serious operatic/musical underpinnings. Imagine John Williams with some Copland in the orchestra, then with a bit of Richard Rodgers and Verdi in the vocal writing. Craig Bohmler (our fantastic composer and hiking leader extraordinaire) mentioned just the other day that vocally, Lassiter really ended up being a Count Di Luna...it is hard to disagree with that. The range, both vocally and dramatically, mixed with a punishing tessitura, is really quite demanding. All of that said, the music is so reminiscent of the Old West. I don't think I've ever heard an opera that so perfectly encapsulates the time and place in which it is set. This isn't the kind of exoticism that opera often falls into, but rather a love letter from someone that lives there and really appreciates and understands it. I would rank up it up there with Strauss's *Alpine Symphony* in its ability to conjure up imagery.

## How does your rehearsal process change when the composer is on site? What kinds of questions have you been able to ask the creators of *Riders*?

**JJ**: I've had the luxury to collaborate with composers on a few recent projects – John Musto, Mark Adamo, Matt Marks, David T. Little, Moto Osada – and without fail I've loved that opportunity to have an ongoing dialogue with the creator. I tend to be a pretty flexible performer, so I really enjoy picking their brains about why things were set in a way, or what they think the character means by certain things. I remember Morgan asking about a potential word change in Act 2, because it might give away a bit of plot too early... I think we debated 3 options, and after a full day of Steven [Kohn, the librettist] and Craig [Bohmler, the composer] talking it over, we finally settled on the word. A full day for one word – that is the kind of care we are talking about. I love it.

**MS**: I tend to be more preoccupied with singing the music accurately, and motivated to help bring the piece to life in the way that the composer imagined. In this particular instance, the composer is a dear friend and someone I greatly admire. This creates in me an especially strong desire to honor his beautiful and inspired writing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487863119633/2017-02-23---MorganSmith_credit_NicoHudak.jpg.jpg)
<figcaption>Morgan Smith, baritone, singing Lassiter in the world premiere of *Riders of the Purple Sage* at Arizone Opera. Photo by Nico Hudak.</figcaption>
</figure>

## What sort of responsibility does a singer have when working on a world premiere? Is there added pressure with being the first performers of your roles?

**JJ**: I don't really look at it as pressure. I think of it more like a wonderful gift that I was given. It is also a huge relief to not have to compare yourself to the greats. When I made my *Rigoletto* debut with AZ Opera a few years ago, it was so difficult knowing that I would never be able to sing it like Bastianini, or Leonard Warren, or that Milnes recording with the high B at the end. But here, there is no comparison – all you can do is really try and understand the character, become him, and figure out why and how he would say these lines. I think the biggest difference is that you are required to do all the work yourself. You can't go to the library and listen to 10 recordings and see how it has evolved or steal snippets from the greats. You've got the source material – a really great book by Zane Grey – and the score, a world-class libretto that could easily function as a play, and a couple of movies...and that is it. The rest is on you and your ability to be creative, but I find the material so rich and compelling that the character almost came to life by itself.

**MS**: In truth, it's extremely liberating to deliver the audience the gift of this music for the very first time; they arrive without preconception, and it's so exciting for both audience and performer to take the journey of discovering this experience together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487863309928/2017-02-23---MorganSmithAsLassiter---pc---TimTrumble.jpg.jpg)
<figcaption>Morgan Smith as Lassiter in *Riders of the Purple Sage*. Photo by Tim Trumble.</figcaption>
</figure>

## What are some of your favorite moments from the opera?

**MS**: I love Act 2 scene 4 – the scene at Milly's grave. Lassiter gets to sing some of the most beautiful and touching music in the opera. It is an incredibly vulnerable and dynamic scene.

**JJ**: Act 2 scene 4, without any hesitation. It is my favorite moment in the opera. Lassiter finally gets the closure he has been looking for when he gets to Milly Erne's grave. It is so beautiful, sad, and real. My favorite line in the score is when Jane tries to give him a bit of peace saying that Milly is with Heavenly Father and saying that Lassiter can find his peace too. He responds by saying, "No, it's too late for me. The world don't care how much you suffer. God don't say, 'leave 'em be.' I can't believe there's any great love out there. Maybe here, between people, in a small way. But there ain't no one watchin’ over me... how I wish there was." As someone that was raised religious but has become an atheist in the past few years, this line really resonates with me. This entire scene is just art. I love it, and it is the hardest scene I've ever had to get through in my life.

>[Click here](http://www.azopera.org/performances/riders-purple-sage) for full details about Arizona Opera's Riders of the Purple Sage, running February 25 to March 5, 2017. For ticket info, [click here.](http://tickets.azopera.org/single/EventListing.aspx#riders)
