+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-23T10:50:00+00:00"
lastmod = "2017-02-24T15:45:00+00:00"
preamble = "This weekend marks the world premiere of [*Riders of the Purple Sage*](http://www.azopera.org/performances/riders-purple-sage), the new opera by [Craig Bohmler](/new-operas-craig-bohmlers-riders-of-the-purple-sage/) and Steven Mark Kohn, based on the novel by Zane Grey. The Western-inspired opera is the first world premiere by [Arizona Opera](/scene/companies/arizona-opera/), and the distinct landscape of the American Southwest is illuminated by the set design of artist Ed Mell.\n\nWe spoke with sopranos [Laura Wilde](/scene/people/laura-wilde/) and [Karin Wolverton](/scene/people/karin-wolverton/), who share the role of Jane Withersteen, the \"good Mormon girl\" who questions the role of the church and its traditions. They share insight on the process of bringing to life a brand new opera, and their favourite moments in Bohmler's score."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487847163826/2017-02-23---KarinWolvertonAsJane_credit_TimTrumble.jpg.jpg"
primary_image_credit = "Karin Wolverton as Jane Withersteen in Riders of the Purple Sage. Photo by Tim Trumble."
publishDate = "2017-02-24T15:41:00+00:00"
related_articles = ["articles/riders-of-the-purple-sage-meet-lassiter.md"]
short_description = "&quot;Lassiter enters Jane&#039;s life and turns everything upside down. She is intrigued by and attracted to him, but also knows that he is outside her faith and his anger and hatred for the church is unsettling for her. However, he is the only man in the opera who affirms and admires her strength, while lovingly pushing back against her long-held beliefs.&quot;"
slug = "riders-of-the-purple-sage-meet-jane"
title = "Riders of the Purple Sage: meet Jane"
+++

## What kind of person is Jane Withersteen?

**Karin Wolverton**: Jane is a good Mormon girl! She is devout and has a strong faith as well as a deep compassion for those around her. But perhaps she hasn't questioned much in her life before Lassiter arrives. She believes in the good of humanity and often turns a blind eye to some of the hypocrisy surrounding her. She is constantly being pulled by what she has been taught by the church and what she trusts in her heart to be right.  

One thing I've really had to grapple with about Jane is her vanity. She most likely has been complimented her whole life on her looks, and it rankles me as a woman in the 21st century that she felt her womanly charms were the only way she could influence people. But I have to forgive her that fault – partly because of the patriarchal society in which she was raised, and the reality that it worked for her – a 'the ends justify the means' situation. But there is also a side of Jane that is a free spirit. She says in the opera that her father told her to "think for yourself, Jane" and to "trust your heart and mind." 

Her growth as a character in the story moves from someone who thinks for herself to someone who acts for herself and stands up for her beliefs, even if they go against her churchmen. 

**Laura Wilde**: Jane is a strong, kind, woman of faith. She is a pacifist and extends love to everyone around her, regardless of whether they are within her church structure. As a woman, she doesn't fit into the society in which she is confined, but genuinely relies on her faith and the encouragement she got from her father to be herself, do what is right, and live within the will of God. The oppression she faces from her church elders starts to take a toll on her and she finds herself stuck between what she knows to be true of God and what the church is enforcing. 

Lassiter enters Jane's life and turns everything upside down. She is intrigued by and attracted to him, but also knows that he is outside her faith and his anger and hatred for the church is unsettling for her. However, he is the only man in the opera who affirms and admires her strength, while lovingly pushing back against her long-held beliefs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487865673918/2017-02-23---LauraWilde_credit_KellyKruse.jpg.jpg)
<figcaption>Laura Wilde, soprano, singing the role of Jane Withersteen in the world premiere of *Riders of the Purple Sage*, Arizona Opera, 2017. Photo by Kelly Kruse.</figcaption>
</figure>

## What can audiences expect from the premiere of *Riders of the Purple Sage*?

**KW**: I think audiences will immediately be swept into the world of a Western by Craig's music. He creates the atmosphere of the West from the first downbeat of the prelude. Ed Mell's set design is breathtaking and invokes the expansiveness of the landscape. But what I really think is amazing is how this story was written a century ago but there are incredibly poignant issues we still grapple with today. Gun control, religious persecution, misogyny, child abduction, fanaticism, oppression, land and water rights – these are all still on our minds.

**LW**: This is a truly remarkable opera. Craig Bohmler is a genius composer and orchestrator. He has given each character a distinct theme, which he weaves expertly through the piece. His orchestral writing is as vast and beautiful as the landscape he is describing through music. Steven Mark Kohn's libretto is precise, descriptive, and digs deep to the heart of each character. The story is fantastic; it resonates with today's world, while exploring the specific era in which it is written. Also the production, with Ed Mell's scenic design, will be a thrill to see! 

I think the audience can expect to be swept away by this piece, have their heart strings tugged on, and be holding their breath till the last measure. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487865889902/2017-02-23---Karin-Wolverton.jpg.jpg)<figcaption>Karin Wolverton, singing the role of Jane Withersteen in the world premiere of *Riders of the Purple Sage*, Arizona Opera, 2017.</figcaption>
</figure>


## How does your rehearsal process change when the composer is on-site? What kinds of questions have you been able to ask the creators of *Riders*?

**LW**: This process has been one big lovefest. The cast and the creative team love each other and the piece on which we are working. Craig and Steven are incredibly flexible. If the singers hear something different than he has written, at times he defers to our ears and voices. They have allowed us to change some wording to make it easier to sing on high notes as well. As I have known Craig since before this opera was written, it's also such a joy to watch his opera get its world premiere. The process couldn't be better! 

**KW**: Having the composer and librettist during the rehearsal process was invaluable. I've learned more about composition from these few weeks than I ever did in school. Once Craig told me he based the opera on the jazz scale, an eight-note scale alternating whole and half steps, it was like scales lifting off my eyes. I could see and hear his music in a way that helped me map out where I was going harmonically. Craig has also been incredibly open to tailoring the music to fit the singer, and Steve has been open to tweaking the libretto. We had a great conversation one day about the difference between the word 'bring' and 'lead' and how each one had a slightly different connotation for a line I sing. I could never do that with da Ponte! In the end, we all just want to tell this story the best we can and being open to those changes has brought the opera to a higher level.

## What sort of responsibility does a singer have when working on a world premiere? Is there added pressure with being the first performers of your roles?

**LW**: The responsibility of the singer is to find the truth in the characters we are playing. I think that is always our responsibility. Rather than pressure, I feel a freedom in being part of the world premiere. We get to start from scratch and discover who these characters are – there are no expectations in how these roles should sound and what type of voice should sing it. We can just be ourselves, discovering and presenting the relationships we see in the story. 

**KW**: There is added pressure to being the first person to help create a role. But there is freedom as well. There are no traditions. There are no recordings or history with which to compare yourself. There is no 'this is the way it's always done' sensibility. And once you embrace that and run with it and open your mind to the possibilities, amazing art can happen. I think the biggest pressure is wanting to do right by Craig. I want people to fall in love with this opera they way I did and let themselves get caught up in its magic. And if I bring my best I can help that happen.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487865827818/2017-02-23---KarinWolvertonAsJane_MorganWSmithAsLassiter---pc---TimTrumble.jpg.jpg)
<figcaption>Karin Wolverton as Jane, Morgan Smith as Lassiter in *Riders of the Purple Sage*, Arizona Opera, 2017. Photo by Tim Trumble.</figcaption>
</figure>

## What are some of your favorite moments from the opera?

**LW**: My absolute favorite moment in this opera is the end of Act II when Jane brings Lassiter to Milly Erne's grave. Lassiter exposes his heart is such a raw and beautiful way. We all have a hard time not crying every time we get to that scene. The writing is truly spectacular. I also love the duets between Jane and Venters and Jane and Lassiter. They are touching and genuine and speak deeply to the human experience of longing, love, and friendship. 

**KW**: There are so many amazing moments in this opera but hands down my favorite moment is this little transcendent transition right before the grave scene. It’s an orchestral interlude, very short, and only four chords according to Craig. But what he manages to capture in those moments brings me to tears every single time I hear it.

>[Click here](http://www.azopera.org/performances/riders-purple-sage) for full details about Arizona Opera's Riders of the Purple Sage, running February 25 to March 5, 2017. For ticket info, [click here.](http://tickets.azopera.org/single/EventListing.aspx#riders)
