+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2019-11-02T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572741391/media/2019/11/sqAmyShoremountObra_AliseJordheim_piy3b9.jpg"
primary_image_credit = "Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman."
related_articles = ["articles/reliably-bubbly-belle-hélène-a-delight.md", "articles/grand-if-overlong-henry-viii.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = []
short_description = "\"I absolutely believe the program's assertion that Pacini was Rossini's main rival for the bel canto crown during the peak of his career.\""
slug = "revived-maria-regina-dinghilterra-a-crowd-pleasing-guilty-pleasure"
title = "Revived Maria, Regina d’Inghilterra A Crowd-Pleasing Guilty Pleasure"
youtube_url = ""

+++
I have a minor confession to make: with a few very notable exceptions, I have never understood the appeal of the bel canto opera to any opera-going audience. I find bel canto operas to be exceedingly fluffy affairs with music that is frequently either too cheerful to be dramatic, or too perfunctory and by-the-numbers to be comedic.

They are, with a few notable exceptions (primarily by Rossini and Bellini), operatic cotton candy: sweet, brightly-colored, and entirely full of hot air.

Thus, I approached Odyssey Opera's production of obscure bel canto composer Giovanni Pacini's _Maria, Regina d'Inghilterra_ with a very healthy amount of skepticism. I expected it to sound rather like a second-rate Donizetti, with all the musical and dramatic snags that such a comparison entails.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741457/media/2019/11/Ensemble_1_gv9w58.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

I was pleasantly surprised, therefore, to find that Pacini actually does get rather closer to Rossini and Bellini's abilities as a dramatic composer. Musically, there was quite a bit to like: while Pacini still falls victim to the cavatina/cabaletta convention that plagues almost every major bel canto composer's work, he manages to find ways to dramatically activate the cabaletta. He also frequently inserts an interjection into the time between the cavatina and the cabaletta to facilitate such dramatic activation, and the result is quite a nice breath of fresh air.

> It is rather easy to see why the original Victor Hugo play that Tarantini used as a source actually ended the career of one of its stars.

But it also helps that Pacini's score for _Maria_ is full of inventive uses of accompaniment, particularly in the last act. Of note was a duet between the meek, commoner-turned-noblewoman Clotilde and her betrothed Ernesto: their duet in the final act has them sing a line about how there is an angel in the flesh: when it goes to repeat this text, however, Pacini pauses the underlying oom-pah accompaniment with a single held chord under the text. The effect brings dramatic relevance to this repeat that is not lost on the listener.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741474/media/2019/11/Ensemble_3_ppkcwi.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

That is also to say nothing of the Act III march to the scaffold overseen by Clotilde and the Maria of the title: their vocal interjections over the slow gallows march were tense and nail-biting in a way I have rarely seen in the genre, and it ramped up the tension towards the show's denouement in a thrilling way.

> Lopreore's voice did not fray at all throughout the performance, and his beauty of tone remained constant throughout the performance.

Of course, that was once the audience got past the utterly ridiculous proceedings in the plot that led to that point, and on this front the audience did find perhaps unintentional amusement in Leopoldo Tarantini's libretto. It is rather easy to see why the original Victor Hugo play that Tarantini used as a source actually ended the career of one of its stars.

The title character does not even appear on-stage until the second act; the motivations of a couple of the major characters are not made entirely clear; some of the themes about xenophobia are not fleshed out at all; the stakes of a critical identity swap during the climactic execution in the third act is muddled and a touch confusing when you consider how it's paced; and there is a plot point surrounding Clotilde being the true heir of a family that reads as painfully clichéd by today's standards.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741489/media/2019/11/AlisaJordheim_AmyShoremountObra_wiruo1.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

It was full of rather silly plot developments, so the fact that Pacini was able to wrangle anything with drama out of that is a true testament to that, even when he falls victim to the trappings of the bel canto genre.

The only thing left at that point is to get singers who can meet the highly virtuosic demands of Pacini's score with a clear tone and technical precision, and on this front the entire cast delivered in spades. It should go without saying that Odyssey Opera's orchestra and chorus were in good form for this performance (and in fact, the chorus here was sounding the best I've ever heard it), but the leading players were all outstanding.

> Audiences, keep your eyes open: these two are singers to watch.

Amy Shoremount-Obra had to wait an entire act to enter as the title character, but once she appeared onstage she commanded the proceedings with a strong, authoritative tone that was as technically precise as it was brimming with emotion. Kameron Lopreore should also be commended for his turn as Richard Fenimoore, the man the queen favors: aside from the fact he is saddled with the unenviable task of making a somewhat unlikable character likable to the audience, the tessitura of the role sits rather high, and he can rarely catch a break through the whole work. But despite this, Lopreore's voice did not fray at all throughout the performance, and his beauty of tone remained constant throughout the performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741504/media/2019/11/AlisaJordheim_LeroyDavis_2_tgcbpi.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

In addition to them, James Delmer brought a certain amount of menace to the queen's deputy Churchill, who made the most of his scheming even if it was not entirely clear whether or not he was a villain of the piece.

Additionally, Alisa Jordheim and Leroy Davis absolutely stole the show as Clotilde Talbot and Ernesto Malcolm, respectively. Their roles are just as meaty as the two leading characters, but the fact they were given to two relatively younger singers was a very daring choice for Odyssey Opera. I dare say it was absolutely successful, however.

> Stage director Steve Maler's blocking felt a touch confused and unintentionally funny from time to time

Jordheim showed wonderful technical control with a voice that floated around comfortably. And then there was Davis, who essentially stole the show with a warm voice that had a deceptive technical proficiency and acting chops that easily out-acted the entire rest of the cast. Audiences, keep your eyes open: these two are singers to watch.

The strength of the cast was almost enough to overcome an uneven production, for they brought credibility to the characters' motivations even when the production got in the way. Stage director Steve Maler's blocking felt a touch confused and unintentionally funny from time to time: the way he has Churchill run away without being impeded even as Ernesto sings at him to stop running away seemed an odd choice entirely at odds with Pacini's music. He got an unintended laugh from the audience when Queen Mary stepped in front of Clotilde to hide her from Fenimoore just before their climactic Act II confrontation only for Queen Mary to reveal Clotilde not even five seconds afterwards.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741521/media/2019/11/Ensemble_Male_1_fxrubi.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

I also question why the design team created such a dark, dimly-lit set to work with: it allowed Queen Mary's red clothes to really pop more than they already did, but the darkness was almost oppressive in a way that works against the genre, and even if we are talking about the Tudor monarchy I also feel that it is entirely at odds when used in relation to this opera's Queen Mary, who is very willing to forgive Clotilde for her indiscretions and spends the entire third act trying to forgive Fenimoore for his sins.

> Perhaps it is time to revive Pacini more frequently.

This makes it downright infuriating, then, when compared with the absolutely stunning tableau that these people created for the execution scene close to the end of the work: the combination of a back wall of the set peeling up to reveal stark white (and then red) light and Lopreore walking up a staircase on wheels such that he remains framed by the light created such an arresting image that it helped ramp the tension up for the end of the work. It was nothing short of a great tableau, but I wish we had gotten such effective visuals throughout the first two acts of the show, because the result is uneven everywhere else.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572741534/media/2019/11/Ensemble_Male_2_fadtts.jpg){{% /md %}}

<figcaption>Odyssey Opera's production of Maria, Regina d'Inghilterra, 2019. Photo: Kathy Wittman.</figcaption>

</figure>

Still, the production that graced the Huntington Avenue Theater's stage was, on an overall level, much better than my admittedly low expectations led me to anticipate. I absolutely believe the program's assertion that Pacini was Rossini's main rival for the bel canto crown during the peak of his career, and if nothing else Odyssey Opera have shown that, even despite dramatic issues in the libretto and a staging that perhaps was not great all the way through, perhaps it is time to revive Pacini more frequently, particularly if everyone is performing his much more famous contemporaries to death.