+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-03-28T17:43:00+01:00"
lastmod = "2017-03-29T14:48:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490784548200/2017-03-29---Southbank.jpg.jpg"
publishDate = "2017-03-29T14:40:00+01:00"
related_articles = ["articles/he-saidshe-said-mozarts-requiem-at-tso.md","articles/paris-reflected-at-southwark-cathedral.md","articles/in-review-strauss-brahms-at-the-barbican.md"]
short_description = "The mass text exists well outside of the personal experiences of any composer who sets it; yet in the case of Bach, and the amount of sadness that followed him throughout his life, it&#039;s not difficult to imagine him speaking these desperate words in his own voice. Bach would consider that a great blasphemy, no doubt. A man almost as famous for his piety as for his music, it&#039;s no wonder he devoted himself and his extraordinary work to God."
slug = "review-the-personal-side-of-bachs-b-minor-mass"
title = "Review: the personal side of Bach&#039;s B minor Mass"
+++

It's a similar sentiment when we listen to Mozart's *Requiem*: J.S. Bach's B minor Mass is a work that feels inexplicably autobiographical. The mass text exists well outside of the personal experiences of any composer who sets it; yet in the case of Bach, and the amount of sadness that followed him throughout his life, it's not difficult to imagine him speaking these desperate words in his own voice. Bach would consider that a great blasphemy, no doubt. A man almost as famous for his piety as for his music, it's no wonder he devoted himself and his extraordinary work to God; even if he had lived in a time and place where religiosity had been less prevalent, the untimely deaths of both of his parents, one of his wives, and ten of his children wouold amount to reason enough to seek meaning in the church.

Albert Einstein said, "This is what I have to say about Bach's life's work: listen, play, love, revere - and keep your trap shut!" He was right, and he also captured the interesting duality of Bach's music. On the one hand, works like his B minor Mass are frighteningly difficult; the choral writing is unforgiving, the solo singers often find themselves cornered and oxygen-deficient, and the continuo player is charged with the harmonic mysteries in Bach's scores, some of which remain unsolved. On the other hand, Bach wrote most of his music for the weekly services at his local church; the odds are low that he would have had at his disposal the top-tier singers and orchestras, not to mention rehearsal time.

The combination of the [London Mozart Players](http://londonmozartplayers.com/), the [Lewisham Choral Society](http://lewishamchoralsociety.org.uk/), and the [Hackney Singers](http://hackneysingers.org.uk/), led by conductor Dan Ludford-Thomas, seemed to embody this duality in their performance of Bach's B minor Mass at the Southbank Centre. The two choirs outnumbered the orchestra by what seemed like at least 3 to 1, and their numbers created a visually arresting picture that seemed to speak to the widespread message of the Mass. 

The London Mozart Players rang through the wall of sound created by the combined choruses, playing with a beautifully transparent sound, like removing the back panel of a watch to see all the working parts. Sopranos Elin Manahan Thomas and Helen Meyerhoff sang with sounds that acted as lovely foils to each other, Manahan Thomas with a laser-like quality, and Meyerhoff with a rich warmth. The two perhaps should have traded parts; Manahan Thomas showed more strength in her middle register, despite her high tessitura as Soprano I, and Meyerhoff proved her sweet spot to be at the heights of Bach's Soprano II writing. Countertenor Roderick Morris sang with a shine in his sound, expressive even as he hovered high. David de Winter was a gentle, friendly-sounding tenor, taking great care with his attacks and keeping a frank, speech-like quality down low. Philip Tebb's bright baritone was honest and declamatory, cutting through the murky orchestration.

Despite a sound that craved more dynamic variation and awareness of text, the two community choirs seemed to play a role in Bach's dramatic work; the role of the masses packs a punch in this piece, as it does in other sacred favourites like the Requiems of Mozart and Verdi, or Beethoven's *Missa Solemnis*. 

Perhaps it counts as a downside to our loving focus on opera, to have a dearth of B minor Masses in one's life; though he didn't write opera (and we're not convinced it would be great if he had), Bach writes with operatic imagination and dramatic intuition. Hearing his masterpieces makes us think of the folks in Dresden who heard the first complete performance of the B minor Mass (an event Bach himself never saw in his lifetime), or even the people of Leipzig who heard his weekly cantatas.

There's more Bach coming up at the Southbank Centre, in The Bach Choir's performance of *St Matthew Passion*, **April 2nd, 11am**. For details and tickets, [click here.](https://www.southbankcentre.co.uk/whats-on/95916-bach-choir-st-matthew-passion-2017)
