+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-03-19T17:08:00-04:00"
lastmod = "2018-03-20T14:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521493648003/sq---Hypercube-2.jpg.jpg"
publishDate = "2018-03-20T14:25:00-04:00"
related_articles = ["articles/review-alice-and-the-patriarchy.md"]
short_description = "In the second section, the ensemble collectively sustained a layered, nuanced, morphing wail. Imagine an emergency foghorn exploding a metropolitan soundscape, triggering car alarms, and galvanizing old-timey constables to lay on their whistles. Think a Lichtenstein-ian Whaam! Blam! Pop! in musical form."
slug = "review-new-music-quartet-entertains-and-bores"
title = "Review: New music quartet entertains and bores"
+++

The American playwright David Mamet appeared on Marc Maron's [hit interview podcast WTF](http://www.wtfpod.com/podcast/episode-898-david-mamet) this week and unsurprisingly said, "the only thing theater's good for is to entertain people. It doesn't change the world." The part about changing the world is up for grabs. But what's not worth debating is that theater must entertain. Music must too. And contemporary classical music, in its nicher than niche microcosm, is particularly susceptible to forgetting that responsibility. What qualifies as entertaining falls on a broad continuum, but nothing risks boring an audience more than atonal new music that doesn't groove.

The quartet [Hypercube](http://www.hypercubemusic.org/home-1.html) performed a program of four, fearsomely difficult, single-movement contemporary pieces, as part of [Turtle Bay Artist's Series Make It New: A Festival of Cutting Edge Music](http://tbms.org/event/make-new-festival-cutting-edge-music/). Of the four works, only Sam Pluta's [*American Tokyo Daydream IV (data structures/monoliths)*](http://www.sampluta.com/compositionATDIV.html), updated for Hypercube's sax, electric guitar, accordion (or piano), and percussion ensemble, was as entertaining as it was rigorous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521493690358/Hypercube-1.jpg.jpg)
</figure>

According to Hypercube saxophonist Erin Rogers, Pluta's piece was "inspired by anime comics in which each page is a completely new picture." The result is sections, in this case two of them, that are distinct and self-contained, yet bound to a larger whole by a shared harmonic pallette.

First, ominous creaks erupted into brash stomping, as though a giant monster-baby were trucking through a metropolis, impetuously felling buildings at will. I couldn't help grinning gleefully as pounding percussion tore through a wall of roaring, distorted guitar.

In the second section, the ensemble collectively sustained a layered, nuanced, morphing wail. Imagine an emergency foghorn exploding a metropolitan soundscape, triggering car alarms, and galvanizing old-timey constables to lay on their whistles. Think a Lichtenstein-ian Whaam! Blam! Pop! in musical form.

Dennis Sullivan's [*under nails*](https://www.youtube.com/watch?v=oIUMLqcMNXs&feature=youtu.be) (one of two titles on the program to forego capitalization) is the kind of piece that expands an audience's hearing. The work kept the performers busy with all kinds of frenetic tapping, fiddling, and winding. Soft, often rapid, barely pitched sounds defined the sonic status quo. As respit, the ensemble united in delightfully odd tasks like winding up fishing lines hooked into the piano, or bowing brass wires attached to styrofoam orbs and tin cans. As the music faded to its end, the room's ambient noise took over. With the audience's ears finely tuned to timbral minutiae, it was like another movement had begun.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521493682935/Hypercube-3.jpg.jpg)
</figure>

In Nicholas Deyoe's world-premiere *they solidify then tilt*, composed for Hypercube, a yearning sax swelled out of enveloping accordian harmonies like the sound of worn out breaks echoing through a concrete parking garage. The electric guitar is the solo instrument. Its plunking, treble heavy timbre and whammy-bar pitch-bending distinguished it from the ensemble's accompanying texture. The work is too long and its microtonal motifs wear thin. A definitive climax is followed by excess material that makes you wish the piece would end already.

The program's closing number, [*Sahaf*](https://www.youtube.com/watch?v=AjIiJo5Gzo0), by Israeli composer Chaya Czernowin, gains dimension in live performance. A muted ratchet underscores intricate rhythmic outbursts from the ensemble. The percussionist, in an effective, understated element of visual storytelling, is like a conservatory-educated hurdy-gurdy grinder toiling away expressively on a severely limited instrument. 

Brief, unique cells of transitional music feature novel instrumental approaches that are both sonically and visually appealing. With her back facing the audience, pianist Andrea Lodge extracted wind chime-like tones with gasp-inducingly delicate keyboard glisses.

Composers must love hearing their music played by Hypercube. The ensemble has an ego-less, understated chemistry. The players are superb yet humble technicians. Execution takes precedence over theatricality as they cooly perform harrowing scores with fierce fidelity. Hypercube makes a strong case for continuing to increase the anything-is-possible electric guitar, piano/accordion, saxophone, percussion repertoire.
