+++
author = ["authors/greg.md"]
categories = "Review"
date = "2017-10-11T12:44:00-04:00"
lastmod = "2017-10-11T23:17:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741049261/2017-10-11---Arabella-MC-0724.jpg.jpg"
primary_image_credit = "Erin Wall as Arabella (foreground) and Jane Archibald as Zdenka in the Canadian Opera Company’s new production of Arabella, 2017, photo: Michael Cooper."
publishDate = "2017-10-11T22:49:00-04:00"
related_articles = ["articles/tim-albery-flawed-operas-falling-empires.md","articles/in-review-gotterdammerung-at-the-coc.md","articles/luxury-at-arms-length-arabella.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-santa-fe-opera.md","scene/companies/minnesota-opera.md"]
related_people = ["scene/people/erin-wall.md","scene/people/jane-archibald.md","scene/people/john-fanning.md","scene/people/megan-latham.md","scene/people/patrick-lange.md","scene/people/claire-de-sevigne.md","scene/people/corey-bix.md","scene/people/gundula-hintz.md","scene/people/michael-brandenburg.md"]
short_description = "Unlike the song-dialogue-song-dialogue-duet-quintet-dialogue-finale formula of operetta - which uses dance forms like polka, czardas, and waltzes - in Arabella, we find characteristic soaring beauty and dramatic pulse in a through-composed score which is what we love about Herr Strauss&#039;s music. The appealing play between consonant and dissonant harmonies, lush strings, and emphatic brass were handled masterfully well from the pit under the baton of maestro Patrick Lange. "
slug = "review-arabella-or-poor-little-rich-girl"
title = "Review: Arabella, or &quot;Poor Little Rich Girl&quot;"
+++

Heya, Schmop-Tops! Your friendly neighbourhood [Greg](/authors/greg/) is back to start off my season, and let me tell you, it starts on a high note - lots of 'em!

My first offering this season is 1933's [*Arabella*](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx) by Richard Strauss presented by the Canadian Opera Company, in co-production with Santa Fe Opera and Minnesota Opera. Although regularly performed in opera houses across Europe, this marks what may well be the Canadian premiere of the piece.

Composed by Strauss alongside his longtime librettist Hugo von Hoffmansthal (*Ariadne auf Naxos*, *Der Rosenkavalier*, *Elektra*), in 1933 had its premiere performance on the stage of the Sächsisches Staatstheater in Dresden. As some of you may, or may not, know, I've spent a large part of my career singing operetta, which emerged from places like Vienna and Budapest leading up to the start of WWI and the fall of the Austro-Hungarian Empire. So, you can imagine how chuffed I am that Arabella's plot is very much true to an operetta plot. Rich family is no longer rich. Dad is irresponsible but lovable. Daughter is being married off to regain status and wealth. There's a stranger and there's someone in disguise both of whom act as major catalysts to the plot. The similarities go on and on (singing about drinking, temper tantrums, illicit affairs). 

The difference here is obviously the score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741072815/2017-10-11---Arabella-MC-0115.jpg.jpg)
<figcaption>(l-r) Erin Wall as Arabella and Jane Archibald as Zdenka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Unlike the song-dialogue-song-dialogue-duet-quintet-dialogue-finale formula of operetta - which uses dance forms like polka, czardas, and waltzes - in *Arabella*, we find characteristic soaring beauty and dramatic pulse in a through-composed score which is what we love about Herr Strauss's music. The appealing play between consonant and dissonant harmonies, lush strings, and emphatic brass were handled masterfully well from the pit under the baton of maestro [Patrick Lange](/scene/people/patrick-lange/). The opening felt a little rocky (for like 6 measures) and the harmonies had that cloudy effect that happens when you're flipping through radio stations and your ears need a minute to adjust from Beyoncé and Jay-Z (I like to say Jay-Zedd because #Canadian) to Tom Petty (RIP.) That being said, when it cleared up, almost instantly, it had a neat effect of lifting an auditory curtain or tuning in to a broadcast. 

Strauss is known for writing *amazing* female vocal lines, and *Arabella* is no exception. Everyone, from the title character to the Fiakermilli to the Fortune Teller, is given music that allows their beautiful instruments to bloom and enwrap (and enrapt) you. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741145606/2017-10-11---Arabella-MC-1043.jpg.jpg)
<figcaption>(foreground) Erin Wall as Arabella and Michael Brandenburg as Matteo with (background) Gundula Hintz as Adelaide and John Fanning as Count Waldner in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

In the title role [Erin Wall](/scene/people/erin-wall/) is stunning. Her voice was free, open, and generous, a powerful instrument that didn't lose a single ounce of beauty even it at its largest production. It had both strength and sparkle like a large lake in the summer sun. I'm not the first to praise Ms. Wall for the beauty of her execution of this music and I won't be the last - but it was her portrayal of this fallen aristocrat who believes in love and freedom that drew me even further in. It's a delicate tight-rope for Arabella to walk in the first act - to play the role of the aristocratic young lady in the process of courting suitors, while seeing her sister Zdenka forced to hide as a boy, all due to their recent destitution at the hands of their gambling father - and keep her from reading as manic is no easy task - so for fun let's just throw some Strauss on there. Wall is not only equal to the challenge, she excels.

COC's first artist-in-residence [Jane Archibald](/scene/people/jane-archibald/) tackles the role of Zdenka (Zdenko when people are around), the younger sister of Arabella forced to present as a boy because the family is too poor to bring out two young women into high society. I was curious to hear Archibald sing Strauss, as my experience with her has been mostly in Handel and Mozart, and I was thrilled. On top of agility and beauty, Archibald has a masterful control of the size of her instrument. Her characterization was bang-on as a young woman wrestling with love and hiding her true identity. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741199898/2017-10-11---Arabella-MC-0629.jpg.jpg)
<figcaption>Erin Wall as Arabella and Tomasz Konieczny as Mandryka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Making an incredibly impressive COC debut was bass-baritone [Tomasz Konieczny](/scene/people/tomasz-konieczny/) in the role of the handsome stranger Mandryka. A big voice that sailed through the house that was full of beautiful rich tone throughout. Despite a darkness to his sound, he still had an incredible cut or "spin" to his voice that carried the music into the hall and made it look effortless. His characterization of a young widower who is ruled by his impulses and his heart had a zest and a vitality to it that shone throughout the production. Even as his character is tested and gets a little ugly, you are still on his side. His charisma shines throughout. I look forward to many more visits from this Polish singer. He was phenomenal. 

As the lovesick soldier Matteo, American tenor [Michael Brandenburg](/scene/people/michael-brandeburg/) also makes his COC debut. In a perfectly melodramatic portrayal, Mr. Brandenburg sounded every bit the lyric tenor one begs for. His relationship to Zdenko has a wonderful chemistry that totally supports his actions in the denouement. His tone was bright and steely, and he had a breath that seemed to last forever. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741166186/2017-10-11---Arabella-MC-0680.jpg.jpg)
<figcaption>Michael Brandenburg as Matteo and Jane Archibald as Zdenka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

As Arabella's parents Adelaide and Waldner, mezzo-soprano [Gundula Hintz](/scene/people/gundula-hintz/) (another COC Debut) and baritone [John Fanning](/talking-with-singers-john-fanning/) are wonderful. Adelaide's determination to continue on as if her world isn't crumbling around her and looking to the supernatural to support her in her fears and desires is actually a nice moment of levity in this comedy of manners. As the gambling yet honourable Count Waldner, Fanning is equal parts fiercely loyal family man and bumbling dolt. Their voices and chemistry were on point all night and I looked forward to every one of their entrances. 

Arabella's three suitors, Count Elemer, Count Dominik, and Count Lamoral - sung by tenor [Corey Bix](/scene/people/corey-bix/) (another COC debut), baritone [Craig Irvin](/talking-with-singers-craig-irvin/), and COC Ensemble Studio Member [Bruno Roy](/scene/people/bruno-roy/) (respectively) - were all excellent in their roles as suitors. I felt as though Irvin may have been a little under the weather vocally, however his characterization shone through. 

As The Fiakermilli, COC Ensemble Studio graduate soprano [Claire de Sévigné](/scene/people/claire-de-sevigne/) stole the show when she entered the stage. Not only because she was the only one dressed in a vibrant scarlet and incredibly beautiful riding costume, but because her colouratura was breathtaking, with incredible agility in the melismas and high notes that were clear and sailing and sparkling. She's turning heads on world stages and it's not hard to see why. 

As the fortune teller, mezzo-soprano [Megan Latham](/scene/people/megan-latham/) opened the show with a powerful medium setting up the entire plot in a few minutes. She sounded magnificent when singing alongside Hintz. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507741233251/2017-10-11---Arabella-MC-0856.jpg.jpg)
<figcaption>Claire de Sévigné as the Fiakermilli and Tomasz Konieczny as Mandryka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

The direction by [Tim Albery](/tim-albery-flawed-operas-falling-empires/) was clean and presentational. It hearkened to the classic operettas that were dominating the theatres during the time of the play's exposition. I felt that some of the scenes of misunderstanding were played a little heavy which robbed some of the scenes of some great moments of real comedy which Hoffmansthal was so adept is slipping into various corners of the text - e.g. Zdenka forgetting she's supposed to be a boy when she snuggles to Matteo, and Dominik and Adelaide discussing their tryst. There were also lots of chances for hearty laughs simply due to the comedy of manners. The show is still a comedy in the Shakespearean sense in that no one dies and people get married at the end - but there were a few moments that could have been hilarious if they'd had a chance to breathe. 

The set and costume designs by Tobias Hoheisel evoke the period of falling opulence with tarnished mirrors and silver paint adorning the hotel in which the play takes place. The costumes were delightfully of the period. I just longed for a little more contrast or use of complementary palettes in the colour scheme between the set and the costumes. 

I feel like Strauss is not done anywhere near enough here in Toronto, considering the calibre of talent available to bring such stunning pieces to life. This is why I'm glad that the COC opened their season with such a masterpiece and look forward to many more to come. 

Get your tickets soon! The [show runs until October 28](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx).
