+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-03-21T20:11:00-04:00"
lastmod = "2018-03-21T20:11:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521677311730/sq---ALICE_Adela-Wagner-1.jpg.jpg"
primary_image_credit = "Composer Mary Prescott in dress rehearsal for ALICE. (l-r) Hannah Kurth, Blake Burroughs, Augusta Caso, Mary Kate Vom Lehn, Sara Noble, Mary Prescott, Katie Zaffrann, Cara Search, Kannan Vasudevan. Photo credit: Adela Wagner."
publishDate = "2018-03-21T20:11:00-04:00"
related_articles = ["articles/review-new-music-quartet-entertains-and-bores.md","articles/spotlight-on-jeremy-hirsch.md"]
short_description = "The gallery setting served Prescott&#039;s creation. The piece thrives on intimacy. The audience benefits from the freedom to wander around, whisper to their neighbor, and collectively figuring out how to behave in and interact in the brightly lit environment."
slug = "review-alice-and-the-patriarchy"
title = "Review: ALICE and the Patriarchy"
+++

Composer Mary Prescott is easy to root for. Spend a few afternoons churning through [*Where We Go When*](http://mary-prescott.com/wherewegowhen/?offset=1314062220000), and you'll see what I mean.

Prescott's latest work in progress is *ALICE: An Immersive Chamber Opera*, installed in the Areté Venue & Gallery where she is currently artist-in-residence.

ALICE (Jeanai La Vita), dressed in white, sits in the center of a small room, her face frozen in a sullen mask. She doesn't notice four simultaneous mini dramas repeating around her. An adult representing a child sings "Ring Around the Rosy" and plays cat's cradle with a woman in a white dress. A mother quotes Rapunzel to a different woman, also in a white dress. A priest castigates a third, similarly dressed woman. And a man in a red sweater has a lover's quarrel with a fourth woman in white.

The women are given a strip of colored cloth and a mantra to repeat ("We all fall down", "Snip, snap, cut if off", "You are not your own"). They bring their cloth strips to ALICE and wrap them around her in accumulating layers. The women repeat these actions until ALICE is up to her neck in fabric.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521677399856/ALICE-performance-photo_Mary-Prescott.jpg.jpg)
<figcaption>Five Alices: (l-r) Sara Noble, Mary Kate Vom Lehn, Jeanai La Vita, Katie Zaffrann, Cara Search. Photo credit: Mary Prescott.</figcaption>
</figure>

Then everyone gathers around ALICE, who begins to chant in long, unadorned lines that gradually intensify in pitch and volume. The chorus joins her. A chordal, odd-metered piano accompaniment repeats and grows with the voices to a ringing climax. The music peters out and everyone exits one by one. They say "Wash it away" as they go. Alice slowly untangles her cocoon, drops it like a skirt, and, repeating the same sentence, leaves.

Opera singers tend to learn the unfortunate stage habit of speaking in an overly-resonated, sustained, quasi-legato voice that sounds totally unlike normal human conversation. There was a lot of that going on. One problem with this grand rhetorical style is that intimate dialogue becomes melodramatic, particularly when the lines have a poetic quality (Prescott culled texts from The Brothers Grimm, the Bible, Neruda, and her own writing).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521677427317/ALICE_Adela-Wagner-2.jpg.jpg)
<figcaption>Composer Mary Prescott in rehearsal for ALICE: (l-r) Mary Prescott, Jeanai La Vita, Sara Noble. Photo credit: Adela Wagner.</figcaption>
</figure>

After listening to Prescott's piano improvisations, I eagerly looked forward to hearing her notated music. The fundamental language was the same. I wondered if Prescott's tendency towards modal counterpoint would show up. Not so much. But other hallmarks of her style were present. Plaintive melodies climbed over relatively stable ostinati and chord progressions, a trill in the clarinet referenced her tendency towards tremolo, and sneaky dissonances hidden in the outer reaches of the piano consistently and subtly destabilized harmonies.

The gallery setting served Prescott's creation. The piece thrives on intimacy. The audience benefits from the freedom to wander around, whisper to their neighbor, and collectively figuring out how to behave in and interact in the brightly lit environment. I first sat cross-legged on the floor, and as the action reached full tilt, a woman on my left turned to me, looked me in the eyes, smiled and said, "Don't leave me alone for a minute in here."
