+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-09-28T15:47:00-04:00"
lastmod = "2017-09-29T13:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506628223807/2017-09-28---square---TMC-Russell-Braun-Erin-Wall-Peter-Oundjian-Jag-Gundu.jpg.jpg"
primary_image_credit = "The Toronto Mendelssohn Choir, Russell Braun, Erin Wall, and Peter Oundjian. Photo: Jag Gundu."
publishDate = "2017-09-29T12:26:00-04:00"
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/erin-wall.md","scene/people/russell-braun.md"]
short_description = "The three violin parts seem to babble, talk over each other, like a gaggle of enthusiastic talkers whose conversation borders on an argument. They echo each other in a three-fold cascade of gesture, single pitches splicing themselves into harmonies; there are moments of Strauss-like vocal writing, and what feels like an exciting nod towards the Toccata movement from John Adam&#039;s Violin Concerto."
slug = "review-a-triple-concerto-a-german-requiem-with-the-tso"
title = "Review: a Triple Concerto &amp; a German Requiem with the TSO"
+++

Peter Oundjian calls it "surely one of the most remarkable concerts of the year," the TSO's current program of Alexina Louie's *Triple Concerto for Three Violins and Orchestra* (a world premiere and TSO co-commission) and Brahms' iconic *Ein deutsches Requiem*, Op. 45. It's not totally clear what the link between the two pieces is, but when it comes to hearing Brahms' *Requiem*, at least, I have no objections.

Louie's *Triple Concerto* was written to bring together the concertmasters of three of Canada's best orchestras: the TSO's Jonathan Crow, the National Arts Centre Orchestra's Yosuke Kawasaki, and the Orchestre symponique de Montréal's Andrew Wan. The piece makes great use of the novelty of featuring three soloists, and Louie makes a clear point of writing an equally large number of notes for each violinist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506628287362/2017-09-28---Jonathan-Crow-Yosuke-Kawasaki-Andrew-Wan-Peter-Oundjian-Jag-Gundu.jpg.jpg)
<figcaption>(l-r): Jonathan Crow, Yosuke Kawasaki, and Andrew Wan. Photo: Jag Gundu.</figcaption>
</figure>

The three violin parts seem to babble, talk over each other, like a gaggle of enthusiastic talkers whose conversation borders on an argument. They echo each other in a three-fold cascade of gesture, single pitches splicing themselves into harmonies; there are moments of Strauss-like vocal writing, and what feels like an exciting nod towards the Toccata movement from John Adam's *Violin Concerto*. 

Louie's piece seemed to spend time in a slightly meandering pace with still harmonies; it certainly found its way to an exciting peak at its close, yet the sheer drama available to the Triple Concerto genre felt short-changed. Perhaps that drama wasn't helped by the acoustic and visual space of Roy Thomson Hall. The three solo players blended their sounds too well with their orchestra, and it seemed a shame not to have Crow, Kawasaki, and Wan right downstage like the focal points they were meant to be. Like their sounds, their tuxes blended in with the rest of the Toronto Symphony Orchestra.

For the second half, the TSO was joined by the Toronto Mendelssohn Choir, and soloists [Erin Wall](/scene/people/erin-wall/) and [Russell Braun](/scene/people/russell-braun/). I'm not shy about admitting how much I love Brahms' *German Requiem* - most music by Brahms, in fact - and so it's always a must-see when I'm presented with the chance to hear it live. The TMC sounded spectacular under the direction of Noel Edison, as did the solo singing by Braun and Wall - Wall in particular filled the Hall with her stunning soprano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506628294774/2017-09-28---Russell-Braun-Erin-Wall-Peter-Oundjian-Jag-Gundu.jpg.jpg)
<figcaption>(l-r): Russell Braun, Erin Wall, and Peter Oundjian. Photo: Jag Gundu.</figcaption>
</figure>

Still, I can't deny that the *German Requiem* is flawed. It's too long at times, there's too much of the same tempo between movements, and Brahms is notoriously stingy with his moments of blissful musical satisfaction. That utterly awesome moment of "Denn alles Fleisch" is just too brief, no? The warm uniformity of the Toronto Mendelssohn Choir, the moving performances by Braun and Wall, and Oundjian made sure the piece tumbled forward as much as it can. There's always been something appealing and underdog-like about Brahms' music; the way he overthinks things has its charm, especially when the overthinking culminates in those moments of wash-right-over-you beauty - though they may leave you wanting more - that seem at once created and evoked.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506628315321/2017-09-28---Russell-Braun-Erin-Wall-Peter-Oundjian-TMC_2-Jag-Gundu.jpg.jpg)
<figcaption>(l-r): Russell Braun, Erin Wall, and Peter Oundjian.Photo: Jag Gundu.</figcaption>
</figure>

And so, I forgive the bits that go on too long, and the all-too-common presence of the word "Langsam" throughout the score.

The TSO reprises the Requiem until September 30; you can find full details and ticket info [right here.](https://www.tso.ca/concert/brahms-german-requiem)
