+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-05-24T09:59:00+01:00"
lastmod = "2016-05-24T13:22:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464083865911/2016-05-24---Southbank.gif"
publishDate = "2016-05-24T13:22:00+01:00"
related_articles = ["articles/he-saidshe-said-mozarts-requiem-at-tso.md","articles/heavy-nights-schoenberg-brahms-the-lpo-and-goerne.md"]
related_people = ["scene/people/david-soar.md","scene/people/maria-gulik.md","scene/people/john-hudson.md"]
short_description = "From our place in history, with well over a century of hindsight, Verdi&#039;s Requiem can feel like a meta work; it&#039;s as though these beloved characters make a cameo, like a &quot;operatic special&quot;, sharing the stage to perform a work that seems to evoke a first-person delivery by Verdi of these texts."
slug = "requiem-on-the-south-bank"
title = "Requiem on the South Bank"
+++

Verdi's *Requiem* is surrounded, on all sides, by opera. It was written between *Aïda* and *Simon Boccanegra*, and the soprano solo was sung often by Teresa Stolz, who sang the title role in *Aïda*'s European premiere in Milan. The *Requiem* was initially in memory of Rossini; later, Verdi revised the "Libera me" to remember the poet Alessandro Manzoni, most famous for his *I promessi sposi* (*The Betrothed*).

As we heard the English Philharmonia Orchestra and Chorus perform Verdi's sacred work at the Royal Festival Hall last night, time and time again, scenes from his operas appeared in our heads. The orchestra had the sounds of *Aïda*'s Grand March, the hazy opening of *La traviata*, and the aggresive thrusts of *Rigoletto*. The choral writing made us remember the "Miserere" from *Il trovatore*, and that awesome beginning to *Otello* (despite its being written after the *Requiem*). The soloists seemed plucked from operatic hits; there was a Simon Boccanegra, a Riccardo (*Un ballo in maschera*), an Amneris (*Aïda*), and a soprano that recalled Leonora, Aïda, and Amelia. 

Like most of his hits, Verdi wrote the *Requiem* after the deaths of two children and his first wife, and after years of societal judgement of his relationship with Giuseppina Strepponi; the pair finally married after years of what was perceived as "living in sin", and Strepponi's history of multiple relationships and illigitimate children only fuelled holier-than-thou objections from the Italian public.

With Rossini, to whom the *Requiem* was intially dedicated, Verdi shared the obvious: the two made their lives composing opera. Yet perhaps Verdi connected more closely to Manzoni, who struggled with the church's place in his life, and who too suffered the loss of his first wife and several children.

From our place in history, with well over a century of hindsight, Verdi's *Requiem* can feel like a meta work; it's as though the four soloists are these beloved operatic characters making a cameo appearance, like a "operatic special", sharing the stage to perform a work that seems to evoke a first-person delivery by Verdi of these texts.

We loved the reedy, open sound from bass [David Soar](/scene/people/david-soar/), and mezzo-soprano [Maria Gulik](/scene/people/maria-gulik/) had lovely warmth in the depth of her range. Soprano [Naomi Harvey](/scene/people/naomi-harvey/) floated stunning sounds above the quartet of soloists, and brought her operatic experience to Verdi's *La forza del destino*-inspired "Libera me" to close the evening. Tenor [John Hudson](/scene/people/john-hudson/) gave us moments of an exciting instrument, for our taste too often held back. 

The [English Philharmonic Orchestra and Chorus](http://www.englishphilharmonia.co.uk/content/11-our-orchestra) under Music Director Graham Wili, were impressive in size, and paired hushed sounds with thrilling moments of volume, like the always-amazing "Dies irae". Verdi's *Requiem* is a big ask for any ensemble, including this freelance orchestra and chorus of amateur singers. Verdi's tight rhythms felt lax at times, and the visual element of the mass of musicians onstage could have stayed a bit more stoic to match the music. Yet Verdi's writing stands for itself, and the *Requiem* has extraordinary power to move listeners.

The work was, at the time of its premiere, informally considered to be Verdi's last work. It's as though the composer was inspired further by his own *Requiem*, perhaps ironically pouring out his four last operas (*Simon Boccanegra*, *La forza del destino*, *Otello*, and *Falstaff*), as a way of fleshing out the possibilities of the music in its sacred setting. Verdi always had that way of combining personal honesty with stories and music that feel larger than life.
