+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-23T20:55:00-04:00"
lastmod = "2018-04-25T12:40:00-04:00"
preamble = "**May 4 and 6**, the second annual Vancouver Opera Festival presents the chamber musical, [*Requiem for a Lost Girl*](https://www.vancouveropera.ca/2016/02/27/requiem-lost-girl-chamber-musical-homelessness/). Presented in collaboration with The Kettle Society and in cultural partnership with SFU's Goldcorp Centre for the Arts, *Requiem* is composed and conducted by Marcel Bergmann, and written and directed by Onalea Gilbertson with  writing and additional music by the Kettle Choir and Writers Guild; it will be performed by soloists from the Yulanda M. Faris Young Artist Program, members of the Vancouver Opera Chorus, the Vancouver Opera Orchestra and The Kettle Choir and Writers Guild. \n\n[*Requiem for a Lost Girl*](https://www.vancouveropera.ca/2016/02/27/requiem-lost-girl-chamber-musical-homelessness/) memorializes a young woman lost to the streets, exploring themes of homelessness, poverty, addiction, mental illness, and the plights of missing and murdered indigenous women.\n\nWe spoke with Gilbertson, and *Requiem* performer [Stephanie Tritchew](/spotlight-on-stephanie-tritchew/) about this must-see, powerful piece of theatre:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524531251010/sqRequiemforaLostGirl.jpg.jpg"
publishDate = "2018-04-25T12:40:00-04:00"
related_articles = ["articles/i-wrote-toward-tomorrow-to-bring-attention-to-this-crisis.md"]
related_companies = ["scene/companies/vancouver-opera.md","scene/companies/vancouver-operas-yulanda-m-faris-young-artists-program.md"]
related_people = ["scene/people/stephanie-tritchew.md"]
short_description = "&quot;The tragedy of her death and stigma that surrounded it is still with me. This experience is how I found my way into the themes of this piece.&quot;"
slug = "requiem-for-a-lost-girl-is-based-on-a-true-story"
title = "&quot;Requiem for a Lost Girl is based on a true story.&quot;"
+++

### What questions about homelessness and addiction does *Requiem for a Lost Girl* strive to answer?

**Onalea**: *Requiem For A Lost Girl* is based on a true story about a friend I lost to the street when I was 15 years old.  In the span of six months, she found herself homeless, addicted to drugs and working in the sex trade to survive. Then someone killed her. When the media reported on her murder, she was shamed and stigmatized for making money to survive in a "high-risk way". I deeply disagree with this phrase; that sentence alone fueled this work. This article treated her as though she was less than - and not deserving of the same kind of response or dignity surrounding her death as someone else in society might have been.

The tragedy of her death and stigma that surrounded it is still with me. This experience is how I found my way into the themes of this piece.

*Requiem* wants to bring attention to stigma around homelessness, poverty, addiction, mental health concerns and missing and murdered women. *Requiem* strives to erase the line between "us and them", to shine light into the darkness, and to encourage the world to turn the "ladder of success" on its side, away from hierarchy and competition towards cooperation and harmony. Homelessness is something someone is experiencing - not something they are.

People who are addicted to substances are human beings that deserve compassion, respect and medical treatment.  Mental illness does not define who you are as a person.

Our society wants to criminalize people experiencing poverty, rather than address the structures that keep systemic poverty and trauma in place. We need to raise our collective voices to call attention to this.  We need to end stigma and we need affordable housing for all people.  Now.

People become homeless for numerous and complex reasons including:  lack of affordable housing, poverty, trauma, addiction, mental health concerns, divorce, death in the family, gentrification, being discharged from correctional facilities, hospitals or foster care with nowhere to go, domestic violence, cultural genocide, displacement from lands and lack of affordable housing.

Our cast members know firsthand the experience of homelessness. Every performer has been in touched in some way by loss. The raw truth of their lived experiences is at the heart of the opera. The most important part of this work has been the process of community building that emerged as we explored, documented, wrote and sang about the humanity of all people. 

**Stephanie**: I would like to use a quote from the piece to help me answer this question. This text is written by Onalea Gilbertson:
 
*If greed is gone<br>
where will I deposit my desire<br>
what other things will rise to satiate this fire<br>
that burns me from the inside out<br>*

We live in a society that has conditioned us to consume. We are told we will find satisfaction in purchasing new things; we will be more desirable (or even just feel good!) if we colour our hair, have freshly manicured nails or get another piercing; dining out at restaurants is the best way to develop relationship with colleagues — bars even call it "Happy Hour." We are all guilty of over-consumption but it isn't our fault. We have been conditioned to fill our emptiness (read: work stress, family stress, financial stress, relationship stress, general discontent) with whatever we can to fill the void.

What would it look like to live with less — to actually work within yourself to address your feelings of emptiness or discontent? The members from the Kettle Society have lived with much less consumerism. "If greed is gone, where will I deposit my desire?" I don't necessarily think that *Requiem for a Lost Girl* answers that question, but I think it certainly raises that question. It has definitely made me think a lot about that.

It goes without saying, this piece also serves as a reminder. Every person you see standing in line for a shelter or asking for change has a story — we have no idea what kind of trauma, loss or challenge they have endured. No one wants to experience homelessness and no one wants to struggle with addiction. I think this piece reminds us to practice compassion and empathy; it might even inspire us to bring someone in need a warm drink on a cold day or smile and say hello as you approach them. A little kindness can go a long way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524674259868/OnaleaGilbertsonHeadshot.jpg.jpg)<figcaption>Onalea Gilbertson, writer and director of *Requiem for a Lost Girl*.</figcaption>
</figure>

## What role do pieces of theatre like *Requiem* play in activism?

**Onalea**: Our script's mandate is for a community organization or shelter to partner with a performing arts organization to co-create music and writing workshops to facilitate the creation of unique original material that will appear alongside our 14 songs in each community *Requiem* is performed in.  It is our desire that the workshops continue after the show has performed and that the legacy of community building, art making and performance that has been initiated can continue after the show moves on.

We have been working here in Vancouver with The Kettle Society for 2.5 years where the team has created weekly choir, writing and sing along sessions.

*Requiem* is a hybrid and multidisciplinary work.  It combines art forms (theatre, opera, contemporary classical music - integrating elements of poetry, spoken word, jazz and folk styles). 

We play a role of connecting people through these different styles and forms.  Working in outreach.  Introducing groups of people who may have never met otherwise - to help break down stereotypes and build bonds - both for the people involved and for the audience who gather to experience the final piece. Co-creating community and actively encouraging dialogue and discussion to facilitate social change.  It is very important for people to have a chance to meet and hear from those in community that they might otherwise just "walk on by" and develop stereotypes about without ever having listened to their story.

*Requiem* strives to amplify voices that might not otherwise be heard - and invites people who have lived experience of the themes directly into the piece.

I believe it is essential to engage directly with the community as an artist - we are co creating community and actively encouraging discussion and communication between groups of people who may have never encountered each-other before.  The process of building the show is as important as the show itself.  In addition to being a powerful experience for an audience, the piece affects and involves people on all levels of the organization from both communities involved in the process. 

**Stephanie**: *Requiem for a Lost Girl* is such a unique piece of theatre because it gives voice to members of society who have experienced or are currently experiencing homelessness or addiction. It isn't like other social-justice pieces where professional singers are portraying the characters in an effort to raise awareness. Members of the Yulanda M. Faris Young Artist Program and members of the Vancouver Opera chorus are participating to give musical support to the Kettle Choir, the real stars of the show. We are not telling their stories; they are telling their stories. This piece is amazing because it gives an opportunity for members of the Kettle Society to express themselves through their own written word and music, and provides a platform for them to be heard.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524674216103/TRITCHEW.STEPHANIE.HEADSHOT.jpeg)<figcaption>Stephanie Tritchew, mezzo-soprano in the Yulanda M. Faris Young Artist Program, and performer in *Requiem for a Lost Girl* at the Vancouver Opera Festival, 2018.</figcaption>
</figure>

## What do you hope audiences will take away from these performances in Vancouver?

**Onalea**: 

*Recognize the humanity in all people.  We have more in common than in opposition. See people as people not statistics. Smile at people.   Throw away your judgments and your criticisms and let the stigma die.*

*End the stigma against homelessness, poverty, mental illness and addiction. End the stigma against sex trade work and workers, stigma kills.*  

*Affordable housing and adequate food for all are basic human rights (UN declaration article 25).*
*Recognize and understand you don't know the whole story.*

*Listen more!* - (Excerpts taken from "the Manifesto" in *Requiem For a Lost Girl* by the Kettle Writers Guild)

Evolution, advocacy and activism in our culture is needed. We are not powerless.

When we share and collaborate with our community, (talking to people not about people) we can effect change in both bold and nuanced ways.  Music, poetry and theatre are powerful tools of community building and social transformation.   

My hope is that you leave the theatre transformed. That you take a moment to see the people living on the street and don't rush by them.  That you begin to understand the complexities of homelessness and the systems and lack of action in our society that perpetuate and cause these problems.  That you consider others with empathy and compassion. That you recognize the importance of your voice and use it to make change. All of our voices are important, there are artists all around us and what they have to say is revolutionary.

**Stephanie**: I think Ruth Witt, one of the members from the Kettle Society, says it much better than I ever could. This is an excerpt from her work, *When I Believed in Someone*:

"Many times in life we are dropped. Crumpled and ground into the dirt.<br>
By the choices we make<br>
By choices made for us<br>
By the circumstances that have come our way.<br>
Circumstances we can do little about. We all have challenges.<br> 
Sometimes those challenges are hard to bear.<br>

But no matter who we are we are still priceless human beings.<br>
The worth of our lives does not come to us by what we do or do not accomplish.<br>
By what we do or do not achieve.<br>
Whether we are young or old.<br>
In health or in illness.<br>
We are still priceless.<br>"

I hope audiences remember that every time they walk past a person begging for change, or food, or experiencing homelessness. These words were written by one of those people.

>[Requiem for a Lost Girl](https://www.vancouveropera.ca/2016/02/27/requiem-lost-girl-chamber-musical-homelessness/) runs May 4 (7:30pm) and May 6 (2pm) at the Fei and Milton Wong Experimental Theatre at SFU's Goldcorp Centre for the Arts. For details and tickets, [click here.](https://www.vancouveropera.ca/2016/02/27/requiem-lost-girl-chamber-musical-homelessness/)
