+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-08-03T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1596482990/media/2020/08/sqFlemingPPV_vtprx1.jpg"
primary_image_credit = "Soprano Renée Fleming and pianist Robert Ainsley in the Music salon at Dumbarton Oaks as part of the MET Stars Live concert series. Photo: Metropolitan Opera."
related_articles = ["articles/the-met-s-at-home-gala.md", "articles/tosca.md"]
related_companies = []
related_people = ["scene/people/renee-fleming.md"]
short_description = "Renée Fleming knows her audience, or in this case, the lack of one. Creating a sense of intimate occasion in the elegant music salon at Dumbarton Oaks, a Georgetown estate with a musical pedigree of its own, Fleming made her contribution to the Metropolitan Opera's MET Stars Live streaming concert series feel like a musical get-together. "
slug = "renee-fleming-brings-a-new-luster-to-dumbarton-oaks"
title = "Renée Fleming Brings A New Luster To Dumbarton Oaks"
youtube_url = ""

+++
Renée Fleming knows her audience, or in this case, the lack of one. Creating a sense of intimate occasion in the elegant music salon at Dumbarton Oaks, a Georgetown estate with a musical pedigree of its own, Fleming made her contribution to the Metropolitan Opera's MET Stars Live streaming concert series feel like a musical get-together. The audience in the salon consisted of four cameras, two of them robotic, and rapt on-line viewers everywhere.

Opening unaccompanied with John Corigilano's "And The People Stayed Home", his effecting setting of Kitty O'Meara's viral poem that purposefully wanders through everyone's pandemic, the soprano's warm informality was a reassuring balm. Sung primarily in the middle range voice reserved for popular song, Fleming was the empathetic friend with soft words of comfort until the poem touched on the fears associated with these uncertain times when it edged into the darker reaches of her celebrated lyric soprano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596483185/media/2020/08/FlemingPPV-2_gec8co.jpg){{% /md %}}

<figcaption>Soprano, Renee Fleming in recital in the music salon at Dumbarton Oaks as part of the MET Stars Live Concert series. Photo: Metropolitan Opera.</figcaption>

</figure>

With barely a breath following the Corigilano pianist Robert Ainsley began "Calm thou my soul...Convey me to some peaceful shore" from Handel's _Alexander Balus_, Cleopatra's poignant lament for peace of mind, in which Fleming produced sparkling ornamentation. This completed an opening duo that aptly reflected the circumstances. Sharing with us that Handel and Corigilano had composed these emotionally compatible works 300 years apart, the room's resonant acoustics emphasized its emptiness when Fleming spoke. But how her singing filled it.

> We were treated to early video footage from Fleming's home and school days which was not unwelcome.

More Handel followed with Delilah's "To fleeting pleasures make your court" from  _Samson_ _and_ _Delilah_ and "Endless pleasure, endless love" from his _Semele_, both rendered with mischievous spirit as they lifted the mood and completed the baroque portion of the recital. Fleming's sense of atmosphere and character was gracefully calibrated to the music salon setting, a quality that would avail itself in various guises throughout the recital.

This being the second in the MET Stars Live series, following Jonas Kaufmann at Polling Abbey outside Munich, it appears that the recitals will include video segments highlighting the singers' MET appearances along with low-key hosting by the the company's reigning Brünnhilde, [Christine Goerke](/talking-with-singers-christine-goerke/). With an eye to PBS, where the series will eventually land, these segments might best serve as an opening act or as one centrally placed intermission. As employed they interrupt the flow. We were, however, treated to early video footage from Fleming's home and school days which was not unwelcome.

> The aria, subdued by the piano arrangement, made ample use of Fleming's gorgeous diminuendo.

After the break we were back in the music salon from which Fleming transported us to Paris via Reynaldo Hahn's setting of Victor Hugo's unnamed poem proclaiming "...if my verses hand wings, wings as a bird has". Long creamy lines, perhaps Fleming's most beloved attribute, brought Hugo's poem to sensuous and languid life capturing the reverie of a woman in love.

Then it was on to the French countryside with two contrasting selections from Canteloube's "Chants D'Auvergne". Adopting a flirtatious air, Fleming breezed into "Malurous quo uno fenno" with folksy elan as if raising a glass of wine in toast to the romantic ironies of the song. "Bailéro" brought back her smooth and yearning tones of one shepherd calling across the river to another. Fleming avoids the more staccato vocal technique of many singers approaching this work, Victoria de Los Angeles, for instance, or Arleen Auger, an early Fleming instructor, but her rendition has its own flavor.

Full diva mode was assumed for Massanet's passionate "Adieu, notre petite table" from _Manon_. To sate a broad swipe of the fan base there would be juicy operatic moments later in the program with a bright and rollicking "Musette savria sulla bocce viva" from the lesser known _La bohème_ by Leoncavallo, and Cilea's melodramatic paean to the theater, "lo son l'utile ancelle" from _Adriana Lecouvreur_.

From the little known opera _Die Kathrin_ by Austrian film music pioneer, Eric Korngold, "Ich solo ihn niemals, niemals meh sehn," Fleming shows lovely restraint. The aria, subdued by the piano arrangement, made ample use of Fleming's gorgeous diminuendo and set the stage for "Da geht er hin", the Marschallin's monologue from Richard Strauss' _Der Rosenkavalier_.

> She played with the lovely but treacherous introduction, toyed with the melody and introduced some improvisation at the end.

Of Fleming's signature roles at the MET, perhaps the Marschallin is her most prominent with some 30 performances in the house. Over the years followers have witnessed firsthand her development of this complex character, a role she retired with a new production in 2017. At Dumbarton Oaks her Marschallin is anxious, irritated and perplexed, but determined. We have seen such attributes in her previous portrayals but this one feels more in touch. Without the operatic trapping she's quite modern. At this juncture in Fleming's career it is of some consequence to hear the monologue in recital.

Puccini's "O mio babbino caro" and Harold Arlen's "Over the Rainbow" would have been performed as encores if there had been an audience to demand them. Fleming surprised with the Puccini giving into verismo over beautiful singing, It was a familiar piece, refreshingly sung. “Over the Rainbow” was quite the adventure. Positioning it as a narrative for our times, thus encasing the recital in a pandemic wrap-around, she played with the lovely but treacherous introduction, toyed with the melody and introduced some improvisation at the end.

Robert Ainsley accompanied supportively. Appearing to be particularly inspired by the Canteloube and Strauss, he and Fleming demonstrated a collegial rapport throughout. His playing was acknowledged throughout by the roving cameras, focusing on his fine work in the piano interval during the _Die Kathrin_ aria. Fleming praised his training of young singers.

The musical pedigree to which Dumbarton Oaks lays claim stems from the concerto Igor Stravinsky was commissioned to write for the 30th wedding anniversary of then owners, Richard and Mildred Bliss. Mrs. Bliss requested that the resulting Concerto in E-flat be subtitled the Dumbarton Oaks Concerto, as it is generally known today. Nadia Boulanger conducted its premiere in the music salon in 1938. Stravinsky finally conducted it there on two occasions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1596483198/media/2020/08/Fleming-DumbartonOaks_uscvfu.jpg){{% /md %}}

<figcaption>The Music salon at Dumbarton Oaks, an estate in the Georgetown neighborhood of Washington D.C., served as the site for Renee Fleming's MET Stars Live concert. Igor Stravinsky's Concerto in E-flat, generally known as the Dumbarton Oaks Concerto, was premiered in the salon in 1938. Photo: Dumbarton Oaks.</figcaption>

Given to Harvard University in 1940, the estate is operated as a research center for the study of Byzantine and pre-Columbian art, as well as garden design and landscape architecture. It is open in non-pandemic times for the public to tour its art collections and garden. How fitting that Renée Fleming would select a venue with such a strong commitment to the arts and humanities. Her recital adds to new luster to the impressive Dumbarton Oaks.