+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-11T00:03:00-04:00"
lastmod = "2015-04-11T00:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724949221/Ericsson_1939.jpg.jpg"
publishDate = "2015-02-20T09:03:00-05:00"
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/brooklyn-academy-of-music.md"]
short_description = "A remount is a weird thing for the artists involved. The sets, costumes, stagings, and (hopefully) the music stay the same, but the casting is rarely identical between productions. This means the newcomers have to insert themselves into the movements of another. This may seem like Acting 101, but the catch comes when the new singer is looking for some motivation for their movements, motivation that’s stronger than “that’s what they did the last time”."
slug = "remounts-or-what-did-they-do-the-last-time"
title = "Remounts, or &quot;What did they do the last time?&quot;"
+++

<p>
	This week, I'm helping out on a remount production of <em>Semele</em>. I first worked on it in 2012 during my time in the COC Ensemble Studio, and this March, Zhang Huan's <em>Semele</em> is heading to the Brooklyn Academy of Music.
</p>
<p>
	A remount is a weird thing for the artists involved. The sets, costumes, stagings, and (hopefully) the music stay the same, but the casting is rarely identical between productions. This means the newcomers have to insert themselves into the movements of another. This may seem like Acting 101, but the catch comes when the new singer is looking for some motivation for their movements, motivation that's stronger than "that's what they did the last time".
</p>
<p>
	Even the production team work in a strange way, particularly when the director isn't present for the rehearsal period. They look at production notes and archival video footage to verify staging direction, and frequently confer with each other about what happened in that scene the last time.
</p>
<p>
	At a quick glance, it may all feel quite anti-creative, like staging-by-numbers. It's true; this rehearsal method could easily be whittled down to a game of operatic telephone. That's why a remount production can highlight an artist's real skill. When the new Juno wants to know why she crosses left at the big chord, she already knows that the last Juno crossed left; she's really asking for the "why" behind the direction. The associate or assistant director has to be armed with answers when the singers ask questions, and give those answers as if they were first-hand information. That means getting to know someone else's piece so well that you have your own opinions to give.
</p>
<p>
	With the cast, it's neat for me to watch any returning singers adapt their scene to the energy of any newcomers onstage with them. It means they have to be good at listening onstage, which has always been a litmus test of mine when I want to know if a singer can act. The chemistry between the lovers may be different, the villain may be more schizophrenic than evil. Even things like height and weight can read as a totally different facet of the same character, and while new cast members are working on integrating themselves into an existing show, the returning singers are busy throwing out preconceptions of their scene and looking at it with new eyes.
</p>
<p>
	There's even the factor of what a role feels like for a singer after some time away. In the case of <em>Semele</em>, it's been close to three years between the production at the COC and the upcoming show at BAM. That's enough time for many singers to move into larger repertoire, or for their instrument to begin sitting higher or lower than before. It's enough time for a singer to have a baby, which changes one's body, and changes one's voice. Pair that with the likely chance of a new conductor, and the musical demands on returning singers are considerable.
</p>
<p>
	While I'm always an advocate of a production in which a director discovers a character alongside the singer, and ironically, I figure it's easier for a singer to adapt to a remount in a production where this doesn't happen. My idealism doesn't quite conform to the reality of the industry, and I fight my urges to bring up the Appeal to Antiquity, how "because we did it last time" isn't a solid reason to do anything. But talk about living art: a production and all its parameters can be realized by entirely different groups of people at different times. It takes artists who are dramatically curious, yet free from personal ego, to pull that off. Maybe it shouldn't surprise me that the remount rehearsal that seems robotic makes some of the highest demands on its artists.
</p>
