+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-06-15T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1560645047/media/2019/06/sqAlanSchneider_GingerCostaJackson_AdamFisher.jpg"
primary_image_credit = "Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman."
related_articles = []
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/adam-fisher.md", "scene/people/ginger-costajackson.md"]
short_description = "But even with the small missteps, Odyssey Opera once again hit a home run. La Belle Hélène is that rare Offenbach operetta that doesn’t necessarily run like a clockwork mouse in terms of efficiency, but with the right cast it can still prove to be a fun, lighthearted evening at the opera."
slug = "reliably-bubbly-belle-helene-a-delight"
title = "Reliably bubbly Belle Hélène a delight"
youtube_url = ""

+++
There is some unexplainable property of Jacques Offenbach's music that always catches a listener by surprise: no matter what the cost, there is always an undercurrent of fun that runs through every score of his. It is also typically rather quick-paced, in that no matter what happens it strings you along for the ride. This is one of the main souls of the Offenbach operetta, and in performance this music is irresistibly bubbly and happy, and it can help carry an audience through even a not-so-great script.

Thus, we come to _La Belle Hélène_, his send-up of Paris' courtship of Helen that forms the closer for Odyssey Opera's half-season exploration of Helen of Troy. Ironically, _Belle Hélène_ displays the other part of the Offenbach operetta by virtue of its half-absence: in a proper Offenbach operetta, the subject it chooses to set is lampooned via extreme exaggeration on every front. However, Henri Meilhac and Ludovic Halévy perhaps did not go far enough in the exaggeration in this work, leaving translator Richard Duployen precious little room to add to the absurdity of the proceedings. Paris and Helen are both perhaps a little too straight-laced against how eccentric everyone else in the cast is, and while they do get some humor in they are perhaps too sincere in their amorous intentions for the biting parody that works such as _Orphée aux Enfers_ and _La Vie Parisienne_ work up.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560645109/media/2019/06/Ensemble_3.jpg){{% /md %}}

<figcaption>Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman.</figcaption>

</figure>

Still, the exaggeration is not entirely absent, and this is when the work truly finds its voice. Duployen's translation finds plenty of time to lampshade the fact that it is a piece of theater, with particular highlights going to Paris stating he will reveal his real identity to Helen by waiting for a big theatrical moment and having the characters constantly reference their larger-than-life status amongst Greek mythology and the ways those myths engage with our modern culture. The more eccentric characters in the cast are also the ones who go the farthest in viciously lampooning the archetype in question, from an Achilles who covers his heel with armor and an Agamemnon whose stuffiness knows no equal to an Orestes who is that drunk college kid everyone rolls their eyes at. Then, when the stage work does get ridiculous, its ludicrousness is played to the hilt, as perhaps best exemplified the first act's Intelligence Games' dedication to building two separate long-form jokes that are both worth the build-up.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560645122/media/2019/06/Ensemble_GingerCostaJackson.jpg){{% /md %}}

<figcaption>Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman.</figcaption>

</figure>

And yes, Duployen's translation updates the sometimes racy humor that is a staple of these operettas, and in my estimation he probably amped up the subtle sexual humor in ways that Meilhac and Halévy could not thanks to Parisian censors.

Then, when the music gets added in, it grows rather difficult to mess up an Offenbach show, and here the players on the Huntington Avenue Theater's stage did not disappoint.

Ironically, the two least interesting characters were the ones with the two best performances, as [Ginger Costa-Jackson](/scene/people/ginger-costa-jackson/) and [Adam Fisher](/scene/people/adam-fisher/) both managed to bring a quirky chemistry to the table as Paris and Helen. Perhaps what made their performances work the best was that they really highlighted just how suggestive their back-and-forth is from the moment they meet, and this helped them stand out immeasurably against the more eccentric parts of the cast. However, they also brought verve and agility to Offenbach's vocal writing, and Adam Fisher in particular deserves accolades for navigating a part whose tessitura sits punishingly high with relative ease.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560645137/media/2019/06/BenWager_DavidMcFerrin_FeliciaGavilanes_RacheleSchmiege.jpg){{% /md %}}

<figcaption>Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman.</figcaption>

</figure>

The other characters were also brought to life by actors who brought out the absurdity of the cast that surrounded them, especially in the kings. Steven Goldstein and Gregory Zavracky played the two Ajaxes to the hilt, walking into the scene like conjoined twins thanks to an absolutely brilliant costume gag and playing that dynamic for all the visual humor that entailed.

Christian Figueroa made for a hilariously dimwitted Achilles by playing him with such a perfect sense of overconfidence that it highlighted the character’s lack of intelligence in a way that kept it from being too annoying. David McFerrin's Agamemnon ironically got much of his humor by playing into the regal nature of the character, and then Alan Schneider's Menelas was delightfully neurotic and stubborn. The one hole in the cast was perhaps Ben Wager’s Calchas: it took him a little while to find his footing with the character, and unfortunately this meant that the first ten minutes of his action dragged a little.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560645162/media/2019/06/StevenGoldstein_GregoryZavracky.jpg){{% /md %}}

<figcaption>Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman.</figcaption>

</figure>

Of course, to support them was the quintessential Offenbach chorus and their sound, and under the direction of Gil Rose both forces did a rather excellent job of delivering the timbres so strongly associated with Offenbach. Perhaps there were a few coordination issues, but even despite these the chorus was clearly having fun, and it showed with how agile their singing was. And of course, the orchestral playing was top notch: Offenbach's scores are not particularly technically difficult on the orchestra, but their reading was light and fluffy and they nailed the style.

The production design was also a good deal of fun on its own, and they contributed to the fun. The costumes did confuse me at first, as they went with a mixed Greco-Parisian aesthetic that seemed to jump between time periods. At first, I wondered if they were stuck between two modes, but as the production went on it actually added to the carefree nature of the whole work, and thus it ended up working. Besides, I hardly think the visual humor of conjoined Ajaxes would have worked nearly as well without the costuming department really nailing their costume design, and there was something about drunk party child Orestes wearing a businessman's tuxedo the entire time that was great. The sets were also rather ornate for Odyssey Opera, and they all looked great for as simple as they generally were. The one misstep is probably the lighting design: there was certainly good mood lighting and it did contribute to the comedy on occasion, but they decided to employ strobe lighting during a particularly difficult passage for the chorus, and I am fairly certain that this decision led to one of the biggest coordination issues of the entire evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560645222/media/2019/06/AdamFisher_GingerCostaJackson.jpg){{% /md %}}

<figcaption>Odyssey Opera's La belle Hélène by Jacques Offenbach. Photo: Kathy Wittman.</figcaption>

</figure>

But even with the small missteps, Odyssey Opera once again hit a home run. _La Belle Hélène_ is that rare Offenbach operetta that doesn’t necessarily run like a clockwork mouse in terms of efficiency, but with the right cast it can still prove to be a fun, lighthearted evening at the opera. Odyssey Opera was exactly the opera company to do that, and it was a joy to watch the work unfold on the stage of the Huntington Avenue Theater.