+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2018-08-04T10:02:00-04:00"
lastmod = "2018-08-04T10:15:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391245573/sqWolfTrapOperaRigoletto_ManeGaloyan4.jpg.jpg"
primary_image_credit = "Mané Galoyan as Gilda in Rigoletto, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera."
publishDate = "2018-08-04T10:02:00-04:00"
short_description = "The production, directed by Crystal Manich, is pretty standard as *Rigolettos* go, the Italian renaissance evoked in the costumes and scenery, and all the characters do what they always do - the Duke rapes, Rigoletto rages, Gilda falls foolishly in love, Sparafucile murders. There is an added element of surreal projections on the architectural set which proved more a distraction than an enhancement."
slug = "relentlessly-sinister-rigoletto-at-wolf-trap-opera"
title = "Relentlessly sinister: Rigoletto at Wolf Trap Opera"
+++

There's a common refrain heard from men in the public eye who hope to boost their credentials as feminists or as allies to women: "I'm the father of a daughter," as if the birth of a baby girl suddenly causes the scales to fall from his eyes and he finally sees how the scales are stacked against her. And it's BS. First of all, if you need to have a daughter to finally understand that women are people, then you have a pretty serious empathy problem; but also, so many men who spout these words don't seem to back it up with any meaningful action.

I found myself thinking about this during Saturday night's [*Rigoletto* at Wolf Trap Opera](https://www.wolftrap.org/tickets/calendar/performance/18filene/0803show18.aspx), which came on the heels of the [*Washington Post*'s exposé](https://www.washingtonpost.com/entertainment/music/assaults-in-dressing-rooms-groping-during-lessons-classical-musicians-reveal-a-profession-rife-with-harassment/2018/07/25/f47617d0-36c8-11e8-acd5-35eac230e514_story.html?noredirect=on&utm_term=.fab1af7618f7) on abuse and harassment in the classical music community, usually perpetrated against women by powerful men, which led to several high-profile firings and resignations, and an [essay in the online classical music zine VAN](https://van-us.atavist.com/end-transmission) on the relentless trope of violence against women in operas throughout the ages, which uses *Rigoletto* as one of its primary examples.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391082874/WolfTrapOperaRigoletto_JohnathanMcCullough_KidonChoi_WolfTrapOperaChorus.jpg.jpg)
<figcaption>Kidon Choi (Rigoletto) in *Rigoletto*, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera.</figcaption>
</figure>

In Rigoletto, an opera that I've seen half a dozen times, and listened to countless more, and which is considered a beloved staple of the repertoire, the title character is all too happy to participate with the Duke and his gang's "pranks," which seem to all involve kidnapping and sexually assaulting their friends' wives and daughters, all while doing everything he can to shield his own daughter from their violent antics. Of course, he can't hide her away for long, and tragedy - as always - ensues. For the first time, instead of having a good cry while being swept up in Verdi's masterful score, the opera just turned my stomach. From the moment the curtain rose on the overture, all I could think about was the fate that awaited Gilda at the end of the evening, and I watched with gritted teeth.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391105696/WolfTrapOperaRigoletto_ManeGaloyan2.jpg.jpg)
<figcaption>Mané Galoyan (Gilda) in *Rigoletto*, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera.</figcaption>
</figure>

The production, directed by Crystal Manich, is pretty standard as *Rigolettos* go, the Italian renaissance evoked in the costumes and scenery, and all the characters do what they always do - the Duke rapes, Rigoletto rages, Gilda falls foolishly in love, Sparafucile murders. There is an added element of surreal projections on the architectural set which proved more a distraction than an enhancement. I got the sense that Manich was trying to say something about how callous and careless the men of the Duke's court are with the lives of the women they abuse, but the problem with this is there's no room for redemption or hope at all. The result is an opera which is almost unbearably bleak (but with tunes you'll be humming the whole way home.) The sinister mood of the court is contrasted with Gilda's wide-eyed, youthful innocence. When we first see her she is even carrying a doll, making her seem even younger than she's usually portrayed, and making the Duke's casual abuse of her naive affection even more horrific.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391123939/WolfTrapOperaRigoletto_PiotrBuszewski.jpg.jpg)
<figcaption>Piotr Buszewski (The Duke of Mantua) in *Rigoletto*, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera.</figcaption>
</figure>

The title role is famously taxing, so I was surprised to hear that WTO would be performing *Rigoletto* cast with singers from its Filene Young Artist Program, but baritone Kidon Choi was up to the challenge. While his voice had the ability to balance both the heft and the tenderness required by the role, his presence on stage lacked intensity, especially in the "Cortigiani" aria, where Rigoletto must go from fuming rage, to desperation, to pleading, but these emotions didn't manage to come through in Manich's staging which was just a step above "park and bark."

Rigoletto's several heartfelt duets with his daughter Gilda were carried by soprano Mané Galoyan, whose clear-voiced and skillful singing, and whose strong, committed portrayal of  the tragic role made her the highlight of the performance. Although I'm afraid she wasn't served well by performing in Wolf Trap's Filene Center amphitheater where all the singers are mic'd, making her otherwise crystalline high E-flats sound disconnected from the rest of her voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391149223/WolfTrapOperaRigoletto_PatrickGuetti_ZoieReams.jpg.jpg)
<figcaption>Patrick Guetti (Sparafucile) and Zoie Reams (Maddalena) in *Rigoletto*, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera.</figcaption>
</figure>

As the Duke of Mantua, Piotr Buszewski offered swarthy good looks and little charm (perhaps that was the intent?) along with a bright, pingy voice, and stellar top C. Although, his intonation faltered at times, and he seemed to stumble nervously and hurriedly through cadenzas.

Bass Patrick Guetti stood out as the assassin Sparafucile, with a voice that is smooth and rich and all resonance. As his seductive sister Maddalena, Zoie Reams brought a sultry, smoky mezzo. I'd like to see a Carmen from her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1533391161100/WolfTrapOperaRigoletto.jpg.jpg)
<figcaption>*Rigoletto*, Wolf Trap Opera, 2018. Photo: Scott Suchman for Wolf Trap Opera.</figcaption>
</figure>

Conducted by Grant Gershorn, the orchestra seemed to be having an off night, or perhaps it was a trick of the outdoor acoustics or the amplified sound, but the overall sound was just a bit mushy. Much as I like the idea of outdoor opera on a summer evening, it isn't the ideal way to really hear an opera. The mics expose flaws in the singers' voices that the audience wouldn't hear otherwise, and there's a lack of dynamic range in the sound. Perhaps this venue should be reserved for more lighthearted fare, rather than just another opera about another innocent girl defiled and murdered.
