+++
author = ["authors/rebecca-woodmass.md"]
categories = ""
date = 2016-09-29T08:21:00Z
lastmod = "2016-09-30T13:32:00+01:00"
preamble = "This is a crosspost via [rwoodmass.com](https://rwoodmass.com/rehearsing-trauma/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475177972186/2016-09-29---Patricia.jpg.jpg"
publishDate = "2016-09-30T13:00:00+01:00"
related_articles = ["articles/heavy-scenes-the-fast-lane-to-a-great-rehearsal-room.md", "articles/lifelike-theatre-at-luminato-the-story-of-charlotte-salomon.md", "articles/using-your-voice-again-a-plan-of-action.md"]
related_people = ["scene/people/rebecca-woodmass.md"]
short_description = "It is not enough to re-experience our own pain on stage; we must externalize it so the audience can join us through empathy."
slug = "rehearsing-trauma-how-working-on-an-opera-helped-me-heal"
title = "Rehearsing trauma: How working on an opera helped me heal"

+++
Everyone was telling me it would be hard. I was saying this to myself. I was about to spend 8 hours a day, 5 days a week, as a 16 year old girl who was abducted, tortured, and raped for 2 1/2 years without trial by a military government in Argentina. Patricia Isasa was going to attend the premiere of this new opera about her struggle, and I was going to meet her.

They didn't prepare me for these sorts of experiences in music school. The kinds of contracts that hold me in the rehearsal room because I signed my name at the bottom of a paper, when the material I am responsible for is turning my heart inside and out and my stomach over and over again. How do I embody a character fully, fall in love with the character, learn its idiosyncrasies, when that character must undergo torture daily on stage, sometimes multiple times, with increasing detail, depth, and dramatic timing? How do I rehearse trauma?

## Preparation

Two months before rehearsals for the opera began, I was diagnosed with PTSD. Ten years ago, I was raped in a hotel room at a Holiday Inn in Winnipeg. It was the kind of experience that I couldn't even bring myself to call it what it really was out loud for years, because I believed I could have prevented it by behaving differently; by not going with him into the hotel room, by wearing pants or shorts instead of a short skirt, by following my instinctive fear and aversion instead of my desire to be seen as a nice, accommodating, and sexually free being. Then, when I began telling people about it, they seemed shocked, and I brushed it off with, "Yeah, whatever, I've dealt with it, I'm over it," as they looked at me with a strange look in their eyes.

I don't think I could have done a better job of trying to prevent the trauma of my rape from settling into my body. Not everyone experiences post-traumatic stress when they experience something traumatic, and I was determined that this would not happen to me. I sat in my car after it happened, in the parking lot of the hotel, exhaling through my sobs and thinking, "So this is what it's like to be a victim of rape," and deciding that I would not let this man and what he did affect my life, my joy, my sexuality, in any way. I thought of myself as a statistic, so I dismissed my experienced repeatedly for ten years. Eventually, a combination of an emotionally abusive relationship and signing a contract to perform in this opera managed to unearth the traumatic memory from my diaphragm. That's where I think it was stored, because I started having panic attacks that would cause me to lose control of the rhythm of my breath, and black out while I was at my desk at work, biking downtown, or getting ready for bed. As soon as I started taking anti-anxiety medication, I was finally able to sit down at the piano and start to learn my role.

## Rehearsal

The composer is a woman, the director is a woman, the set and costume designers are both women and I am excited to get started. I can do this. We are not rehearsing the scenes that reference violence on our first day. I can do this. I told the director about my diagnosis and my struggle, and she believes I can do it. I can do this.

The opera begins with Patricia arguing with her younger self. Young Patricia wants Adult Patricia to face her trauma, to speak about her experience, and to fight the legal system so that all the victims of the Argentine oppressive regime experience justice. Adult Patricia does everything she can to avoid thinking about her past, including insulting and silencing her younger self.

This was the scene with which we began rehearsal. We ran it again and again, pouring more and more of our hearts into it every time, ignoring musical mistakes in order to get the dramatic nuance just right. It was a dark room, the team was experimenting with lighting and projections as we worked, and after 3 hours we were exhausted. Kristin Norderval (Adult Patricia) and I have both experienced the diminishing of the voices of our younger selves calling for justice in our real lives, our own reliving of the memory of sexual assault. We were being asked to show it in our bodies. It was not enough to feel it, to have a kinaesthetic sensation of emotion, anger, a belief in the message of the scene, of the cause, of Patricia's story. We had to show it in every bodily language – in our faces and hands, in the way we walk on the stage, and in the way we enunciate consonants and decrescendo or crescendo on a high note.

It is not enough to re-experience our own pain on stage; we must externalize it so the audience can join us through empathy.

In light of the trials of Bill Cosby and Jian Ghomeshi, rape culture, and victim-blaming, and the hell victims go through to be taken seriously on the stand post-assault, I never thought that one of my first challenges in healing from the trauma of rape would be to dramatize my most internal vulnerabilities. Patriarchy teaches us that showing what we truly feel is a weakness (and this is taught to ALL – not only to women), and in the Jian Ghomeshi trials, I remember keenly that his victims were criticized both for showing too much emotion, and not showing enough emotion. In this opera, as in all dramatic art forms, authenticity was necessary to the telling of the story. That was incredibly healing.

I learned that re-enacting trauma on stage and in the rehearsal room is not comparable to experiencing trauma in real life. If the re-enacted trauma triggered an anxiety response in my body during a rehearsal, I had to be able to convince my body that I am safe, that my rape is in the past, and that I am doing what I love to do in life – representing an important story on stage through my chosen art form. If I couldn't quickly convince my nervous system that I was not really in danger, it would prevent me from representing Patricia's story. So, the rehearsal process became like very efficient cognitive behavioural therapy, where I was exposed consensually and repeatedly to a triggering story, was able to externalize my anxiety by moving my body and making noise that I felt served as a protest to this kind of violence on an ideological level, and was empowered as a performer and a person throughout the process.

In the final week before an opera is performed, we start doing "run-throughs" of the piece. In all previous rehearsals, there is always the potential that one will be stopped and asked by the director do re-do a portion of a scene, and we work on smaller pieces of the opera at a time. In _Trials_, this intensive scene work was emotionally draining, because I experienced the same set of moments over and over within a 3-hour rehearsal. It was a joy and a relief to start running the opera, because I knew that I could enter into the emotion of each scene without having to conserve energy for a repetition. I could move through the emotion, rather than having to sit in it.

In one run-through with the orchestra and chorus, we were in our rehearsal hall that had large windows. It was a warm spring day, and the sunlight was filling the space with a yellow glow. We arrived at the scene where Patricia Isasa sees one of her torturers on TV, and it finally sinks in that her torturers are "slurping their soup, sipping their tea, promoted to judges and officers, as though it never happened." Singing those words as Young Patricia in duet with Adult Patricia, emotion about my own trauma poured into the context of Patricia's trauma like water into a glass. You see, the same day, I had seen my rapist's social media profile, and all his friends’ birthday wishes on his profile. My rage exploded through my voice into the music – at his ability to live his life normally and just move on, everyone thinking he is a great person, while I had to quit my day job because I was having daily panic attacks at work, unable to leave my house due to social anxiety, and spending so much of my energy on therapy, worrying about letting my friends down, and dealing with side effects from anti-anxiety medication.

My experience was very different from Patricia's. However, I was able to use the recounting of her story as a container for my own expression of anger that day. That was also the moment where I, like Patricia, realized that it is a necessity for my own healing and for the healing of others, for me to work for justice. This sunny afternoon, singing the duet with my character's older self, I felt the broken parts of me merge and finally sing as one, with passion and empowerment, against injustice. Chiaroscuro – brightness and darkness in the voice – are reflected in the process of working towards justice while holding pain. The decision to work for justice is intertwined with the experience of empathy for the pain of the "other". I didn't know how I was going to do that, but everyone in the room felt my release and resolve. When I turned around to walk to the back of the stage for the next scene, my eyes and the eyes of the choristers facing me in a line were full of tears.

Watch the full performance of _The Trials of Patricia Isasa_ by Kristin Norderval below.

<figure data-type="video">
<iframe width="560" height="315" src="https://www.youtube.com/embed/GBTdgoFtngM" frameborder="0" allowfullscreen></iframe>
</figure>