+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-01-24T11:59:00-05:00"
lastmod = "2015-04-11T22:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428806302633/OperaExchange.jpg.jpg"
publishDate = "2015-01-24T11:59:00-05:00"
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/wayne-gooding.md","scene/people/joel-ivany.md","scene/people/lawrence-wiliford.md"]
short_description = "This past weekend, I attended The Opera Exchange, an event presented semi-regularly by the Canadian Opera Company to discuss relevant opera topics, structured around the COC’s current season. With Dmitri Tcherniakov’s production of Don Giovanni set to open on January 24th at the Four Seasons Centre, it was a good opportunity to chat about that polarizing topic, Regietheater, or director’s theatre."
slug = "regietheater-ja-oder-nein"
title = "Regietheater? Ja oder nein?"
+++

<p>
	This past weekend, I attended The Opera Exchange, an event presented semi-regularly by the Canadian Opera Company to discuss relevant opera topics, structured around the COC's current season. With Dmitri Tcherniakov's production of <em>Don Giovanni</em> set to open on January 24th at the Four Seasons Centre, it was a good opportunity to chat about that polarizing topic, <em>Regietheater</em>, or director's theatre.
</p>
<p>
	Michael and Linda Hutcheon, a married couple of professors, opened the event with a short lecture on where the idea of <em>Regietheater</em> comes from. Turns out, the answer is Germany. Michael and Linda spoke about the Wagner productions in Bayreuth that kicked off opera's reign of the director, like <a href="http://www.amazon.de/Tannh%C3%A4user-2-DVDs-Hans-Sotin/dp/B001A5REB2" target="_blank">Götz Friedrich's 1972 <em>Tannhäuser</em></a>, and<a href="http://www.amazon.com/Wagner-Nibelungen-Bayreuth-Festival-Complete/dp/B00005OATQ" target="_blank"> Patrice Chéreau's centennial production</a> of <em>Der Ring des Nibelungen</em> in 1976. The productions were passionately rejected by audiences, but within a few seasons, the novelty was (mostly) forgiven, and Friedrich and Chéreau were considered trailblazers for opera and theatre directors. The question of whether or not <em>Regietheater </em>is good or bad for the art form was left to a panel of pros.
</p>
<p>
	The panel included Ashlie Corcoran (Artistic Director, Thousand Islands Playhouse), Joel Ivany (Artistic Director, Against the Grain Theatre), Lawrence Wiliford (tenor), William Germano (Cooper Union), Nina Penner (McGill University), and Wayne Gooding (editor,<em> Opera Canada</em>). There was a fair amount of consensus that a creative director is what opera wants. Ashlie Corcoran is all about storytelling, and she insisted that the story comes from not only the libretto, but within the notes of the score. I've worked with Ashlie before, and I can attest to her using her ears as well as her eyes when she directs. Joel Ivany considered the issue more about removing barriers between the piece and the audience; his own experience in writing new libretti for the three Mozart/DaPonte operas is a successful example of that. (I asked Joel if he considered his original librettos for <em>Figaro</em>, <em>Giovanni</em> and <em>Così</em> to be <em>Regietheater</em>: "I don't, but other people would. What I do is very traditional to the story, it's just a new story."
</p>
<p>
	<em>Opera Canada</em> editor Wayne Gooding posed the problem of <em>Regietheater</em>'s slippery slope. "How far are we willing to let them create before we say, 'no, you can't do that'?" The COC's <a href="http://arts.nationalpost.com/2014/02/04/opera-review-at-least-the-music-rocks-at-this-masked-ball/" target="_blank"><em>Un ballo in maschera</em></a> (by Jossi Wieler and Sergio Morabito) from last season was Wayne's example of a production that had started with a concept, and finished with thee characters left "stranded". Speaking for singers was Canadian tenor Lawrence Wiliford, who made the important point that a director owes to his cast and creative team a certain level of preparation and understanding of the piece. Since it's singers, not directors, that must step onstage each night to carry out the director's vision, a director must have a clear reason for their concept; if a singer can't relate a director's idea to his or her character, it's the job of the director to connect the dots."Ideally, I enjoy the work that I do most in opera when there is a collaborative perspective on whatever work it is," says Lawrence.
</p>
<p>
	There were a few questions from the audience, like about how a director considers (or doesn't consider) the audience's acoustic experience during a show, or about a director's basic knowledge of the musical score (including a disturbing anecdote of a director working strictly from a libretto, no score in sight).
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428806338711/VegasRigoletto.jpg"><img data-resize-src="http://lh3.googleusercontent.com/-CehLgA1PneD8a9C4fSZ4lk9_mfA387za_EOIH9HyXVjcq958XIYBRMw7rM0Pdn-Do9Dn53EBoSv_AK_KjQHo6acYIan" src="http://lh3.googleusercontent.com/-CehLgA1PneD8a9C4fSZ4lk9_mfA387za_EOIH9HyXVjcq958XIYBRMw7rM0Pdn-Do9Dn53EBoSv_AK_KjQHo6acYIan=s1200"></a><figcaption>The Metropolitan Opera's <em>Rigoletto</em>, directed by Michael Mayer</figcaption></figure>
<p>
	I couldn't help circling back to my own big question, which is: how did this happen? Is the repertoire so lacking in dramatic clarity that the director must act as translator? Why is it such a big deal for a director to take charge of live theatre, and why is it such a risk to the art form? <em>Regietheater</em> only means that the director is in charge; for good reason, the term has become synonymous with "concept productions" and "weird staging". Let's clear up the problem: it's when directors superimpose a concept on a show that doesn't warrant it. "There's that fine line, and you don't know where it is," says director Joel Ivany, bringing up the old chestnut of the 2005 <a href="http://www.ft.com/intl/cms/s/0/76305d3c-8609-11d9-b506-00000e2511c8.html" target="_blank"><em>Rigoletto</em> à-la-<em>Planet of the Apes</em> in Munich</a>. "Was there a lot of in-depth preparation or do you just put everyone in gorilla suits?" That's the real point of the <em>Regietheater</em> debate.
</p>
<p>
	When I ask "how did this happen?" I don't mean to join the haters of <em>Regietheater</em>. The following quote from <em><a href="http://www.earlymusicworld.com/id44.html" target="_blank">Early Music World</a> </em>was used by Michael and Linda Hutcheon when delineating the poles of the debate: "Opera is sick. Very sick. Once handsome and noble, its formerly elegant features have over recent years become ever more contorted and distorted beneath a toxic, suppurating excrescence commonly known as <em>Regietheater</em>." I don't agree with this. People are too tender about new things, especially people who love opera. They can be tender all they want (like <a href="https://www.facebook.com/permalink.php?story_fbid=815481098518718&amp;id=146292958770872" target="_blank">this Facebook page</a>, wow), because the real question is whether or not these reigning directors are showing us the piece or showing us their personal brand.
</p>
<p>
	I have a huge problem with directors imposing their personal styles onto an opera before deciding that they want to direct said opera. The problem, at least for directors of opera and other forms of live theatre, is that they have the <em>option</em> of reigning supreme. In the case of most "great" opera into which the director wants to sink his teeth, the composer and libretto are both dead. Since the minds that created the source material aren't available for consultation (or to shut down bad ideas), perhaps it was only a matter of time before directors wanted to add their names to the credits of an opera.
</p>
<p>
	<a href="https://www.youtube.com/playlist?list=PLjvHW5P_QKvDSf_0wHgTHrQFw39_Q13FC" target="_blank">At its worst</a>, <em>Regietheater</em> is simply a director who puts his own stamp on an opera, regardless of the congruence between his concept and the piece itself. At its best, <em>Regietheater</em> is a director who clears away preconceptions about what an opera should look like, and presenting the piece in the world they've imagined after looking with clean eyes at the music and text. I'd even cede that there is bad <em>Regietheater </em>created with good intentions; but that's like arguing that you shouldn't fire your Violetta because she doesn't have the technique to make it through the role.
</p>
<p>
	I'm not a fan of slippery-slope arguments, probably because they're poorly used to keep the LGBT community from getting married and other ridiculous fights. When it comes to <em>Regietheater</em>, the only slippery slope to fear is that of the composer's ignorance of the piece itself.
</p>
<p>
	The director's first job is to make sure that the entire rehearsal room is trying to tell the same story. It strikes me that this isn't difficult to do for the director who knows the answer. Albert Einstein is credited with saying, "If you can't explain it to a six-year-old, you don't understand it yourself." (Clarity: I'm making <em>no suggestions</em> that a singer's intelligence is equivalent to that of a six-year-old.) I'm just saying that if a director has a story to tell, that's a great start. If a director simply has an idea of "things that are neat to see onstage", I want them to get away from my opera.
</p>
<p class="intro">
	I digress! The COC's Opera Exchange is one of many programs and events designed to bring you closer to the operas onstage and how they were created. <a href="http://www.coc.ca/ExploreAndLearn.aspx" target="_blank">Click here</a> to check out the COC's programs for adults and kids, and make your night at the opera a great one.
</p>
