+++
author = ["authors/zachary-mendez.md"]
categories = "Op-ed"
date = "2016-08-20T12:19:00+01:00"
lastmod = "2016-08-21T10:01:00+01:00"
preamble = "This is a guest post by contributor and American tenor [Zachary Mendez](/scene/people/zachary-mendez/). For more, follow him on [Instagram](https://www.instagram.com/zacharyamendez/), and [hear him sing](http://www.zmendez.com/when-where/#portland)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471693397026/2016-08-20---Goal.jpg.jpg"
publishDate = "2016-08-21T10:01:00+01:00"
related_articles = ["articles/the-heart-and-the-art.md","articles/arianna-zukerman-youve-got-to-live-your-truth.md","articles/when-lost-find-roots.md"]
related_people = ["scene/people/zachary-mendez.md"]
short_description = "My own obsession with technique made me terrified to sing in front of my peers. I knew that they were only judging me: a baritone singing tenor rep. Worthless technique. I hated the feeling of judgmental eyes on me and I had nothing to say with the music I was singing. For me, technique was the only thing that mattered. But it’s not."
slug = "redefining-the-goal"
title = "Redefining the goal"
+++

The first opera I experienced was *Don Giovanni*. I hated it. I wasn't an opera person.

I grew up in suburbia, smack in the middle of the Dallas/Fort Worth metroplex. Although I went to Carnegie Mellon to study voice I wanted to have a career in musical theater. Like most people, college changed me. I graduated with a BFA, an entirely new set of skills, countless life experiences, and an undying love of opera. Now I’m in the graduate program at the University of California Santa Barbara and am on track to receive a Masters and Doctorate in Opera Performance. 

During my studies I was lucky enough to sing on the Amalfi Coast, fall in love with the city of Graz, Austria, and live in Lucca, Italy for a month, all while working with many leading composers and performers of today. Since starting graduate school I've also had the pleasure of teaching young performers and watching them grow. And I've grown with them. Now I live and work in Santa Barbara, CA, a city which has stolen my heart. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471714667370/Looking%20out%20over%20Budapest.jpg.jpg)
<figcaption>Mendez in Budapest. Photo: Zachary Mendez on [Instagram](https://www.instagram.com/zacharyamendez/).</figcaption>
</figure>

I am grateful every day to be able to do what I do. The road has not been easy. In fact, sometimes it's difficult to remember why I even wanted to do this in the first place. I often say that singers, including myself, are crazy. Nuts. I think one must be at least a little bit crazy to do what we do. If you're a student like me and you aren’t winning the Met Council Auditions at 23, studying voice is not always an easy task. It takes discipline, patience, hard work, and a whole lot of passion. I’m still a very young singer in the context of the textbook opera career, but my mindset concerning singing has changed dramatically since I began studying. 

My first experience with classical technique was with a private teacher based near my hometown. I studied with her throughout high school, singing songs like the Italian 24, Schubert, Quilter, as well as musical theater repertoire. I enjoyed working with foreign languages and was proud to be doing something none of the other kids at school were doing. As I mentioned, I also loved musical theater — I practiced my Tony acceptance speech weekly. When I began applying to colleges, my voice teacher advised me to apply to the voice programs rather than the theater programs. 

Luckily, I obliged. 

By the end of my freshman year at Carnegie Mellon, I had fallen head over heels for opera. Musical theater was in the dust, and my singing had changed dramatically. My timbre was darker and fuller and my peers told me I was not a tenor as I had always thought, but that I was in fact a baritone. This news was distressing to me because frankly — I didn’t want to be a baritone. 

Though my lessons were going well and my voice was changing, I didn’t understand why. I didn’t know what I was doing to make it happen. Technique? Did technique really even exist? I certainly didn’t know what that was. 

It was not until the summer after sophomore year that I began to believe in technique. For about three weeks I worked with a teacher (a mezzo, and still one of my most beloved mentors) who completely transformed the way I thought about singing. She helped me discover my real voice and was the first person to give me an idea of what technique really was. She told me I was a tenor! I needed a technique and finding the perfect one became my new goal. 

I went back to CMU and spent an agonizing junior year trying to prove to my teacher (a baritone) that I was a tenor. Though he was supportive and tried his best to help me, I knew he couldn’t teach me the technique I needed. I was a tenor. I believed it, and I needed someone else to believe it too. No one did. 

By the end of my junior year and after much deliberation I decided to switch voice studios. Though I didn’t grow much technically during my senior year, I was able to catch a mental break. My new teacher (a soprano) really believed in me. She even believed I was a tenor! She told me so in every lesson. She helped me find confidence in myself and in my voice. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471714741175/Graduation%20.jpg.jpg)
<figcaption>Graduation from Carnegie Mellon University. Photo: Zachary Mendez on [Instagram](https://www.instagram.com/zacharyamendez/).</figcaption>
</figure>

I applied to 5 graduate schools and was accepted to 3. I decided to move to California and study at UCSB with a tenor, my current teacher. We have a similar voice type, and every time I hear him sing I learn something about my own singing. I have so much respect and admiration for him, and I feel very lucky to be able to study with him. For the first time in my life I feel like I am developing a real technique. I finally believe that I am a tenor, and I know that other people believe it too. 

This means that I reached my goal! Right? Wrong. 

A few years back I made a pact with myself. I decided that I would commit to learning how to sing. What I meant was that instead of focusing on the outcome, on a job, or a final product, I would focus only on learning to sing beautifully. I thought that if the only goal was to make a Met or [insert major opera company here] debut, life would be very frustrating. The goal should be learning to sing in a healthy, natural way. The goal should be finding a perfect technique. That would be like winning the golden ticket to every opera house in the world. That should be the only goal. That’s what I thought, at least. 

Recently, I have redefined my goal. After spending so much time in search of technique, I realized that as singers, we are always listening to our bodies and trying to understand our instruments so that we can constantly fine-tune our approach to singing. Certainly, learning to sing with technique is vital to vocal health, longevity, and career potential. However, the fixation on technique can have debilitating effects on young singers. 

My own obsession with technique made me terrified to sing in front of my peers. I knew that they were only judging me: a baritone singing tenor rep. Worthless technique. I hated the feeling of judgmental eyes on me and I had nothing to say with the music I was singing. For me, technique was the only thing that mattered. But it’s not.

Technique is not the prize we win after a marathon of academic endeavors. It’s not a tangible sheet of paper we can frame and hang on our wall after graduation. It is carefully developed over time and it is not exactly the same for every singer. 

So then why do we all covet this intangible capacity to produce beautiful sounds? Because technique is the gateway to communication. We sing to express something that can only be expressed through music. Vocal technique allows us to communicate freely, without being hindered by our physical bodies. 

So, it isn't hard to see why technique has become desired by voice students across the country, and yes, it should be desired! Yet, sadly many of us are forgetting why. The entire purpose of singing is to communicate, to tell a story. 

That's what opera is. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471714796006/Singers%20should%20remember.jpg.jpg)
<figcaption>Photo: Zachary Mendez on [Instagram](https://www.instagram.com/zacharyamendez/).</figcaption>
</figure>

Today I feel a little bit like I did when I started singing. I recently decided to focus on enjoying singing again — to choose to be happy. I'm very happy here in Santa Barbara. I sing at school, with the opera company in town, and at the Old Mission. For the first time in a long time, I feel fulfilled. I am constantly working to be a better singer and to make my technique more consistent. However, I've made my new goal: to sing beautifully by saying something incredible, and I invite you to do the same.
