+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-06-09T10:52:00+01:00"
lastmod = "2016-06-10T09:40:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465468637679/2016-06-09---Goerne-Borggreve.jpg.jpg"
publishDate = "2016-06-10T09:28:00+01:00"
related_articles = ["articles/heavy-nights-schoenberg-brahms-the-lpo-and-goerne.md","articles/in-review-javier-camarena-at-wigmore-hall.md","articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/dont-miss-encounter-with-sondra-radvanovsky.md","articles/in-review-alek-shrader-at-wigmore-hall.md","articles/in-review-jamie-barton-at-wigmore-hall.md","articles/in-review-kitty-whately-joseph-middleton-at-wigmore-hall.md","articles/winning-combos-coote-drake-schubert.md","articles/livestreamed-in-recital-brancy-dugan.md"]
related_people = ["scene/people/matthias-goerne.md"]
short_description = "The character of the poet became more completely fleshed out with the Wolf, Shostakovich, and Brahms. It was almost like fan fiction, a satisfying sequel to Schumann&#039;s cycle that ends ambiguously and seemingly without resolve. Goerne&#039;s singing of the Brahms Ernste Gesänge&#039; left us heavy in our seats, the most stunning of which was his &quot;O Tod,&quot; half lullaby and half prayer."
slug = "recitals-that-stick-matthias-goerne-at-wigmore-hall"
title = "Recitals that stick: Matthias Goerne at Wigmore Hall"
+++

[Matthias Goerne](/scene/people/matthias-goerne/)'s recital at Wigmore Hall on Wednesday night was an exhaustive, impressive feat. With pianist [Daniil Trifonov](http://daniiltrifonov.com/), Goerne made the case for the "serious recital", with a programme devoid of anything that could be deemed "fluff", and instead packed densely with calculated storytelling.

For 90 minutes, Goerne and Trifonov moved seamlessly and without breaks through Berg's  *Vier Lieder*, Op. 2, Schumann's *Dichterliebe*, Wolf's *Drei Gedichte von Michelangelo*, three songs from Shostakovich's *Suite on Verses of Michelangelo Buonarroti* Op. 145, and finally Brahms' *Vier ernste Gesänge*, Op. 121. For both artists, there's obvious awe to be found in the physical and psychological stamina it takes to connect these heavy, murky sets of songs. What became the most thrilling was how their programme had been put together.

The Berg songs deal with sleep, *Dichterliebe* with love and rejection, the Wolf and Shostakovich with the end of life, and the Brahms are a more removed, objective observation of what's wonderful and terrible about living and dying. Combined, Goerne seemed to become a single character, with the story of *Dichterliebe* a central part of his life. It was an amazing example of how smart programming can create a recital that is greater than the sum of its parts.

Goerne sang with complete control over every note, and he made beautiful work of the German and Russian texts. His *Dichterliebe* told the story of a poet who grew to have more menace in him; at "Ich grolle nicht," there seemed to be danger in the scorned man, as if he could do violence. His "Hör ich das Liedchen klingen" was a total experience, like a thick, dark cloud looming over even the momentary sunny distractions. 

The character of the poet became more completely fleshed out with the Wolf, Shostakovich, and Brahms. It was almost like fan fiction, a satisfying sequel to Schumann's cycle that ends ambiguously and seemingly without resolve. Goerne's singing of the Brahms *Ernste Gesänge* left us heavy in our seats, the most stunning of which was his "O Tod," half lullaby and half prayer.

Not everyone could have pulled this off. It's almost unfair to say, since it's an extraordinary ask of any artist, but if one is going to do a "traditional recital", with no speaking or relaxing or clapping until the end, this is the way to do it. Goerne and Trifonov were a well-honed pair, and it was clear that the fractions of space between each song had been thought out as much as the notes themselves.

It's worth your time to hunt down the texts of this programme, and read them in the sequence of this recital. It's a testament to Goerne's deep relationship with this music. He could easily have presented himself as an artist who takes himself too seriously, but he truly did put the songs first; it was never about him.

Goerne returns to Wigmore Hall on June 27 with pianist Kristian Bezuidenhout, for a programme of Beethoven. [Find out more here](https://wigmore-hall.org.uk/whats-on/beethoven-201606271930).
