+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2020-05-20T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1590018096/media/2020/05/sqWhySing_luq6wl.jpg"
primary_image_credit = ""
related_articles = []
related_companies = []
related_people = []
short_description = "But now, that last card has been revoked. Live isn't currently an option, which means neither is an acoustic sound experience. Opera companies are being generous (perhaps too generous?) with their online offerings, but none of it includes that singular experience of hearing an unamplified voice carrying over an unamplified orchestra. "
slug = "without-the-acoustic-thrill-why-are-we-still-singing"
title = "Without the acoustic thrill, why are we still singing?"
youtube_url = ""

+++
About once every thirty-six hours, I wonder randomly about opera. Will we ever see a live _Ring Cycle_ again? Will that big _Parsifal_ that the COC is supposed to do in the fall actually happen (that's a selfish one, I admit, because I'm seriously in the mood for an opera marathon)? How long does the average singer have before the lack of gigs ousts them from the industry?

I'm not sure if it's a good use of energy to unpack all these what-if questions. These days, we're all wondering very aggressively about our respective futures, and the infuriating thing is that the answer hasn't really changed from any other time we wondered about days to come - we don't know!

I know, it's the worst.

But even in normal, non-pandemic circumstances, there's one very basic question that opera warrants, and I think it's worth a revisit in these exhilarating times. Here it is, perhaps to your chagrin:

_Why are they singing?_

It's a question that an opera newcomer has every right to ask, and one that an opera veteran might have forgotten the answer to. Years ago, my in-laws asked me a version of that question, after coming with me to see _Peter Grimes_. At the very end of that opera, there are a few spoken lines, and I imagine that's why they asked me on our way out of the theatre, "Why wasn't it all just a play?"

I think that was a version of, "Why are they singing?" And fair enough. For plenty of people, spoken storytelling feels the more natural, true medium; film and television sort of solidify this norm, particularly in recent decades. If we ask the "why" question of musical theatre - opera's more popular point of comparison - the answer is an interesting one because it takes into account that the characters move back and forth between speech and singing. Basically, when someone sings in a musical, it's because the dramatic stakes have risen to a point where speech no longer cuts it; they simply have to break into song.

> It's kind of an exciting new stressor placed on opera.

And with opera, the whole thing is ramped up. In most cases, recitative is the stand-in for speech; it's not as emotionally-laden as an aria or a duet, but dramatically speaking, recit is still a notch (or three) above talking. There are high notes, low notes, funky notes, weird rhythms, and orchestration to underscore it all. And when the recit does morph into a full-blown musical moment, it takes that extra step into the dramatic stratosphere.

This is all to say that adding music to a story is supposed to make it mean more. The emotional moments hit harder, the layers of expression are richer. And opera in particular has one more card to play - the unique power of the live acoustic voice. That kind of skilled performer, that kind of primal response to hearing a human voice at its best, it's the drug of choice for opera fans.

> Opera that's created in this new environment will have to pass the "why sing?" test.

But now, that last card has been revoked. Live isn't currently an option, which means neither is an acoustic sound experience. Opera companies are being generous (perhaps too generous?) with their online offerings, but none of it includes that singular experience of hearing an unamplified voice carrying over an unamplified orchestra.

If opera is to live online for months, even years, its creators will have to pay acute attention to the question of "why sing?". If we're not able to wow people with sheer skill or the comparably rare experience of a live, mic-free show, there are fewer reasons for people to sing their stories. I'm not sure that our usual rationales will carry weight; when we're watching it on the same screens we use for TV and film, it may not be enough to explain that opera has always been a fusion of music and drama, or that _La traviata_ is a damned masterpiece, or that Wagner was a brilliant megalomaniac. Opera has shared a playing field with great musicals and their film adaptations - _West Side Story_, _The Sound of Music_, _My Fair Lady_ - and now, it's also direct competition with things like _Frozen_ and _La La Land_ and _Mamma Mia!_ and maybe even _Rocketman_ and _A Star is Born_.

It's kind of an exciting new stressor placed on opera. On the one hand, it's lost one of its deadliest weapons because we can't go see things live; on the other hand, we might end up with some serious masterpieces, now that it's a small fish in a pond that unexpectedly got big.

Opera that's created in this new environment will have to pass the "why sing?" test: Are the characters singing because it's opera? Or are they singing because your story is [so good that speech just can't cut it](/angels-bone-i-finally-saw-it-and-im-never-going-to-be-the-same/)? I'm excited to see more of the latter.