+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-08-29T19:00:00-04:00"
lastmod = "2017-08-30T11:50:00-04:00"
preamble = "If you're an opera fan, you love being able to watch an HD broadcast of a show you missed. Also, if you're an opera fan, there are things about watching broadcasted opera that sort of suck the magic out of the experience. And if you're an opera singer, knowing your performance is being broadcast to cinemas and laptop screens around the world can add that extra spice of anxiety to an already-spicy job:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504059430263/2017-08-30---Film.jpg.jpg"
publishDate = "2017-08-30T10:34:00-04:00"
related_articles = ["articles/one-more-reason-we-dont-envy-singers.md","articles/talking-with-singers-sondra-radvanovsky.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "&quot;Mouth agape, molars in full view, eyebrows at the crown of the head, perhaps some bulging veins - they&#039;re all the product of singing one&#039;s face off. It&#039;s not always pretty, and the camera seems cruelly deft at showing you the sordid details.&quot;"
slug = "reason-947-we-dont-envy-singers-singing-on-camera"
title = "Reason #947 we don&#039;t envy singers: singing on camera"
+++

## Glances at the conductor

If you were watching a movie, and throughout a dramatic close-up shot the actor's eyes kept darting towards something clearly behind the camera, that would be super distracting, right? For opera singers, part of their stagecraft includes making room for them to glance outside the action and towards the conductor. It means that their eyes don't always stay "in the moment" in the same way that, say, Meryl Streep's do during That Scene in *Sophie's Choice*. But just like how film actors use multiple takes to deliver their best product, opera singers are entitled to have their eyes wander - even shoot desperately - towards the maestro.

It's one of those things that works well when opera happens in its "native environment", that is, with a bit of distance between the performers and the audience. Looking at the conductor is part of a singer's job, and the pros learn how to do it subtly. But when a camera zooms right up close, it's all too easy to spot those glances that seem to say everything from "just double-checking" to "*HELP!*"

## Singing for two audiences

In our 2016 interview, [Sondra Radvanovsky](/talking-with-singers-sondra-radvanovsky/) summed up the singer's cinema broadcast dilemma: "Do I sing it for those 4200 people who paid a lot of money for those tickets, and actually came and showed up at the opera house, or do I minimize my movements, and think about my gestures for the millions of people who are going to watch it in the cinema and on DVD?"

It's one of the larger dilemmas about bringing opera to the big screen as well as the big stage. If an art form has evolved in a certain performance space, how do its artists adapt to a second audience of a very different sort? What's fascinating about watching HD broadcasts is observing how every singer finds a different balance of singing for the people in the opera house, and the (likely larger) crowd in theatres or at home. Sometimes, it can make for a bit of a lopsided dramatic aesthetic, with some performers bringing stage-sized physicality to the camera, and others opting for subtler, screen-friendly acting.
 
## Singer face deserves some space

Just like the necessary eye contact with the conductor, the inevitable "singer faces" that come out of the technical demands of singing opera deserve a bit of buffer room. If you've never been up-close-and-personal with a singer when they're doing their thing, rest assured that it's a one-of-a-kind experience. Mouth agape, molars in full view, eyebrows at the crown of the head, perhaps some bulging veins - they're all the product of singing one's face off. It's not always pretty, and the camera seems cruelly deft at showing you the sordid details.

Allowing one's audience to basically see up their nose and down their throats - it's just another tick in the column called, Things Singers Aren't Afraid To Do.

## Stealing a scene is way harder

In a relatively short amount of time, the process of broadcasting opera has gone from the functional planting of a single camera to artful, multi-camera cinematography. Essentially, there's the stage director and the cinematographer, and they each inevitably have a large say in how the story of the opera is conveyed to their respective audiences. In its traditional environment, audiences can see the whole stage, and they often have a choice of where they direct their attention; particularly in crowd scenes, it can be fun to slowly scan the people onstage and watch the mini-performances happening behind the main action.

Watching a broadcast, audiences have less of a choice of what they see. Even in busy scenes with many people onstage, the cinematographer decides who gets the focus; your chances to scan the stage are limited to the broad-sweeping camera shots that run across the chorus. 

It seems a small thing, but opera on camera takes away some of the fun of those scene-stealing comprimario roles. Their well-timed bit of silent slapstick, or that priceless look they give might go wholly unnoticed, cancelled out by a camera change to the "important action". It's damn shame - but also another reason for the performers in HD broadcasts to remember their in-house audiences while they're singing to the cinemas.

>Readers, what are your experiences in watching opera broadcasts? Let us know in the comments below!
