+++
author = ["authors/vanessa-chumbley.md"]
categories = "Op-ed"
date = "2016-12-22T16:03:00-05:00"
lastmod = "2016-12-28T10:03:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1482442424445/2016-12-22---Work.jpg.jpg"
publishDate = "2016-12-28T10:03:00-05:00"
related_articles = ["articles/how-lucky-are-we-the-children-of-opera.md"]
short_description = "Is it okay for us to talk about this openly? Can we be honest for a minute about how difficult this is? After a while I started to notice that I wasn’t the only one feeling the strain, and I definitely am not the only one wondering if it&#039;s alright to talk about it. So I&#039;m here to talk about it. Openly, honestly, and publicly. And to invite others to be part of the real talk surrounding our endlessly difficult and confusing line of work."
slug = "real-talk-the-unspoken-realities-of-a-professional-artistic-life"
title = "Real talk: the unspoken realities of a professional artistic life"
+++

We've all had those conversations with close friends and colleagues – the ones about how to navigate the finances of being a freelance artist, what it means for our taxes and health insurance, and how we're to build a life on this career. I feel like these topics come up more often than not over drinks with a few of my more trusted colleagues. 

At first, many of these conversations began with an almost timid approach – is it okay for us to talk about this openly? Can we be honest for a minute about how difficult this is? After a while I started to notice that I wasn’t the only one feeling the strain, and I definitely am not the only one wondering if it's alright to talk about it. So I'm here to talk about it. Openly, honestly, and publicly. And to invite others to be part of the real talk surrounding our endlessly difficult and confusing line of work. 

I've never known any other life than that of an artist. Both of my parents are Juilliard-trained musicians. My brother and I grew up with music filling our home day and night, either from one of us practicing our respective instruments, or from my mother's piano students. After my father made the leap to management with various performing arts organizations, I spent much of my childhood running around rehearsal spaces or backstage at the theater, before finally crashing at opening night parties or donor events.

I guess the artistry, creativity, and inspiring people who made up my world had an impression on me, and I jumped ship from my traditional high school as soon as my mother would allow me to attend the University of North Carolina School of the Arts high school program. Those years are still the best of my life, and afterwards I attended another UNC school, Appalachian State, on a full music scholarship as a Violin Performance major. 

By the time I started college, I had an inkling that a life as a professional violinist was not for me. I didn't quite have the chops to make a real go at it professionally, and soon was honest enough with myself to know that I didn’t have the drive to spend eight hours a day in the practice room in order to make that happen. But I knew I had to stay involved in the performing arts. That’s where my people were, that's where my passion was. 

Long story short – I ended up in Stage Management. With no formal training in theater or stage management, through a lot of luck, help and hard work, I was able to create this career for myself. As most other stage managers, I make a living by freelancing all over the country with various opera and dance companies. I was able to spend the first five years of this career as a vagabond – using my mother's house as my "permanent" address, and going there when I had time off between contracts. Otherwise I lived wherever I happened to be working at the time, whether it was for six weeks or nine months. 

This was a great way to save money – I had basically no bills. I paid for an AirBnB when a contract did not provide housing, but some of them did. I was able to save the vast majority of the money I made, and I was good about actually saving it. Yes, I went on a few large international trips in those years – but traveling is truly one of the only non-essential things I choose to spend money on. Other than that, my savings account and Roth IRA were growing quite a bit. 

(As a side note, I have to mention that none of this would have been possible if it weren't for the support of my parents, both financially and otherwise. Given that my scholarship for college was actually for more money than my tuition, I got a refund check every semester. So I essentially got paid to go to school, which was incredibly fortunate. Since I used next to none of the money my parents had set aside for my education, they supported me almost 100% for two years after I graduated, while I was doing professional internships in stage management in order to gain the experience I needed. I am acutely aware that their support is a major reason I have gotten this far in this career.)

After living that way for about five years, I got to the point where I desperately wanted my own home. I felt a huge need to clear out of my mother's house, get my things out of storage, and find a place that was all my own. So earlier this year, I made the move to Milwaukee – a city I had come to love and call "home" over the couple of years I spent living and working there. 

And here's some real talk for ya – this year has been extremely difficult. Even without all the horrible things that have happened in the world this year, it’s been hard for me personally. All within about three months, I bought a car for the first time, moved into my own apartment with real life bills for the first time, and then got slammed with a truly awful debt to the government at tax time. The only way I was able to stay afloat was due to the savings I had acquired over the previous five years, and thank goodness I had that. 

I do not get benefits through my work, which I'm sure most of you can relate to. I have to find and pay for all of my own insurance and I have no one matching any contributions to my retirement accounts. My yearly income makes me wonder how I'm able to do anything at all, and sometimes I go for weeks between contracts where I am relying on the pennies I can get through filing for unemployment. 

While I didn't go to school for stage management, I gather from friends that most programs do not teach important life skills that theater majors will inevitably need far more than statistics or biology. For example, I didn't really understand before this year the differences between a W-2 and a 1099, which is why I got hit at tax time after working on many 1099 contracts last year. I’m still learning the various things that are tax deductible. I didn't file for unemployment for the first time until the fall of 2014, after I'm sure I had been paying into it for years. What exactly does a "right to work" state mean for me and my contracts in those states? And – why is shopping for and buying health insurance more difficult than anything in the whole world?!? Why doesn't AGMA have some sort of group plan now that Plan B isn't a thing anymore? These are all realities that make me want to pull my hair out. 

Even though I was able to fulfill my dream of becoming a stage manager, and then fulfill my dream of building myself a home in a city I love, I still feel lost a lot of the time. I feel lost, and also stuck. As a woman just a few years shy of the big 3-0 – I think a lot about the future. I want to get married, buy a house, get a dog, have children. 

But even though I have a home base now, I'm still freelancing a lot outside of Milwaukee. So how am I supposed to meet someone? And when I do meet someone – I should probably stop freelancing and get a job that will allow me to stay home and contribute more substantially to our family. But what comes first? Do I wait until I meet someone before settling down somewhere and finding that more secure job? Or do I find the job, settle somewhere, and hope I meet someone then?

Another harsh reality is the poverty line income that many of us make every year. That isn't sustainable, is it? When we want to buy a house or put our children through college – how are we supposed to make that work? I think a lot about transitioning into another job, and possibly another field altogether. This is almost exclusively driven by my worry over money, and has very little to do with enjoying my work as a stage manager. Because the truth is – I love what I do. I think stage management is a nearly perfect job for me. But again, is it sustainable? On the other hand, I don't want to make a career choice solely based on money, even though I am sometimes tempted to just walk out on my contracts and into an MBA or nursing program. 

There are, of course, the fortunate few who have landed a more permanent stage management gig, and a job like that would be my dream. But how long do I wait to see if that dream will come true? And because there is no one way to obtain success, or no one "right" path in this field, it's very difficult to model our own choices and moves on people we admire who have reached that success, because everyone came about it differently. 

Another reality that has been difficult for me to be honest about is if I will feel like a failure if I switch careers in search of more stability and financial security. When I made the decision to move away from performing and put down my violin, I knew in my gut that I was making the right decision. I felt peaceful and hopeful about my new adventure. Now, when I consider leaving stage management, I am wrought with feelings of stress, sadness, confusion, and uncertainty. 

At the end of the day, I do think I could be happy doing something else, something that would provide more stability. And I believe I could still live an artistic and creative life even without depending on it for income, I just always get stuck on what exactly I would do if I left this career. And when, and how, and where. This is where my thought process becomes fragmented and the feelings of stress and uncertainty take over, making me feel stuck once again. 

In an [earlier Schmopera article](/when-lost-find-roots/), I wrote about re-discovering our roots when we're feeling lost. It is truly helpful to remind ourselves of how and why we got here. I think most of us feel lost at one point or another, and it's important that everyone knows we're not alone in feeling stressed about money, or our future, or the stability of this life that we felt compelled to be a part of. And don't be afraid of the real talk – we're in this together.
