+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-05-11T18:24:00-04:00"
lastmod = "2018-05-11T21:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526076778374/sqDSC_5117.jpg.jpg"
primary_image_credit = "Nelson Ebo (Stan) in Fidelio, Heartbeat Opera, 2018. Photo: Russ Rowland."
publishDate = "2018-05-11T19:58:00-04:00"
related_articles = ["articles/fidelio-still-political-in-2018.md","articles/wendy-bryn-harmer-leads-sensitive-inspirational-fidelio.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
related_people = ["scene/people/kelly-griffin.md","scene/people/derrell-acon.md","scene/people/daniel-klein.md","scene/people/malorie-casimir.md"]
short_description = "Video projections reinforce the inmates&#039; commitment to music and text, their chins raised, brows gently furrowed, and lips outstretched to form German vowels. The singing is emotionally wrenching in its delicate roughness."
slug = "real-prisoners-voices-make-heartbeat-operas-fidelio-resonate"
title = "Real Prisoners&#039; Voices Make Heartbeat Opera&#039;s &quot;Fidelio&quot; Resonate"
+++

Beethoven's *Fidelio*, in a [new adaptation by Ethan Heard](/fidelio-still-political-in-2018/) produced by Heartbeat Opera, updates easily with a plot that centers around contemporary issues like wrongful conviction, queer romance, and the indignity faced by staff and inmates in modern America's prisons.
 
In Heartbeat Opera's production, Florestan becomes Stan ([Nelson Ebo](/talking-with-singers-nelson-ebo/)), a naturalized citizen and Black Lives Matter activist whose wrongful conviction separates him from his wife Leah (equivalent to Leonora/Fidelio, played by [Kelly Griffin](/scene/people/kelly-griffin/)) and lands him in a Supermax facility, where he starves, nearly dead, in indefinite solitary confinement.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077196076/DSC_6339.jpg.jpg)
<figcaption>Nelson Ebo (Stan) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>
 
What makes this *Fidelio* worthwhile is that Heartbeat Opera has teamed up with six mid-western prison choirs to rehearse and record Beethoven's sublime prisoner's chorus for use in the production.
 
The mechanics of the partnership between Heartbeat and the various correctional facilities are thoroughly reported and worth reading about. Here are some links: [Schmopera's report](/fidelio-still-political-in-2018/); [*New York Times*' article](https://www.nytimes.com/2018/05/04/arts/music/beethoven-opera-fidelio.html); Rehearsal footage from [Heartbeat's YouTube channel](https://www.youtube.com/watch?v=J_ipFPVLUS8); and a [CNN report](https://www.cnn.com/2018/03/23/us/prisoners-beethoven-opera-trnd/index.html).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077206924/DSC_5413.jpg.jpg)
<figcaption>Derrell Acon (Roc), Malorie Casimir (Marcy), and Kelly Griffin (Leah) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>
 
Leading into the chorus, Leah convinces Marcy (AKA Marzelline, played by [Malorie Casimir](/scene/people/malorie-casimir/)), whose recent managerial promotion gives her increased authority, to allow the inmates a half-hour in the yard against the warden's orders. Once alone, Leah opens the cell doors and the real-life prisoners' voices begin echoing through the theater. Pre-recorded but with live accompaniment from Daniel Schlosberg's superb instrumental ensemble, the chorus' sound slowly precipitates from the imaginary, off-stage yard, vibrating over the audiences' collectively cocked heads, ears upturned towards an entirely truthful rendition of the famous chorus.

Video projections reinforce the inmates' commitment to music and text, their chins raised, brows gently furrowed, and lips outstretched to form German vowels. The singing is emotionally wrenching in its delicate roughness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077217269/DSC_5911.jpg.jpg)
<figcaption>Malorie Casimir (Marcy) and Killy Griffin (Leah) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>

This production succeeds, as with the prisoners' chorus, when it explicitly engages with the opera's themes as they relate to contemporary America.
 
Stan's arrest is dramatized at the top of the show. An illuminated rectangular patch of ground reveals the activist in a neutral stance. Lights turn off, then flash back on. Now Stan is protesting, fist raised in salute. Freeze frames continue, showing a sequence that brings Stan to his knees, hands behind his back, face forced into the ground, in a succinct, well-acted display of the racial injustice and violent indignity brought reflexively upon black men without just cause.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077226943/DSC_6506-2-2.jpg.jpg)
<figcaption>Derrell Acon (Roc) and Nelson Ebo (Stan) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>
 
Before the opera's staged events, Roc ([Derrell Acon](/scene/people/derrell-acon/)), an African-American jailer and the father of Marcy, stops a so-called riot by beating black inmates nearly to death. Why? Because the prison's warden Donnie Pizarro ([Daniel Klein](/scene/people/donnie-pizarro/)) has threatened to fire the jailer if he doesn't follow orders, regardless or their legality. Blackmailed into complicity, Roc helps Pizarro conceal the unlawful conditions under which Stan is currently held.
 
Conflict erupts between Roc and Stan when Roc refuses the starving prisoner any sustenance. With escalating, racially specific language, Stan accuses Roc of betraying black inmates to protect the white, racist, criminal warden. Roc flips out and threatens to beat the chained prisoner. He grabs Stan's head violently, then melts. The two calmly, silently, gently hold each other's faces – a brief but transformational moment of contact between veritable allies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077237782/DSC_5923.jpg.jpg)
<figcaption>Kelly Griffin (Leah) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>
 
Derrell Acon is ideal as Roc the jailer. His consistently ringing tone, naturally elegant phrasing, and ease as an actor with both spoken English and sung German anchor the drama.
 
A genuine heroic tenor is rare, but that's what the role of Florestan demands and what Nelson Ebo is. The simplest indicators are the might of his upper register and the heft in his lower and middle voice. At the top of his range, Ebo's ring doesn't cut through the orchestral texture so much as overwhelms it. It's thrilling to hear an instrument as extraordinary as Ebo's live.

Malorie Casimir is an ebulliently charming Marcy. Her voice suits the role and like Acon, she switches easily between English speaking and German singing. Unfortunately, Marcy's realization that Leah sexually manipulates her in order to free Stan is never seen on stage. Because it turns out most of this *Fidelio* is a dream.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077269037/DSC_6210.jpg.jpg)
<figcaption>Derrell Acon (Roc), Daniel Klein (Donnie Pizarro) and Kelly Griffin (Leah) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>
 
At the production's climax, Leah whips out a camera phone in time to capture Pizarro threatening his illegally held, brutalized inmate. Immediately, the warden's superior summons Pizarro to his office for disciplinary repercussions. With justice seemingly served, Leah, now back home, wakes up and realizes she has dreamt the whole thing.

It's a cliché ending. I understand that a redemptive finish might feel disingenuous. But too much of the piece feels like a broad, liberal fantasy. The dream as a plot device is unhelpful, as Leah's wish-fulfilling subconscious creates a tendency towards stock, two-dimensional characters.
 
Case in point, warden Donnie Pizarro is an unredeemable caricature that panders to the company's already converted audience. Klein is a capable enough actor that he tries to balance Pizarro's table-standing, hand-wringing, blackmailing evil with a workaday nonchalance, but not enough light shines through to illuminate Pizarro's humanity. Even the most heinous racist is more than the sum of his evils, and responsible theater must acknowledge and demonstrate that fact.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526077347911/DSC_5874.jpg.jpg)
<figcaption>Kelly Griffin (Leah) in *Fidelio*, Heartbeat Opera, 2018. Photo: Russ Rowland.</figcaption>
</figure>

I hope Heartbeat can tour this humanizing production with some story alterations and added strings to replace the double piano in Daniel Schlosberg's neutered orchestration. Piano is a non-legato, decaying, percussion instrument that inadequately approximates violins. Hammering away, the pianos compete with the singer's voices and render the two cellos, the band's only strings, negligibly puny.
 
But this production's value is in a reality beyond the theater. After curtain calls, co-founder Louisa Proske read from one of many letters written by inmates about the experience of learning and recording Beethoven's score. Proske read, "I have been a part of East Hill Singers for almost 5 years now and while not that great of a singer I have been fortunate to meet and bond with a great group of people." She paused a moment and swallowed, before finishing, "and I almost feel free."

>Heartbeat Opera's *Fidelio* runs through May 13. For details and tickets, [click here.](http://www.heartbeatopera.org/fidelio/)
