+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2018-01-22T12:48:00-05:00"
lastmod = "2018-01-22T20:00:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516642874398/sq---SeraphicFire-40.jpg.jpg"
publishDate = "2018-01-22T20:00:00-05:00"
related_articles = ["articles/in-review-the-whisper-opera.md","articles/parts-passio-closes-seraphic-fires-passionate-season.md"]
related_people = ["scene/people/amanda-crider.md"]
short_description = "In his introduction, Quigley explained, &quot;We understand ‘passion&#039; to mean an exploration and a meditation on human suffering.&quot; The four works on the program shared this theme of suffering and loss, but Seraphic Fire transformed this superficial thematic similarity into a compelling and heartfelt story, building an innovative, accessible, and deeply moving experience far beyond delineation into categories of time period or genre."
slug = "reaching-across-centuries-seraphic-fires-the-little-match-girl-passion"
title = "Reaching across centuries: Seraphic Fire&#039;s the little match girl passion"
+++

In his original program note to accompany *the little match girl passion*, [David Lang](/scene/people/david-lang/) concisely summed up the work's purpose: "I wanted to tell a story."

Storytelling lay at the core of [Seraphic Fire](http://www.seraphicfire.org/)'s January program. The Grammy-nominated vocal ensemble, led by conductor Patrick Dupré Quigley, presented a selection of Renaissance laments by Josquin des Prez and Nicolas Gombert, culminating in Lang's highly anticipated passion. The result was a cohesive narrative arc, the similarities between the works – stylistic, thematic – coalescing across centuries in a meaningful 80 minutes of song.

Josquin's *Nymphes des bois* was sung with resonance and gravity, crisp consonants interleaved with Seraphic Fire's trademark precision. This was followed by *Super flumina Babylonis*, a brief yet breathtaking display of virtuosic blend; and by Josquin's *Miserere*, described by Quigley in his introduction to the program as "a tour de force [...] almost on a symphonic scale." The ensemble captured a range of color and texture that toyed with tension and release, meditative duos sung in stereo thrust suddenly into a dense mesh of shifting harmonies.

Finally, *the little match girl passion*: a 15-movement rendering of Hans Christian Andersen's original tale, alternating with meditations and poems written by Lang himself. The work imagines Andersen's "The Little Match Girl" as a sacred text, its heroine – impoverished, ostracized, and resurrected – not-so-subtly calling a certain figure to mind. Performed beneath the sloping ceiling of a church, and following a set of Renaissance works with no shortage of the words "Domine" and "Deus," Lang's passion felt decidedly at home.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516643126334/A3wsqvbekQKim74T4fGbSVmNYDkfYLw1BvDnBFUFfKF4SXSNMjkPLCgNLY7g1BN3Uopwoja17Oaz1ld3yhGoen2qcEA%3Dw1360-h1360)
<figcaption>David Lang, composer of *the little match girl passion*. Photo: Peter Serling. </figcaption>
</figure>

The story central to *the little match girl passion* is that of Hans Christian Andersen's long-suffering protagonist, a young girl sent by her abusive father to sell matches, shoeless, in the frigid cold streets. She lights a match for a brief moment of warmth, and then she lights another, seeing in their flames a series of joyful visions – a roast goose, a Christmas tree, her late grandmother's smile. Soon, all the matches are spent, and the little girl freezes to death, her spirit reunited with her grandmother in a better place.

"*the little match girl passion* represents some of the greatest art to come out of the American experience," Quigley stated in his introduction. Awarded both a Pulitzer and a Grammy, the passion weaves deft text painting – most strikingly, the rapid repetition of single words like the chattering of teeth – with a palette of glowing harmonies and rich, churning clusters. The highlight of the piece came during the thirteenth movement, "when it's time for me to go," with mezzo-soprano [Amanda Crider](/scene/people/amanda-crider/)'s stirring ostinato solo painting urgent brushstrokes above the ensemble's densely blended meditation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516643053448/SFGroup2d.jpg.jpg)
<figcaption>Photo courtesy of Seraphic Fire.</figcaption>
</figure>

In his introduction, Quigley explained, "We understand 'passion' to mean an exploration and a meditation on human suffering." The four works on the program shared this theme of suffering and loss, but Seraphic Fire transformed this superficial thematic similarity into a compelling and heartfelt story, building an innovative, accessible, and deeply moving experience far beyond delineation into categories of time period or genre.

Seraphic Fire is the experimental opera company South Florida never knew it had. Meticulous performance paired with thoughtful, narrative programming to lend a sense of theatre – spellbinding, immersive – far more fringe than outward appearances might lead one to believe. South Florida audiences can look forward to two more passions this season – one by [Bach](http://www.seraphicfire.org/performances/tickets/j-s-bach-st-matthew-passion/), one by [Arvo Pärt](http://www.seraphicfire.org/performances/tickets/arvo-part-passio/) – continuing the ensemble's dedication to exquisitely performed music across eras, and proving, time and again, that Seraphic Fire has a story to tell.
