+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-10T21:26:00-04:00"
lastmod = "2017-10-17T21:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508195090640/2017-10-16---square---RB_Schlather_Portrait.jpg.jpg"
publishDate = "2017-10-17T21:01:00-04:00"
related_articles = ["articles/an-organic-integration-the-wake-world.md","articles/feminist-truths-the-mother-of-us-all.md","articles/the-rose-elf-hot-times-in-the-cool-catacombs.md"]
related_companies = ["scene/companies/glimmerglass-festival.md"]
related_people = ["scene/people/rb-schlather.md","scene/people/christopher-alden.md","scene/people/michaela-martens.md"]
short_description = "Not only is Schlather&#039;s latest project site-specific, but one which is in response to a performance space&#039;s unique history. &quot;That&#039;s exciting for me, and it&#039;s the continuation of explorations that I&#039;ve been doing for the past couple years,&quot; he says. These explorations, he explains, haven&#039;t always been clear in direction, but they have always ben led by the question, &quot;what does it mean to do this opera in this location?&quot;"
slug = "rb-schlather-susan-b-anthony-connecting-opera-with-community"
title = "R.B. Schlather, Susan B. Anthony, &amp; connecting opera with community"
+++

"I first saw it in 1998 at Glimmerglass Opera," says stage director [R.B. Schlather](/scene/people/rb-schlather/) of *The Mother of Us All*, the opera by Gertrude Stein and Virgil Thomson. "They were going to take us to see it on a school trip, and they said it's an opera about [Susan B. Anthony](https://en.wikipedia.org/wiki/Susan_B._Anthony). I honestly thought, 'what could be more boring?'"

Instead of boredom, Schlather became "totally obsessed" with the opera and the production by Christopher Alden, watching a total of six performances during the Glimmerglass run and buying the production recording. "I was so totally turned on by it, I just thought it was so funny and moving, and Christopher's production was great," he says. It's a love that has stuck with him since his school years. "I could sing the entire thing right now."

Next month, Schlather brings his own conception of [*The Mother of Us All*](http://hudsonhall.org/2016/11/15/the-mother-of-us-all-directed-by-r-b-schlather-november-11-12-18-19/) to the historic Hudson Opera House in Hudson, NY, a space that holds meaning both for the director and for the subject of the piece. Coincidentally, Schlather first visited Hudson on a recommendation from Christopher Alden, who dubbed it "the coolest town ever," and exploring the Opera House (renamed Hudson Hall this year) was one of his first stops. 

"I found out that Susan B. Anthony had spoken there twice, once about abolition and once about suffrage," says Schlather. In a beautiful intersection of persistence and good timing, Schlather's idea of bringing *The Mother of Us All*, the opera about the pioneer of women's suffrage in the United States, coincides both with the significant renovations of Hudson Hall, and with the centennial of New York state's signing into law the ability for women to vote.

## "What does it mean to do this opera in this location?"

Not only is Schlather's latest project site-specific, but one which is in response to a performance space's unique history. "That's exciting for me, and it's the continuation of explorations that I've been doing for the past couple years," he says. These explorations, he explains, haven't always been clear in direction, but they have always ben led by the question, "what does it mean to do this opera in this location?"

Schlather's question is about creating a cohesive piece of theatre that looks outside of itself; it's also about acknowledging what opera can offer - and uniquely so - to contemporary audiences. "People want intimacy," he says. "When you're doing an opera, you have to provide something that you can't get from Netflix." For Schlather, creating a marriage of space and spectacle is something tangible that sets live theatre apart. "What I think is so great about opera is that it's so visceral, to be up close to these musicians making these noises, and going through these intense emotional experiences." Wanting to go one step further, he asks: "How do you create this social gathering, and have people come together and have this cathartic experience that means something?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508195103997/2017-10-16---Schlather-Hudson.jpg.jpg)
<figcaption>R. B. Schlather on the stage of the restored and renovated Hudson Hall. Photo by Matthew Placek.</figcaption>
</figure>

In the past, Schlather's questions about opera's function and form have included open-door rehearsal processes like his [*Alcina*](/good-ideas-rehearsal-as-performance/) with New York's WhiteBox Art Center, and site-and-medium-specific inspirations like his recent world premiere of David Hertzberg's [*The Wake World* with Opera Philadelphia](/an-organic-integration-the-wake-world/), set among the artwork of the Barnes Foundation. 

"This seems like a logical progression of these experiments", says Schlather of *The Mother of Us All*. "In a way, it will be the most complete realization of these questions."

## "The whole piece feels to me like your Facebook feed."

He likens the opera to Shakespeare's *Hamlet*, in that, "you don't really do it unless you have a Hamlet." Schlather's Hamlet - or in this case his Susan B. Anthony - is mezzo-soprano [Michaela Martens](/scene/people/michaela-marten/s). The role holds a special kind of "heft" among the cast of over 30 characters, yet "There's a very strong feeling of ensemble," making up what Schlather calls "these non-sequitur solo moments." 

"The whole piece feels to me like your Facebook feed," he laughs. "You scroll through your Facebook feed, and there's a really intense political post, some odd cat video, some weird cry for help, and then somebody trying to sell a dishwasher." It's a similar experience in Gertrude Stein's libretto, "one character after another bleeding out these statements."

It's a significant task to cast a large ensemble opera, yet the community in Hudson seemed to respond generously to the demand. "There are tons of musicians up there, and people really came out of the woodwork," says Schlather of the open-call audition process he held with his team. He heard working professionals alongside people who hadn't sung since their high school years. "Their joy for singing was so potent that I just thought, 'you have to be in the show.'"

"We had this totally amazing variety of people, this diversity of ages and types of people and types of voices," he says, adding that the assortment of performers seemed in tandem with the continued relevance of *The Mother of Us All* and the rhetoric of Susan B. Anthony. "Casting these people who are from the region, being viewed by people who are from the region, just seems like this phenomenologically potent experience about our shared contemporary."

"These issues about equality that are so scarily at the forefront of all of our minds right now, I think it's going to be very healing, to have this space where people can gather." For Schlather, the crisis of this opera is familiar and current: "Do I sit at home and rant with my partner, or do I go out into the world and politicize my body and politicize myself and really try to change the social landscape?"

His own responses is to create. "When I despair, I go back to the music, I go back to opera," he says. "I've always found opera to be a space where you can learn about yourself, and the more you learn about yourself, the more you can offer your community, I think."

>[The Mother of Us All](http://hudsonhall.org/2016/11/15/the-mother-of-us-all-directed-by-r-b-schlather-november-11-12-18-19/) plays for five performances, November 11-19, at Hudson Hall. For details and ticket information, follow our box office links below.
