+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-05-14T21:24:00-04:00"
lastmod = "2018-05-15T09:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347404391/sqAT9A0573Orphic.jpg.jpg"
primary_image_credit = "Bobbi Jene Smith and Anthony Roth Costanzo in Orphic Moments, National Sawdust, 2018. Photo: Eric Baiano."
publishDate = "2018-05-14T21:24:00-04:00"
related_articles = ["articles/futuristic-baroque-burlesque-orphe.md","articles/orpheus-eurydice-in-the-hands-of-a-theatrical-genius.md","articles/simulacrum-futuristic-angst-and-dance.md"]
related_people = ["scene/people/anthony-roth-costanzo.md"]
short_description = "The work has finally reached a larger New York audience with two performances in an elegantly expanded version at Lincoln Center&#039;s Rose Theater. It features the 130-member MasterVoices and the Orchestra of St. Luke&#039;s. Smartly directed by Zack Winokur, the production has a sleek and courtly feel, enhance by Stacey Berman&#039;s stylish costumes."
slug = "ravishing-orphic-moments-with-gluck-aucoin-costanzo"
title = "Ravishing Orphic Moments with Gluck, Aucoin &amp; Costanzo"
+++

Ravishing best describes the subtly titled *Orphic Moments*, the joining of Christoph Gluck's *Orfeo ed Euridice* and Matthew Aucoin's *The Orphic Moment*. First produced by the acclaimed countertenor, [Anthony Roth Costanzo](/scene/people/anthony-roth-costanzo/), who sings Orfeo, at Brooklyn's National Sawdust, it moved on to the Salzburg State Theater.

The work has finally reached a larger New York audience with two performances in an elegantly expanded version at Lincoln Center's Rose Theater. It features the 130-member MasterVoices and the Orchestra of St. Luke's. Smartly directed by Zack Winokur, the production has a sleek and courtly feel, enhance by Stacey Berman's stylish costumes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347214601/AT9A0099Orphic.jpg.jpg)
<figcaption>Kiera Duffy and Anthony Roth Costanzo in *Orphic Moments*, Rose Theater, Lincoln Center, 2018. Photo: Eric Baiano.</figcaption>
</figure>

Gluck's reformist opera and Aucoin's contemporary dramatic cantata seem as destined to be performed together as Orfeo and Euridice are, in this version, to be apart. Gluck is liberating opera of the musical conventions and esoteric stories that dominated opera seria with a work that is seeped in myth and nature. Aucoin, while providing a provocative interpretation of Orfeo, indeed, a rethinking of the myth, is pondering his character's artistic motivation and, in the process, revealing compelling ways of expressing it. He wrote the cantata's lyrics as well as the music.

Aucoin composed it for Costanzo, who performs with lithe strength and beauty. Orefo is a role Costanzo knows well, having sung it throughout his career. His interpretation has achieved a level of authority that is deepened by the changes that Aucoin brings to the character. Costanzo's stage movement and florid gestures, executed with the grace of a dancer, are effective embellishments that suit both Orfeos perfectly.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347227155/AT9A0415Orphic.jpg.jpg)
<figcaption>Kiera Duffy, Bobbi Jene Smith, and Anthony Roth Costanzo in *Orphic Moments*, Rose Theater, Lincoln Center, 2018. Photo: Eric Baiano.</figcaption>
</figure>

Gluck saved opera from imploding. Aucoin and Costanzo have contemporized Gluck's work, and preserved its dignity in the process. If the opera now appears anti-climatic without the seventeen-minute cantata interspersed near the end of its final act, all the more reason to include this contemporary piece.

The story that attracted Gluck, and other composers including Monteverdi and Berlioz, is significantly altered in *Orphic Moments*. It begins when Orfeo, who is the world's most famous singer, and Euridice are married. At the wedding party, a snake bites Euridice and she dies. Taken into the underworld, a grieving Orfeo follows after her where he uses his voice to convince the gods to give her another opportunity to live. His request is granted on the condition that he not look at her until they reach the light. At the last moment he turns to gaze upon Euridice. Unlike the myth, *Orphic Moments* does not offer yet another chance to save Euridice. She is taken back to the underworld forever.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347241556/AT9A0704Orphic.jpg.jpg)
<figcaption>Kiera Duffy and Anthony Roth Costanzo in *Orphic Moments*, Rose Theater, Lincoln Center, 2018. Photo: Eric Baiano.</figcaption>
</figure>

Aucoin's cantata evokes the dark side of artistic ego. Orfeo realizes that great singing can be inspired by love and loss, and he senses the opportunity to compound that inspiration by taking the forbidden glance and losing Euridice once again. His glorious and extravagant singing, as Aucoin has described it, has served him well so far. Clearly, he is seizing the opportunity to advance his art. He succumbs, not to base and irrational human instinct as the myth purports, but in order to gain artistic advantage. His art is more important to him than Euridice. 

Costanzo navigates with ease between the stately arias and recitatives of Gluck and Aucoin's largely atonal score. Despite the marked musical shift, the transition is as smooth as it can be when two musical worlds intersect. So captivated are we, that it takes a few moments to notice that the music has become distinctly modern.

In Aucoin's cantata, a solo violin, played by Keir GoGwilt, speaks for Euridice. Bobbi Jene Smith, a modern dancer, assumes her body. They express what words, sung or spoken, cannot adequately convey. GoGwilt battles with a drum as Smith dances to harsh and tormented choreography. The cantata is sparse with hard lines as if Aucoin is giving Orfeo musical comeuppance for his act of artistic ego.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347256010/AT9A9713Orphic.jpg.jpg)
<figcaption>Anthony Roth Costanzo and Lauren Snouffer in *Orphic Moments*, Rose Theater, Lincoln Center, 2018. Photo: Eric Baiano.</figcaption>
</figure>

Like Costanzo, [Kiera Duffy](/scene/people/kiera-duffy/), who sings Euridice, possesses a dancer's poise. She has a vibrant soprano that plaintively expresses her despair, and, because she is prohibited from knowing the terms of her release from the underworld, also the confusion caused by Orfeo's seeming indifference. She and Costanzo give the impression that a *pas de deux* could take over at any moment. Their intense acting enhances the lovely and sad moments that they share.

In act one, soprano, [Lauren Snouffer](/scene/people/lauren-snouffer/) appears as a janitor in a jump suit who is artfully pushing a broom. Unnoticed by Orfeo, she approaches him, jumps out of the jump suit and reveals the character of Amore, chic in red slacks and gold wings. She brings mischievous charm and a decidedly contemporary air to Amore who tells Orfeo how be can bring Euridice back from the underworld.

MasterVoices provides what its name implies, and does so with resonance and clarity on stage where their smoothly blocked scenes add an element of grandeur. When placed in the three tiers above the stage at the Rose Theater, they sound and look impressive as vocal and visual architecture. During that time MasterVoices is an audience that is visible to us. This suggests that we are watching an opera within an opera, an indication that something unusual might happen, which, of course, it does.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526347280128/AT9A9904Orphic.jpg.jpg)
<figcaption>Members of MasterVoices and Anthony Roth Costanzo in *Orphic Moments*, Rose Theater, Lincoln Center, 2018. Photo: Eric Baiano.</figcaption>
</figure>

Ted Sperling, the artistic director of MasterVoices, conducts the Orchestra of St. Luke's on this occasion. They move gracefully through Gluck and Aucoin, producing the lush and taut playing that is required. St. Luke's brings assurance and commitment to the diverse challenges presented by *Orphic Moments*.

Near the end of the second act, when Orfeo is entering Elysium and the beauty of the landscape moves him, four male dancers dressed in black appear and lift him into the air. Reminiscent of the exquisite techniques used by the Handspring Puppet Company in the National Theater's 2007, *War Horse*, Costanzo soars as he sings "Che puro ciel." Airborne by the dancers and tossed about in a number of breathtaking configurations, he remains remarkably impassioned and vocally steady. This ravishing moment is not diminished when, as *Orphic Moments* ends, Orfeo is left alone in the dark.
