+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-03T09:51:00+01:00"
lastmod = "2016-05-03T11:31:00+01:00"
preamble = "Photo: [Tech. Sgt. Matt Hecht](https://www.flickr.com/photos/satransport/8349998703), [Flickr](https://creativecommons.org/licenses/by/2.0/legalcode)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462270041741/2016-05-03---Helicopter.jpg.jpg"
publishDate = "2016-05-03T11:25:00+01:00"
related_articles = ["articles/young-pups-and-puccini.md","articles/music-school-auditions-4-tips-for-parents.md","articles/5-tips-for-university-auditionees.md"]
short_description = "So, because training for opera takes patience and nurturing, and rarely results in the kind of fame and fortune that makes terrible parents proud, have we escaped the curse of stage moms and dads? Is opera an ironic blind spot, ignored by the validation seekers in favour of TV commercials and youth beauty pageants?"
slug = "rarities-opera-stage-parents"
title = "Rarities: opera stage parents"
+++

Opera is no isolated genre; it's deeply connected with its artistic cousins. It's a melding of music and theatre, elements that not only stand on their own, but can be re-shuffled into various combinations and delivered to an audience. Drama and music can add up and equal opera, but they can also equal music theatre, ballet, oratorio, and even straight theatre with no music implied.

Yet for all the shared aspects between opera and other stage genres, there's one thing that opera is happily lacking: stage parents.\*

Stage moms and dads are definitely a thing when it comes to classical music; there's ironically no shortage of prodigies at the piano or holding tiny little violins, mastering Rachmaninoff and Sarasate before they hit puberty. Young dancers are often reminded of the ticking clock, slowly closing the window of a potential career on the stage, and a high value is placed on young dancers' achieving as much as they can, as quickly as they can. In the world of actors, there are parents who push their kids to become stars by dragging them to auditions for commercials, TV and film. This world too favours youth, and more than a little bit, cuteness.

Stage parents exist in music theatre circles, too, yet there's something less intense, more big-picture about this ilk. Perhaps it's the honing of the "triple threat" skill set that deters overbearing parents from laying on heavy pressure; developing acting, singing, and dance skills to the necessary levels simply takes time, perhaps so much time that it negates any sense of the "ticking career clock". Parents can berate a child all they want, but that kid will not be able to be young Cosette in *Les Misérables* on Broadway until she can either read or expertly sing back not-that-simple music, and develop a level of comfort onstage that allows her to sing without tension (read: without hurting herself). And, if parents are taking their triple-threat-in-training offspring to great teachers, those teachers are likely vouching for the long-game approach with their young student.

Opera seems to be a few more steps in this same direction, and it's interesting to muse on why an art form that survives on the excellence of its artists isn't more of a tempting choice for stage parents and their pressures. It's true that plenty of parents are invested in having their kids excel at something, to develop extraordinary skills, and not always with the promise of a big paycheque to follow. And with enough repetition, young musically-inclined kids really can learn to play all the Chopin Études and everything by Paganini. They can also get the hang of memorizing lines and figuring out what makes them a cute child actor. Yet with singing, it's totally different. The opera singer's extraordinary skills won't show by the age of 10. In some cases, opera singers won't sound like they know what they're doing until they've hit their 30s.

So while it kind of *should* be a gold mine for helicopter parents, opera kind of weeds out bad influences like this all on its own. The fame/money motivation is out: opera singers don't get famous enough for parents to drag them around to auditions for the Young Shepherd in *Tannhaüser* or the Three Boys in *Die Zauberflöte*, and even if they get these gigs, the pay isn't anything to write home about. The incredible-for-his-or-her-age motivation is out, too; the roles that *could* put an opera singer on the map aren't the child roles, and children simply not built to sing the adult roles before they're, well, adults. Any great voice teacher will remind pushy parents that "great for 25 years old" is not a thing in opera circles, and "great for 10 years old" means absolutely nothing.

Sure, there are a handful of "child opera singers" that surface for about 15 minutes when they make a splash on TV talent shows, and they may indeed have stage moms from hell. But getting your kid a spot on *America's Got Talent* just isn't the same as "making them an opera singer".

All the opera parents we've ever met have been proud of their kids, and they constantly check in on what really matters: their happiness factor. They're frankly not left with many options except to support the opera singer in their family, attend their performances, and let them sleep in on show days.

So, because training for opera takes patience and nurturing, and rarely results in the kind of fame and fortune that makes terrible parents proud, have we escaped the curse of stage moms and dads? Is opera an ironic blind spot, ignored by the validation seekers in favour of TV commercials and youth beauty pageants?

***

\*There's precious little written about stage parents specific to aspiring opera singers, so without supportive peer-reviewed studies, we can offer musings and conclusions based on our own experience in the opera world.

