+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-12-17T11:38:00-05:00"
lastmod = "2017-12-18T12:37:00-05:00"
preamble = "Dubbed \"a new experiment in old music\", [Quintus 4](https://www.quintus4.com/) is set on  finding a new way to put on a concert. Making up the [ensemble](https://www.quintus4.com/bios/) are soprano [Suzanne Kantorski](/scene/people/suzanne-kantorski/), percussionist Krystina Marcoux, cellist Juan Sebastian Delgado, and pianist and composer [Rich Coburn](/scene/people/rich-coburn/). \n\nWe spoke with Kantorski and Coburn about their newest concert programme, *Tresillo*, and Quintus 4's pursuit of what truly unifies music of all styles and ages:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513610252902/2017-11-30---square---Quintus-4.jpg.jpg"
primary_image_credit = "(l-r): Suzanne Kantorski, Juan Sebastian Delgado, Krystina Marcoux, Rich Coburn."
publishDate = "2017-12-18T12:15:00-05:00"
related_articles = ["articles/the-score-how-to-see-what-a-composer-sees.md","articles/collectif.md"]
related_people = ["scene/people/suzanne-kantorski.md","scene/people/rich-coburn.md"]
short_description = "&quot;A themed recital can mean many things, but the program is often not tied together by the actual music. This is a little like taking an architectural tour of houses owned by people with the same surname. It might still be interesting, but it&#039;s not what we&#039;re trying to do.&quot;"
slug = "quintus-4-has-no-choice-but-to-have-a-unique-sound"
title = "Quintus 4 &quot;has no choice but to have a unique sound.&quot;"
+++

## What's your "elevator pitch" for Quintus 4?

**Suzanne Kantorski**: Quintus 4 is a new experiment in old music! We stir horizontal histories and genres together to create this innovative, and dynamic concert going experience for everyone that is completely unique. We love surprising and intriguing our audiences with how people are connected to each other through music no matter how diverse the background. Music is truly a unifying, universal language — and that philosophy is at the core of our work!

**Rich Coburn**: We're pioneering a new way to create a concert, as well as to share content. We do this by building brand new artistic and business models. Many of the greatest challenges to traditional classical music organizations are actually advantageous to us!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513610525004/2017-11-30---Quintus-4---2.jpg.jpg)
<figcaption>The members of Quintus 4, l-r: Juan Sebastian Delgado, Suzanne Kantorski, Krystina Marcoux, and Rich Coburn.</figcaption>
</figure>

## How does your experiment in concert programming differ from the idea of putting together a "thematic" program?

**SK**: Well, we do use a thematic system, we just treat it differently. We identify a device, such as a rhythm or musical pattern, and then fuse together everything we can find across music history (including today) that shares it. The result is something remarkable, and an exciting challenge to perform!

**RC**: A themed recital can mean many things, but the program is often not tied together by the actual music. This is a little like taking an architectural tour of houses owned by people with the same surname. It might still be interesting, but it's not what we're trying to do.

Our premier program — [*Tresillo*](https://www.quintus4.com/tresillo/) — is based on a rhythm of the same name. We explore how it literally exploded out of Cuba and became a global phenomenon and the foundation for dozens of genres. We show you how *Carmen*'s "Habanera", "Besame Mucho", and "Despacito" — among the most popular songs every written in their respective genres — can all be tied together by one of the most influential rhythms in the history of Western music. 

## What do you think makes for program notes - or their online equivalents - that "you actually want to read"?

**SK**: I hate program notes. Not just because they usually a snooze to read, but also because, generally, it isn't anything anyone can't just look up on the Internet. We don't need to feed the audience the music through a single lens, but rather invite them to investigate what interested them most. When you attend a rock concert… they don't issue you a program, they talk to you from the stage. We like the idea of interacting with the audience, and sharing our experiences anecdotally, and then give them the resources to go further down a rabbit hole of curiosity if they are piqued. We provide all kinds of fun additional information and links on our site to explore.

**RC**: If I'm interested in biographical details or the history of a piece, today I'm looking it up myself. Yet this is what accounts for the vast majority of all the program notes I see.  The bar has been drastically raised in the smartphone era, and I'm not convinced that many have risen to the challenge. 

Consider the massive podcast industry. A big slice of that pie is podcasts about things that we may not even have been interested in before we started the episode. Yet they bring entertainment and often educational value to the consumer. Q4 wants our program notes, blogs and videos, to meet this same standard; they need to be engaging and they need to present a unique perspective or opinion that our public isn't going to find somewhere else. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513610481193/Quintus-headshots.jpg.jpg)
<figcaption>Suzanne Kantorski, soprano, and Rich Coburn, pianist/composer.</figcaption>
</figure>

## Being a "non-standard ensemble", what are some advantages and some challenges to creating your own arrangements?

**SK**: Of course very advantageously, arrangements that are custom fit for our ensemble play directly into our individual strengths - which allows us to set the bar for performance as a group, very, very high. We are all professional, classically trained artists, but we think it's also interesting to push the limits of our own skills, which also keeps things fresh and exciting for us.

**RC**: The downside is that we have to arrange everything for ourselves, which includes me learning to write for vibraphone and cello. But the upside is massive, including that we get to arrange everything for ourselves! 

As a composer, I can say that playing your own music is a very different, and often more intimate, experience than playing the music of others. I've actually [written about this on Schmopera before](/the-score-how-to-see-what-a-composer-sees/). Our whole ensemble is involved in workshopping the music, and that gives everyone what I consider this "composer's advantage". It also means that we can tailor the music to tell the story of tresillo as clearly as possible, as well as to our individual strengths and personalities. 

Finally, I've heard no shortage of lamentation from my senior colleagues about the homogenization of sound, be it among singers, pianists or whomever. Q4 has no choice but to have a unique sound; I've literally never heard this configuration of instruments before!

## In your opinion, what is the difference between a performance you'd consider "good", versus one that's "great"?

**SK**: For my part, I consider a great performance something that translates directly from you, and your own life experience to another person as authentically, and fearlessly as possible... everything else, is just good.  

**RC**: When I think of the great performances that I've seen — including film, theatre, or even oration — I think about leaving the theatre somehow a different person than I was when I walked in. Whether the performance has taken me to a moment of quasi spiritual ecstasy or posed a profound and beautiful question, it has always added something to who I am. I leave tangibly excited by this new piece of myself. I hope that doesn't sound too esoteric. But we are definitely striving at Quintus 4 give people something new that ignites their imagination, and we think that our approach to the music gives us a good chance to do this.

>Stay in the loop with Quintus 4 by [reading their blog](https://www.quintus4.com/blog/welcome-to-quintus-4-hbnkc), and following them on [Facebook](https://www.facebook.com/Quintus.4.music/), [Twitter](https://twitter.com/quintus4_music), and [Instagram](https://www.instagram.com/quintus.4/).
