+++
author = ["authors/greg.md"]
categories = "Review"
date = 2023-05-18T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684504429/sqCOC_Macbeth_22-23-05-MC-D-0275.jpg"
primary_image_credit = "Quinn Kelsey as Macbeth in the Canadian Opera Company's new production of Macbeth, 2023, photo: Michael Cooper."
related_articles = ["articles/talking-with-singers-quinn-kelsey.md", "articles/great-music-distracting-sexuality-rigoletto.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/quinn-kelsey.md", "scene/people/matthew-cairns.md", "scene/people/alexandrina-pendatchanska.md"]
short_description = "To say the singing was excellent is an understatement. The line was solid through the whole range and completely unfazed by whatever physicality Kelsey took on. He managed the dramatic journey with great finesse as well. Macbeth, although a noble, and later a King - he's somewhat content to be in his position."
slug = "quinn-kelseys-macbeth-a-haunted-manipulated-husk-of-a-man"
title = "Quinn Kelsey's Macbeth: a haunted, manipulated husk of a man"
youtube_url = ""

+++
Hello, Schmop-tops,

Very few pieces of literature hold the public's imagination like those of Shakespeare. They've been recounted, retold, and reimagined over and over. Masterpieces like _Romeo and Juliet_, _A Midsummer Night's Dream), _King Lear_ and _Hamlet_ only scratch the surface of what came out of the Bard of Avon's quill and ink.

None seem to have held us enthralled quite like that _Macbeth_. Yes, I said it. _Macbeth_. Look, I did it twice. Not only is it an amazing story of bloodthirsty ambition and manipulation, it also features an element of the mystical (not uncommon in Shakespeare - faeries in _Dream_, Ariel and Caliban in _The Tempest_, the Soothsayer in _Julius Caesar_) but this one hits closer to home. _Macbeth_ rocked the early 17th century by including a very real, very close-to-home fear of Christians at the time: witchcraft. The guise and guile was so convincing the play has been shrouded in a curse ever since. The rumour is that some of the witch's text - we don't know which ones exactly - are _actual spells_ that Billy the Shake lifted under nefarious circumstances and thus the play was cursed by the violated coven. This is why we don't say the name Macbeth when we're in the show. There we call it "The Scottish Play" - or in this case, opera - or just "Maccers." Okay. There's my nerd muscle flexed. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684504429/COC_Macbeth_22-23-05-MC-D-0407.jpg){{% /md %}}

<figcaption>A scene from the Canadian Opera Company's new production of Macbeth, 2023, photo: Michael Cooper.</figcaption>
</figure>

Now we get another giant of his industry taking this already incredible work and blowing it up in a way only he can. Verdi's adaptation of the original is a perfect match. Verdi's skill with an orchestra and how to place a vocal line for maximum beauty and effect is strikingly evident. 

Why bring this up? 

Last month the Canadian Opera Company opened the remount of their production of Verdi's _Macbeth_. Directed by Sir David McVicar, a co-production with Lyric Opera of Chicago was last seen here in 2005. This time around, maestra Speranza Scappucci leads the cast and the COC Orchestra, and holy moly can she conduct. The tempi were dynamic and vibrant, and the conducting of the voicing in the orchestra was delicious. She brought us liquid, languid andantes and blistering but controlled prestissimi. The players, as always, play to such a high calibre of artistry and panache the production is taken to phenomenal heights. 

Tackling the title role of the Scottish King is baritone [Quinn Kelsey](/scene/people/quinn-kelsey/). Ummm... wow! To say the singing was excellent is an understatement. The line was solid through the whole range and completely unfazed by whatever physicality Kelsey took on. He managed the dramatic journey with great finesse as well. Macbeth, although a noble, and later a King - he's somewhat content to be in his position. King Duncan favours him, he has a title, a wife, full coffers, but he's not an overtly ambitious man - until he encounters the witches and tells their prophecy to Lady Macbeth. Watching Kelsey transform from noble soldier into a haunted, manipulated husk of a man was singing-acting at its finest. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684504429/COC_Macbeth_22-23-05-MC-D-0595.jpg){{% /md %}}

<figcaption>(l-r) Quinn Kelsey as Macbeth and Önay Köse as Banquo (covered in blood) in the Canadian Opera Company's new production of Macbeth, 2023, photo: Michael Cooper.</figcaption>
</figure>

Turkish bass [Önay Köse](/scene/people/onay-kose/) as Banquo was also thrilling. A full, warm, tone able to produce quite a bit of volume without sounding even remotely close to "woofy". It was clean and velvety. The pairing of him and Kelsey was magical. Their voices blended together beautifully, but they were also a great pair of actors together. There was an electric moment after the witches revealed that Macbeth will be king but Banquo will be the "father of kings". They both momentarily celebrate the good fortune for their bloodline and kin, but then realize what the only way for the crown to go from Macbeth to Banquo's line actually is. It's a palpable moment when you see trust vanish between two men who loved each other as brothers.

Lady Macbeth is no easy role, be it either Shakespeare or Verdi. In the opera, the role is quite rangey, but sits fairly low for what would be expected in a Verdi Soprano. It's less Violetta in _Traviata_ and more Alice in _Falstaff_. Soprano [Alexandrina Pendatchanska](/scene/people/alexandrina-pendatchanska/) is a lovely singer, with a fantastic voice. I don't think she was well-matched for this particular role. The top of her range was glorious and her roulades and flourishes were excellent. I felt there may have been a bit too much chest voice work too early on in the score. I can see using it as a dramatic effect (in particular during the "Out, damn spot" aria,) but too much of it, I feel, robbed Pendatchanska of the vocal line she was building. I also feel this led her physicalization of the Lady to be a little demonstrative and melodramatic. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684504429/COC_Macbeth_22-23-05-MC-D-0346.jpg){{% /md %}}

<figcaption>Önay Köse as Banquo in the Canadian Opera Company's new production of Macbeth, 2023, photo: Michael Cooper.</figcaption>
</figure>

Tenor Matthew Cairns has proven many times that he's a voice to watch. His Macduff is no exception. His piano was so delicate yet so piercing it sounded as though he was quietly singing next to you in your seat. Then when the full voice is unleashed it's quite a thing to experience. His aria "Ah, la paterno mano" was a definite highlight of the night. When joined by fellow Tenor and COC Ensemble alum Adam Luther as Malcolm, the two carried the careening falling action for the last act all the way to its bloody conclusion with fervour and flair. 

A large cast of supporting members, each of them excellent in their own right, showed the very complex life of a noble in a time of great political upheaval. 

Then there are the witches. One of the coolest effects Verdi accomplished is taking the three crones and turning them into a three-part chorus of crones. The effect is haunting and chilling, and in the hands of the treble voices in the COC Chorus spine-chilling. This is one of the best performances by the chorus I've seen yet. Their semi-choregraphed staging and physicality added a bizarre other-worldly tone to the already mystical women. It was surprisingly "dancey" and at no point was their top-level musicianship compromised by extending themselves so readily. They were also represented by three child actors serving kind of as their avatars. It was a very creepy effect and kudos to those three young actors Hawthorne Wilde Fowler, Mila McQuat, and Beatrice Schneider! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684504429/COC_Macbeth_22-23-05-MC-D-0733-730.jpg){{% /md %}}

<figcaption>A scene from the Canadian Opera Company's new production of Macbeth, 2023, photo: Michael Cooper.</figcaption>
</figure>

The costume design (Moritz Junge) and set design (John Macfarlane) was very colonial witch-hunt era - which is an interesting choice considering how little the witches actually play into the plot. They're only visited twice by Macbeth over the course of four acts (five in the Shakespeare) and their scenes are very brief. I love witchy stuff - don't get me wrong - it's my favourite corner of the "horror" umbrella, but _Macbeth_ isn't a story about witches, nor is it a story about magic and sorcery, yet I felt the production leaned very heavily on the witches prediction. The true story is in Lady Macbeth's ambition. The witches' prophecy is just the spark that lights her ambition like a pile of kindling. She drives Macbeth to kill Duncan, and that's what breaks Macbeth's moral code and she leads him into deciding for himself to take care of Banquo and Fleance. I felt like a lot of her power and manipulation was taken from her and given to the witches, who in the original, are a neutral party telling the future. They don't care who is King, they were asked a question and answered it. They aren't team Macbeth trying to get him on a throne, nor are they anti-Maccers and want to stop him. 

All in all, the singing is fantastic and it looks great. Is it my favourite _Macbeth_? Probably not. Is it an entertaining night of opera at the theatre - absolutely.