+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-09-25T10:24:00-04:00"
lastmod = "2017-11-11T14:20:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428033601/2017-11-11---rolled-R.jpg.jpg"
publishDate = "2015-09-29T08:00:00-04:00"
related_articles = ["articles/4-secrets-for-better-high-notes.md","articles/how-to-really-learn-a-song.md","articles/how-to-play-for-singers.md","articles/kristen-seikaly-on-how-to-learn-a-role.md","articles/how-to-lead-your-pianist.md","articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/hot-topics-singers-who-scoop.md","articles/how-much-to-tell-your-students-about-the-voice.md","articles/dear-me-advice-to-my-freshman-self.md","articles/3-ways-your-english-is-showing.md","articles/4-english-language-habits-that-make-a-singers-life-harder.md","articles/the-practice-tip-you-dont-want-to-hear.md"]
short_description = "What I&#039;ve found is that rolled Rs in a singer&#039;s text can act as a sort of litmus test for where that singer is maintaining their resonance. As a coach, if I ask for more consonants in an Italian aria, and a rolled R seems difficult to project, the problem usually lies in the preceding vowel."
slug = "quick-tips-the-rolled-r-test"
title = "Quick tips: the rolled R test"
+++

Singers, do you like a good rolled R? I know not everyone has the lingual facility to do this, and plenty of us English speakers have to practice making a sound that's so foreign to our own language. I'm not about to get into teaching rolled Rs (although [this article](http://www.trevorhuxham.com/2014/02/10-tips-for-rolling-spanish-r.html), [this Reddit thread](https://www.reddit.com/r/linguistics/comments/15l3tm/please_help_me_roll_my_rs_my_life_depends_on_this/), or [this video](https://www.youtube.com/watch?v=cjoOD8SVhos) may help.

Most singers today work to avoid a swallowed sound, one that is considered "too far back" in placement, favouring instead a "forward placement," toward the cheekbones, canine teeth, forehead, and nasal cavity (in various combinations). An easy way to feel backward voice placement is to simulate a yawn, saying a dark [a] vowel in the back of your throat. Conversely, sustaining a rolled R demands that the voice is placed more forward; consider how hard it is to roll an R while yawning.

What I've found is that rolled Rs in a singer's text can act as a sort of litmus test for where that singer is maintaining their resonance. As a coach, if I ask for more consonants in an Italian aria, and a rolled R seems difficult to project, the problem usually lies in the preceding vowel. 

The opening to "Porgi, amor" (*Le nozze di Figaro*) is a great example. If the O in "porgi" is too closed, like the O in the German word "[Tod](https://en.wiktionary.org/wiki/Tod)" (or in the stereotypical Minnes**o**tan accent), the rolled R will be hard to sing on, and even harder to hear. The word calls for an open O, anyway, which fits beautifully with the soprano's plan to keep her sound "forward." Another great example: [Canio's aria](https://www.youtube.com/watch?v=-kbi1EMcD3E) from *Pagliacci*, which begins with the word, "recitar," as if Leoncavallo was *daring* tenors to sing well.

The same concept applies to singing on the letters M and N. The word "sempre" in Italian, can easily sound like "sepre" without enough humming on the M. If singers find this difficult to do, take a step back and evaluate the position of your [ɛ] vowel.

>Singers, what else have you discovered about text and voice placement? Let us know your thoughts and tips in the comments below!
