+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-02-23T10:43:00-05:00"
lastmod = "2016-02-23T11:47:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456243228958/2016-02-23---Figaro-Ensemble-MC-Square.jpg.jpg"
primary_image_credit = "A scene from the Ensemble Studio performance of The Marriage of Figaro, Canadian Opera Company, 2016. Photo: Michael Cooper."
publishDate = "2016-02-23T11:47:00-05:00"
related_articles = ["articles/not-quite-review-coc-ensemble-barber-of-seville.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/iain-macneil.md","scene/people/karine-boucher.md","scene/people/gordon-bintner.md","scene/people/aviva-fortunata.md","scene/people/jacqueline-woodley.md","scene/people/jeanphilippe-fortierlazure.md","scene/people/aaron-sheppard.md","scene/people/jordan-de-souza.md","scene/people/jennifer-szeto.md","scene/people/russell-braun.md","scene/people/jane-archibald.md","scene/people/erin-wall.md","scene/people/megan-latham.md"]
short_description = "These annual performances are often a cornerstone for the members of the Ensemble Studio. It&#039;s a unique experience, both as a performance and as a learning process; rarely in their lives will these young artists have so much rehearsal time, coachings with multiple members of music staff, or compounded staging rehearsals (both as understudies and as principal roles). "
slug = "quasi-review-the-ensemble-studios-figaro"
title = "Quasi review: The Ensemble Studio&#039;s Figaro"
+++

Each year, one performance of the Canadian Opera Company's season is reserved for the artists of the Ensemble Studio; they work as understudies and take on small roles throughout the principal run, and at the same time they rehearse towards their unique performance that puts these young artists into leading roles.

Previous Ensemble Studio performances have included *The Barber of Seville*, *La clemenza di Tito*, *The Magic Flute*, and *Semele*; this year, they step into Claus Guth's production of [*The Marriage of Figaro*](http://www.coc.ca/PerformancesAndTickets/1516Season/TheMarriageofFigaro.aspx), running at the COC until February 27.

These annual performances are often a cornerstone for the members of the Ensemble Studio. It's a unique experience, both as a performance and as a learning process; rarely in their lives will these young artists have so much rehearsal time, coachings with multiple members of music staff, or compounded staging rehearsals (both as understudies and as principal roles). It's inversely proportional to the singular show in which it all culminates, making it a test not only of the Ensemble's onstage game, but of the mental game that goes with it.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456245088942/15-16-04-E-MC-D-3767.jpg.jpg)
<figcaption>Karine Boucher as Susanna and Iain MacNeil as Figaro in the Ensemble Studio performance of the Canadian Opera Company’s production of *The Marriage of Figaro*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

Opinions and notes fly at these young artists in layers; they work with every teacher, coach and dramaturg at their disposal (wonderful luxuries of the Ensemble Studio program), all while paying close attention to their duties covering singers like Jane Archibald, Erin Wall, and Russell Braun. The pressure and the hype can be enormous, and when it comes to *The Marriage of Figaro*, there's already enough to do with Mozart's score.

I write this not as a true review, since I'm fortunate enough to know these young artists' voices well, and I know they're a great bunch of people; the positive bias is a strong one. I also know of the crapshoot-like element to the Ensemble Studio performance; the choice of opera is dependent on the COC's season, and while the administration does a great job of choosing pieces that can feature as many young artists as possible, the nature of their work on the mainstage is largely out of their hands.

Although not all of the COC's young artists were featured in *Figaro*, the casting was, I thought, perfect. I thought the same about the mainstage cast, that the voices were beautifully paired together, and it felt as though I was watching the quintessential versions of Susanna, the Countess, Figaro, the whole bunch. The same happened with the Ensemble Studio cast.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456245136446/15-16-04-E-MC-D-4473.jpg.jpg)
<figcaption>Aviva Fortunata as the Countess and Gordon Bintner as the Count in the Ensemble Studio performance of the Canadian Opera Company’s production of *The Marriage of Figaro*, 2016. Photo: Michael Cooper</figcaption>
</figure>

I'm not exaggerating when I say that everybody sounded the best I've heard them. In the title role, [Iain MacNeil](/scene/people/iain-macneil/) had a clear, piercing sound with lots of personality; there's some exciting stuff happening with his rich baritone, and Figaro will stay an important role for him for a long time. [Karine Boucher](/scene/people/karine-boucher/) put her gorgeous, womanly voice into the role of Susanna; it was the perkiest role I've heard her sing, and I thought she was a beautiful mix of wisdom and longing, facets of Susanna that fit well with Guth's bleak production.

As The Countess, soprano [Aviva Fortunata](/scene/people/aviva-fortunata/) showed a new picture of professionalism and poise onstage; there was new maturity in the voice, a level of comfort with Mozart's music that allowed us to pay attention to her smart acting abilities. She made a real person out of the brooding Rosina, including fantastic comic timing in the kerfuffle-like scenes. She was a force alongside [Gordon Bintner](/scene/people/gordon-bintner/) as Count Almaviva; the two of them had a chilly relationship that was ever so slightly cartoon-like, and wonderfully familiar. Bintner's Count was a true sight to see. Vocally, the role fits him like a glove, and his long, graceful figure put just the right amount of exaggeration into his mannerisms to let us laugh, but keep us wary of the villain.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456245229138/15-16-04-E-MC-D-4111.jpg.jpg)
<figcaption> (left to right) Iain MacNeil as Figaro, Jacqueline Woodley as Cherubino and Gordon Bintner as the Count in the Ensemble Studio performance of the Canadian Opera Company’s production of *The Marriage of Figaro*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

Tenors [Jean-Philippe Fortier-Lazure](/scene/people/jean-philippe-fortier-lazure/) and [Aaron Sheppard](/scene/people/aaron-sheppard/) were in great vocal shape as Don Basilio and Don Curzio. They were both funny without stealing scenes (except when you want them to steal scenes); roles like these a great teasers, making me eager to hear more of them, and in larger amounts.

The unique cast included two more singers, not currently members of the Ensemble Studio, yet a fantastic change of pace from the already stellar mainstage cast. Mezzo-soprano [Megan Latham](/scene/people/megan-latham/) was hilarious as Marcellina, bringing out a funny, real relationship with [Robert Pomakov](/scene/people/robert-pomakov/). She was one of my favourites to watch for so-called "background" facial experessions; I felt like I'd known this Marcellina for years. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456245274970/15-16-04-E-MC-D-5063.jpg.jpg)
<figcaption>A scene from the Ensemble Studio performance of the Canadian Opera Company’s production of *The Marriage of Figaro*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

As Cherubino, soprano [Jacqueline Woodley](/scene/people/jacqueline-woodley/) was totally stunning. Without a special show like this, we might never have seen the full potential for Woodley's pants role skills. She was such an endearing Cherubino that our hearts broke; he was less antsy, more the young romantic, which again worked well with Guth's take on his affections for the Countess (there's more reciprocity than usual). There's a curious take on Susanna's aria, "Venite, inginocchiatevi," where there's a bit of a ménage-à-trois happening with Cherubino, Susanna, and the Countess. Whether or not you're a fan of the scene, which to some appears gratuitous, Woodley showed serious, heartwarming acting as the young lover who *can't believe this is happening to him*.

Finally, Ensemble Studio pianist [Jennifer Szeto](/scene/people/jennifer-szeto/) took on the enormous task of playing continuo for the evening. In shows with a lot of recitative, the young pianists too get an overwhelming amount of input from fellow music staff (when it comes to playing continuo, the number of varying opinions is almost laughable). The pressure can seem just as high for a young pianist as for the singers who step on the stage. Brava!

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456245343349/15-16-04-E-MC-D-5014.jpg.jpg)
<figcaption>(left to right) Karine Boucher as Susanna and Aviva Fortunata as the Countess in the Ensemble Studio performance of the Canadian Opera Company’s production of *The Marriage of Figaro*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

Even without the hype of this particular performance, the Ensemble Studio's *Figaro* was novel, fresh, and very real. It was an impressive result of their exhaustive rehearsal process, and it was a special thing to see such growth in these young artists. Their performance was a complete one, much, *much* more than simply an "attempt". Bravi, team!

>The Marriage of Figaro runs for three more performances, two of which feature maestro [Jordan de Souza](/scene/people/jordan-de-souza/) at the podium (February 23 and 25). For details and ticket information, [click here](http://www.coc.ca/PerformancesAndTickets/1516Season/TheMarriageofFigaro.aspx).
