+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-11-10T12:31:00-05:00"
lastmod = "2018-11-10T12:57:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541871051128/sqCPORequiem.jpg.jpg"
primary_image_credit = "Clockwise from left: Jill Grove, Katie Van Kooten (Photo: Sussie Ahlburg), Jung Soo Yun, and Petri Lindroos."
publishDate = "2018-11-10T12:31:00-05:00"
short_description = "performance. Each instance of the &quot;Dies Irae&quot; theme, in which the chorus competes with a bombastic orchestra, was performed with gusto and confidence. The choir also excelled in its polyphony, with the challenging &quot;Sanctus&quot; and &quot;Libera me&quot; fugue performed well on this night."
slug = "quartet-breathes-the-divine-into-verdi-requiem"
title = "Quartet breathes the divine into Verdi Requiem"
+++

This weekend, much of the world will observe the 100th anniversary of the armistice that ended World War I. In Canada, November 11th marks Remembrance Day; with it falling on a Sunday, this year, most symphonies and orchestras have programmed a Requiem or a fitting work to pay tribute to the brave women and men who paid the ultimate sacrifice both in times of war and peace. The Calgary Philharmonic Orchestra has turned to an international cast of singers to anchor its weekend production of Verdi's *Requiem*.

When it first premiered in Milan in 1874, some believed the work to be too operatic and thereby too secular to be performed as an ecclesiastical work. Today, Verdi's *Requiem* serves as a standard of vocal-orchestral concert repertoire. Indeed, Verdi's Requiem requires its singers - both solo and chorus alike - to prepare adequately for the lush onslaught of some of the composer's most bombastic and dramatic writing.

On this night, the Calgary Philharmonic assembled a solid quartet of international singers who, alongside the orchestra and chorus, breathed the divine into this epic work.

Of the four soloists, American soprano Katie Van Kooten may have taken a little longer than her counterparts to settle her voice in this production. Her moment of arrival came in the "Quim sum miser tunc dicturus" section, in which the quartet asks rhetorically to whom they may turn on the day of reckoning. From that movement onward, Van Kooten's dramatic voice soared over the orchestra comfortably without the slightest hint of distress or fatigue; she handled the two-octave writing with aplomb and still had more than enough in the tank to lead the chorus in the final "Libera me" with a shimmering, angelic quality.

South Korean Jung Soo Yun offers a clean, piercing tenor that meshed well with his quartet colleagues. He performed the challenging "Ingemisco" movement with warmth, while the colours in his voice evoked the penitent nature of the text effectively. At times, his lack of eye contact with the audience made him appear less engaged in the performance, but the beauty and power of his bright, spinning tone more than compensates for this small transgression.

Arguably, the Calgary Philharmonic can attribute the divine performance to the strength of its mezzo-soprano and bass-baritone soloist. American Jill Grove was clearly in her element as she navigated Verdi's challenging writing. From her opening notes in the "Christe eleison" to her final notes in the Lux aeterna, Grove's voice is meant to sing this work. Her rich, expressive voice reverberated into the hall with a sense of calm that set the tone for the entire performance. Her higher tessitura, as evidenced in the "Liber scriptus" movement, was especially pleasant with roundness and vibrancy that she carried seamlessly into her lower-middle register. 

The rumbling bass of Finnish singer Petri Lindroos anchors this quartet and, indeed, the entire performance. Lindroos clearly knows how to perform this work as evidenced by his ever-present eye contact with the audience. His smooth, liquid vocals were full of nuance, colour and vivacity that breathed an ethereal quality into his performance. In particular, Lindroos delivered the "Mors stupebit" and "Confutatis maledictis" movements rumbled commanding authority. His performance was a privilege to experience in person.

The full force of the Calgary Philharmonic Orchestra, under the direction of Maestro Rune Bergmann, performed exceptionally on this night. The expanded trumpet section gave a thrilling surround-sound performance of the celestial trumpet ahead of the Tuba mirum, although the space between instruments led to a bit of a delay between harmonies. The percussion section should also be feted, filling the hall with booming authority during the "Dies Irae" movements.

Special mention should be made of the chorus, who delivered a crisp, spirited performance. Each instance of the "Dies Irae" theme, in which the chorus competes with a bombastic orchestra, was performed with gusto and confidence. The choir also excelled in its polyphony, with the challenging "Sanctus" and "Libera me" fugue performed well on this night.

With a talented international quartet of soloists, a first-rate orchestra and well-prepared chorus, this production of Verdi's *Requiem* fittingly honours the many lives lost in times of war and in times of peace, including those who paid the ultimate sacrifice a century ago.

>The Calgary Philharmonic Orchestra's run of Verdi's *Requiem* concludes with a performance on Saturday, November 10 at the Jack Singer Concert Hall in downtown Calgary. The orchestra will live-stream this concluding performance. For more information, visit calgaryphil.com.

