+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-07-09T15:38:00-04:00"
lastmod = "2015-07-20T08:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437253913615/LAPhilBW.jpg.jpg"
primary_image_credit = "The Cleveland Orchestra under Franz Welser-Möst. Original photo by Roger Mastroianni"
publishDate = "2015-07-20T08:52:00-04:00"
related_articles = ["articles/how-to-lead-your-pianist.md","articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/music-as-theatre-a-chamber-concert-in-banff.md","articles/public-practicing-pet-peeves.md","articles/opera-orchestras-robots-or-out-of-the-loop.md","articles/emotional-extremes-bringing-your-work-home.md","articles/instruments-can-sing-too.md","articles/the-orchestra-problem-should-they-smile-more.md","articles/great-love-affairs-singers-and-pianists.md"]
short_description = "Ever since I started working more primarily with singers, I&#039;ve learned a lot about what it means to be onstage. Unlike pianists, violinists, cellists, clarinetists, etc., singers are their instrument; this is the case when they&#039;re making sound, and when they&#039;re standing in silence during musical introductions, postludes, and interludes."
slug = "putting-on-show-instrumentalists"
title = "Putting on a show &amp; other things instrumentalists can learn from singers"
+++

Ever since I started working more primarily with singers, I've learned a lot about what it means to be onstage. Unlike pianists, violinists, cellists, clarinetists, etc., singers *are* their instrument; this is the case when they're making sound, and it's the case when they're standing in silence during musical introductions, postludes, and interludes.

Instrumentalists, by comparison, can have some generally bad stage-presence habits. It's something that's much less prevalent in professional players with plenty of stage experience; I notice the trend more commonly among instrumentalists who are younger and still in a world of academia and training programs. The theme of these big habits is this: instrumentalists forget that they're onstage, putting on a show.

Symptoms include: slumping in one's chair, noisily dragging music stands and benches around to one's favourite spot, taking *forever* to tune, and avoiding eye contact with the audience at all costs. My biggest pet peeve is the erasure of any sort of mood between movements or songs; instead of a nice, palate-cleansing moment to breathe, I'm often reminded of what it sounds like in church, when the congregation is allowed to sit back down again.

Look, I get it. Instruments are finicky. Piano benches are never at the right height; tuning pegs can be uncooperative; brass and woodwind instruments can house saliva in astonishing amounts. My point is, the audience doesn't care, and they should come first. 

I'll compare again instrumentalists with singers, because it's one of the many areas where I think vocalists kind of kick instrumentalists' asses (ironically, the players who are guilty of the above sins are often in the camp of those who believe that nasty rumour that singers are stupid). A singer's instrument is finicky, too. Phlegm, saliva, uncomfortable clothes; these are the equivalents of dry reeds and spit valves. Most singers learn, more quickly than most instrumentalists, to deal with these surprises in a way that doesn't take them, or their listeners, out of the musical experience.

The difference in onstage decorum is much more noticeable when singers and instrumentalists work together (which happens a lot). One of the most difficult thing for a singer to do is stand onstage and look like a comfortable, normal person, while they're *not* singing. I find it hugely frustrating when instrumentalists don't offer the same respect and class to the singer. Maybe the viola has 20 bars of rest. But why would they spend it picking at their bow, shifting unnecessarily in their seat, or staring blankly off into space? In the case of vocal chamber music, young players often forget (or never realize) that the reason their line of music exists is because of *words*. Often *great words*. I'm not saying they should all look up the poetry of the piece they're playing (actually, I sort of am), but at the very least, they should have a listen to what's going on when they're not playing. 

In the case of full orchestras, I think players tend to forget that they're not invisible among the crowd. Orchestras aren't made up of thousands, and *I can see you*. There really is a subtle way to soak your reed, to empty excess saliva from your French horn; I realize that most players aren't consciously defiant of stage decorum, but it is about remembering that you're playing for an audience, and they're watching you (yes, you).

So, with sympathy for the often unattractive necessities of instruments, I implore young players to consider The Show when they're onstage. If you take a while to tune, that's alright; give yourself a head start backstage, and do a quick touch-up once you're under the spotlight. Keep your backup reeds within arms reach, so our eyes don't wander to the clarinetist in the back shuffling around on the floor. These are important parts of your playing, but they're not what the audience is interested in seeing. At the very least, sitting up straight and raising your eyebrows can go a long way.

It's important to remember that although you'd ideally want a perfect-height bench and eons of time to swab or apply rosin, sometimes you just won't get it. It's good for the young musician to be adaptable to imperfect conditions; perhaps with the exception of causing yourself physical damage, you'll be a better player for it.

Instrumentalists, am I being too hard on you? Let me know if I've missed the point in the comments below.
