+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-06-18T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Thomas Guthrie's production of _L'Orfeo_ runs [5 July](https://tickets.ncem.co.uk/en-GB/shows/monteverdi's%20l'orfeo/events) at YEMF, and [7 July](https://lso.co.uk/whats-on/icalrepeat.detail/2019/07/07/1665/-/i-fagiolini-music-theatre-for-all-l-orfeo.html) at LSO St. Luke's."
preamble = "On [5 July at the York Early Music Festival](https://tickets.ncem.co.uk/en-GB/shows/monteverdi's%20l'orfeo/events), and [7 July at LSO St. Luke's](https://lso.co.uk/whats-on/icalrepeat.detail/2019/07/07/1665/-/i-fagiolini-music-theatre-for-all-l-orfeo.html) in London, stage director Thomas Guthrie is set to open his very special production of Monteverdi's _L'Orfeo_. In a partnership with I Fagiolini and Music and Theatre for All, Guthrie's _L'Orfeo_ uses ancient Greek mask and puppetry techniques.\n\nWe spoke with Guthrie about his fusion of opera and puppetry, and the special storytelling power that puppets have."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1560900169/media/2019/06/sqThomasGuthrie-TheresaPewal.jpg"
primary_image_credit = "Photo: Theresa Pewal."
related_articles = ["articles/tarrare-the-freak-i-just-want-to-be-full.md"]
related_companies = []
related_people = []
short_description = "\"The biggest thing is believing yourself that the character is real, is alive. Then it draws on your own experiences, your own emotions, in order to communicate.\""
slug = "thomas-guthrie-on-puppetry-and-opera-its-really-magical"
title = "Thomas Guthrie on puppetry and opera: \"It's really magical.\""
youtube_url = ""

+++
## Why do you find puppets to be a powerful tool for opera? How do you pair puppetry with the importance of the human voice?

Puppets are powerful tools for storytelling, simply because they inspire our imaginations. If they don't, they can't work. They engage us, as an audience, even though we know they aren't real, because when they are moved in a certain way, we can start to believe they are. Then we draw on our own imaginations to engage in the character, and the story being told. 

In this way I think they are actually the essence of all good theatre, and are effective anywhere where storytelling is happening.

>"This isn't always easy, but it is always interesting!"

But there is something about the way they work - the way they inspire our imagination - that means they go particularly well with music! The moment when we start to believe in a puppet is a moment that our ears - as well as our eyes - open. We hear the music in a different way, with more awareness, and with a sense that the story and the music become one. 

Puppetry has always been associated - and performed - with music. As the Swedish director Michael Meschke, a pioneer in puppetry towards the middle and end of the 20th century, put it, "at the point at which actor and puppet both serve as instruments of the storytelling, it becomes less and less relevant to distinguish them: music and character are born together and the music is never a mere illustration of the action".

So (in theory!) they should be particularly effective in opera. And what is crucial to me is that it is the singer - the originator in the moment of the thought and its articulation - who has to be the main puppeteer. Which is to say they have to work the head. This isn't always easy, but it is always interesting! And it's the only way to guarantee that the audience can really start to believe and engage with the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560902166/media/2019/06/ThomasGuthrie6TheresaPewal-1.jpg){{% /md %}}

<figcaption>Thomas Guthrie, stage director. Photo: Theresa Pewal.</figcaption>

</figure>

## What do you think Monteverdi's _L'Orfeo_ says about men, women, and love? How will your mask and puppetry techniques tell this story?

I think the myth of Orpheus going to the underworld to find his wife - to bring the love of his life back to the land of the living - because he cannot accept that she has really gone - deals with how we all deal with grief, loss, depression, love and relationships. All myths do this - they tell a story on the outside that is a reflection of the life we all share on the inside. They make characters out of our feelings. 

>"It's very simple, but so touching, and has some of the best music in the whole opera."

For instance, in _L'Orfeo_, there is a character called Hope, and at the darkest, most scary moment, Hope has to leave. Our masks and puppets work in this context because in a way they are universal. Everyone makes of them what they want. They project their own feelings - their own character - on them. 

In this way the myth can really start to work its power on us, because we are taken inside ourselves, where the story can unfold as I think it's meant to. 

I love the scene with Pluto and Proserpina. Proserpina was thought of as the goddess of marriage - though she was originally (like Eurydice) a mortal, snatched by the god of the underworld (Pluto - death) from a field (again, just like Eurydice). Feeling that Pluto might have taken a shine to this young new mortal, Eurydice, (they have been married a very long time, after all), she suggests that she might herself have her eye on Orfeo. She stirs her husband's jealousy a little bit, while flattering him. So he agrees to let them both leave, and immediately takes his wife to bed! Great relationship therapy!

It's very simple, but so touching, and has some of the best music in the whole opera. Lessons in long term relationships, definitely.

## What have you observed in your collaborative work with singers and puppeteers? What do you think they have learned about each other's discipline?

It's one of the things I am loving most about working with puppets - and our wonderful puppeteers. Working with a puppet teaches us how to build, sustain and animate a character in real time. You can't let them die for a moment (unless of course the character is itself dying - in which case they die brilliantly! You just walk away). 

>"We want to facilitate that connection with everybody in the room, whoever they are."

They bring a focus out of us which we can take into other work. The puppeteer has to serve the puppet - to believe the puppet is alive and then respond to its needs. Just as in straightforward acting, if we can do it, the actor has to serve the character. 

The biggest thing is believing yourself that the character is real, is alive. Then it draws on your own experiences, your own emotions, in order to communicate. It's like myth - and what's happening with the audience - in reverse. Everyone is projecting onto the puppet - the character - and drawing on their own imaginations to make the illusion happen. It's really magical.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1560902146/media/2019/06/ThomasGuthrie3TheresaPewal.jpg){{% /md %}}

<figcaption>Thomas Guthrie, stage director. Photo: Theresa Pewal.</figcaption>

</figure>

## What do you hope audiences will take away from your production of _L'Orfeo_?

We want audiences to take the story and the music in as fresh and affecting a way as we can tell it/play it/sing it, and they can take it. We want to facilitate that connection with everybody in the room, whoever they are - never get in the way of it, but charm people into feeling and experiencing it. 

We hope they will feel the power of this universal human myth through Monteverdi's beautiful music in their innermost beings, and be changed by it. I think that's no less than our job, as makers of opera and theatre, at all times. It doesn't always work, but that’s what I hope we're all trying to do.