+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-10-17T13:55:00-04:00"
lastmod = "2017-09-13T21:19:00-04:00"
preamble = "I really, really like playing auditions. I have a short attention span and I like the rush of collaborating with a new singer under pressure, so playing a day of auditions is a little bit of Christmas for me. Unmarked cadenzas? Love them. Unexpected rubato? I'm on it.\n\nOn top of the fun of singer-pianist telepathy, I've gotten pretty good at the game of guessing which are the auditioners will ask for. In most auditions, opera singers present a list of about 4-6 arias; they choose which they want to start with, and after that the panel selects a second choice. The goal is for the singer to start with something they do very, very well, and for the auditioners to learn as much about that singer as possible in a two-aria span.\n\nAuditioners decide on a second aria based on a few factors: what a singer chooses as their starter, their voice type, age, the contents of their repertoire list. Singers learn what they can about this system, and strategize with their arias, to make sure that they present themselves at their best, and at their most hirable.\n\nBased on the auditions to which I've been privy over the years, here's a little look at the thought process behind your starting aria, what they'll ask for next, and how to make the audition psychology work *for* you."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505351937496/2017-09-14---Couch.jpg.jpg"
publishDate = "2015-10-24T08:00:00-04:00"
related_articles = ["articles/wolf-trap-audition-conversation.md","articles/what-to-wear-to-an-audition-via-the-red-carpet.md","articles/5-tips-for-university-auditionees.md","articles/audition-arias-101-the-young-singers-guide.md","articles/one-more-reason-we-dont-envy-singers.md","articles/4-myths-from-music-school.md","articles/i-didnt-get-in-a-short-story-about-clarity.md"]
short_description = "On top of the fun of singer-pianist telepathy, I&#039;ve gotten pretty good at the game of guessing which are the auditioners will ask for. In most auditions, opera singers present a list of about 4-6 arias; they choose which they want to start with, and after that the panel selects a second choice. The goal is for the singer to start with something they do very, very well, and for the auditioners to learn as much about that singer as possible in a two-aria span."
slug = "psychology-audition"
title = "The psychology of an audition"
+++

## If you start with something 20th-century or newer, especially in English...

Times are changing, and arias from more contemporary operas are being heard more regularly in the audition circuit. Britten is a great choice, and arias by Samuel Barber, John Corigliano, Jake Heggie, and Carlisle Floyd are becoming common additions to a rep list. In general, starting with contemporary and/or English means you're confident that you sing the aria *really* well, and you want to make sure the audition panel hears it. 

If you're under 30, be prepared to sing any Mozart or Handel you offer, since the audition panel may need well-known rep to make sense of what they've heard in your (perhaps lesser-known) contemporary aria. Standard rep helps them get practical about how they could use you in one of their seasons. 

In the same vein, if you're over 30, auditioners will ask for whatever is closest on your rep list fo *bel canto*. Again, they want to hear your voice in something *they* know well, so they can connect any dots between you and their casting needs.

## If you start with something *bel canto*...

This can mean anything from Rossini to Donizetti to Bellini to Verdi (more on that below), to any others (most likely Italian) writing in the same sound world. If you're starting with Rossini, comic-opera Donizetti, and some Bellini, the panel will likely ask for your Mozart or Handel as a second aria. If it's a slow cavatina, the earlier stuff will show the auditioners that you have precision and rhythm; if it's full of coloratura, Mozart will let them hear more of your sustained voice. If you're a coloratura soprano, you might get asked for German Mozart, or maybe some Richard Strauss. If you're over 35, I'd ask to hear your Verdi second.

## If you start with Verdi...

If you're under 30-ish and there's Mozart on your list, they'll probably ask for that next. If you're over 30-ish and you're a woman who offers Strauss, that would be a probable pick. If you're a tenor, they'd go for Puccini or maybe Don José (*Carmen*). For a baritone or bass, they might go for French or German, unless you're offering Mozart. Then, Mozart.

## If you start with something French...

French repertoire can be a little bit all over the place in terms of style, so Italian standard rep will give context to what a singer does with French.

If you're under 30 and offer Mozart, that's the likely second choice. Coloratura sopranos and coloratura mezzos might be asked for *bel canto* or Handel, or in some cases, Strauss. For men over 30, Verdi might be a next pick, unless you offer any substantial German; in that case, I'd be interested to hear it. For lyric tenors, Verdi or Puccini would be my second picks.

## If you start with Wagner or Strauss...

Coloratura sopranos in this category are likely singing something from *Der Rosenkavalier* or *Ariadne auf Naxos*, and depending on their age, they'd probably be asked for Handel (younger), *bel canto* (older), or Mozart (both).

If you're under 30, *not* a coloratura soprano, and not a freak voice, you'll be asked for Mozart because you probably shouldn't offer that Wagner aria you found in your anthology... Women who start with Wagner usually have some Puccini and Verdi in their package, and if you're a mezzo you'll probably sing some more German or big old French. 

If you're a tenor, you're either on an all-German track, and Strauss will follow Wagner, or vice versa. If you're more on the lyric side, they'll ask for French or Italian to hear more of your voice. Low-voiced men might be asked for Russian, Verdi, or more German.

## If you start with Mozart...

Taking the bull by the horns, I see. For a lot of singers, younger voices in particular, starting with Mozart shows that you're a) not afraid to sing it, and b) you're presenting yourself in a realistic, present-day way for a panel. The panel's choice after Mozart is often an attempt to hear a more extreme version of whatever you presented first. If you're a coloratura soprano and you sing "Durch Zärtlichkeit" (*Die Entführung aus dem Serail*), they'd want to hear your coloratura in something more *bel canto* or Handelian. 

If you offer something like the Countess or Donna Anna, some Verdi or Strauss might be next, so the auditioners can hear just how lyric a soprano you are. For mezzos, you're likely offering a trouser role (Cherubino, Sesto), so I'd ask for something *bel canto*, or maybe some French (Stefano, Nicklausse) if the voice feels more substantial.

For tenors, it can actually be a bit of a crapshoot. If you sing something like Belmonte or Ottavio, I'd be curious to hear something more *bel canto* in style. If you're offering Tamino or Tito, a surprisingly common second choice is Lensky's aria (*Eugene Onegin*). actually. Depending on what you offer, they may go for some light Verdi or maybe Donizetti.

For low-voiced men, it's an age game. If you're under 30 and you offer the Count or Figaro, it'll be a split between Handel and whatever's closest to *bel canto* on your list. Over-30 Leporellos and Don Giovannis should be ready to sing some French, and I personally would be curious to hear some Verdi. 

>Now, the whole point of this topic is that, at the end of the day, it's arbitrary. Let us know your audition experience, or your thoughts on the above, in the comment section below!
