+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-04-10T22:31:00-04:00"
lastmod = "2015-04-10T22:31:00-04:00"
preamble = "<p>\n\tMusicians come in many kinds, and most work with a fascinating balance of pragmatism and imagination. We, like other artists, get a reputation for having our heads in the clouds, for making decisions based on emotion instead of reason. We are artsy-fartsy. I know as well as any other musician that we also have stunning moments of reason and logic (think: memorizing music). I tend to favour logic in my everyday life, but during a recent practice session, it occurred to me that there are major logical fallacies that musicians commit every single day. Bear with me:\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549337402/media/2019/02/sqLogic.jpg"
primary_image_credit = ""
publishDate = "2015-03-14T10:31:00-04:00"
related_articles = ["articles/4-ways-that-opera-really-is-life.md"]
short_description = "Musicians come in many kinds, and most work with a fascinating balance of pragmatism and imagination. We, like other artists, get a reputation for having our heads in the clouds, for making decisions based on emotion instead of reason. We are artsy-fartsy. "
slug = "proof-that-music-is-simply-unreasonable"
title = "Proof that Music is Simply Unreasonable"

+++
<h2>Appealing to Authority and Tradition</h2>
<p>
	<a href="http://en.wikipedia.org/wiki/Argument_from_authority" target="_blank" data-mce-href="http://en.wikipedia.org/wiki/Argument_from_authority">Appealing to authority</a> means that you believe something is true because of the authority of the person asserting it. Anyone who owns books like Pierre Bernac's <em>The Interpretation of French Song</em>, or the Ricci <em>Variations, Cadenzas and Traditions for Singing,</em> knows what I mean. Singers read Bernac for their French rep, the <em>Fischer-Dieskau Book of Lieder</em> for their German, and consult Ricci for ornaments and cadenzas in Italian opera. If it's not authority, it's <a href="http://en.wikipedia.org/wiki/Appeal_to_tradition" target="_blank" data-mce-href="http://en.wikipedia.org/wiki/Appeal_to_tradition">Tradition</a>, meaning that because singers have <em>always</em> sung a <em>subito pianissimo</em> on that note, it must be the right thing to do. It's not necessarily that singers can't imagine any of these things for themselves, but it's true that they could get criticized (and perhaps not re-hired) if they don't appeal to biggies like Bernac and Ricci and the Historically Informed Performance scene. Interestingly, people like Ricci and Bernac have become seen as authorities because of the <a href="http://en.wikipedia.org/wiki/Appeal_to_tradition" target="_blank" data-mce-href="http://en.wikipedia.org/wiki/Appeal_to_tradition">Appeal to Tradition</a> logical fallacy.
</p>
<h2>Appealing to Popularity</h2>
<p>
	"You have to do that portamento! Everyone does that portamento!" says the hypothetical voice teacher with a specific recording in his head. Appealing to popularity just means that you're arguing something is true because a lot of people think it's true. Or, in the musician's case: because lots of people sing it that way, it must be the <em>right</em> way. I do this, teachers do this, singers do this. Sometimes a method is popular because it's an explicit demand (i.e., a portamento is written into the score by the composer); in that case, the fact that it's popular is irrelevant. Sometimes, it's just because everyone loved them a Callas portamento (myself included!). It doesn't mean that portamento shouldn't be there, but "because so many people do it" is a terrible reason to do anything.
</p>
<h2>Confirmation Bias and Arguments from Ignorance</h2>
<p>
	Opera directors, coaches, conductors, singers, really anyone whose job it is to interpret music, can be easily accused of <a href="http://en.wikipedia.org/wiki/Confirmation_bias" target="_blank" data-mce-href="http://en.wikipedia.org/wiki/Confirmation_bias">confirmation bias</a>. This means that you start with a hypothesis, and then interpret the information in front of you to support said existing hypothesis. It's not a reasonable way to look at information, since it usually suggests that you want to prove your own hunch, rather than find the true answer to your question. As a coach myself, I can attest to how easy it is to find different facets of a character written into the music. Confirmation bias in opera, you could argue, is the vehicle behind many directors' choices in boundary-pushing, that's-a-stretch-type productions. This kind of thing reminds me of the <a href="http://en.wikipedia.org/wiki/Argument_from_ignorance" target="_blank" data-mce-href="http://en.wikipedia.org/wiki/Argument_from_ignorance">Argument from Ignorance</a>, which would go something like, "well, Da Ponte never says that Donna Elvira <em>isn't</em> married to Don Giovanni."
</p>
<h2>The Historian's Fallacy</h2>
<p>
	This one is tricky. Take a piece of music that is centuries old, old enough to come from another time and place, where society worked in an arguably different way. The fallacy comes when we look at this old music anachronistically, assuming that the composer, librettist, singers, even the characters themselves, behaved and thought the way we do today. This is a really interesting one, because it largely concerns intent, both musical and dramatic. On the musical side, we often make assumptions about what a composer "meant", like whether or not the Vienna ending of <em>Don Giovanni</em> is tongue-in-cheek. Dramatically, a character like Lucia di Lammermoor is pretty weak and subordinate by today's standards, but a good director knows that Donizetti's opera is a product of the year 1835. Trickier still are characters like Figaro in <em>Il barbiere di Siviglia</em> and Susanna in <em>Le nozze di Figaro</em>; they're firecrackers, sure, but still the help. It's a tricky line to toe without really being able to understand the 18th century class system, and, frankly, Beaumarchais. The risk of anachronistic characterization is high, but it's simply a necessary part of the job.
</p>
<p>
	I know, I know, I've sucked all the fun out of music and its subjectivity. I'm not saying music or musicians <em>should</em> adhere to the rules of logic and reason when they make their decisions. In the above cases, there really is no better way of discerning what a composer intended, and there are arguments to be made for stylistic choices that are separate from "it's in the Ricci book", or "Joan Sutherland did it". I just think it's fascinating that music, as part of the huge world of The Arts, is so ubiquitous <em>and</em> so illogical. I'm a logic lover myself; I find it handy in the real world, outside the rehearsal room. As much as I often want to bring it to work, too, sticking to my reasonable guns would decimate the opportunities for creativity. I hope you all find it amusing as I, though, that there's actually some definitive proof that musicians are, at least a little bit, artsy-fartsy?
</p>