+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2019-09-03T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1567791117/media/2019/09/sqradamisto_2019-20_06_te9j94.jpg"
primary_image_credit = "Kihwan Sim (Tiridate) and Jenny Carlstedt (Polissena) in Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller."
related_articles = ["articles/a-visceral-nightmarish-tourdeforce-der-mieter.md", "articles/an-absolute-triumph-koskys-carmen.md", "articles/a-prodigy-grows-into-his-art.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = []
short_description = "Then the production succumbs to another tired trope in an attempt to solve the problem of too little too late. Tiridate slits everyone's throat in the midst of their celebratory epilogue as if to ask: is it still opera if no one dies?"
slug = "projecting-on-opera-oper-frankfurts-radamisto-in-revival"
title = "Projecting on opera: Oper Frankfurt's Radamisto in revival"
youtube_url = ""

+++
Revivals bring unique challenges. Rehearsal periods are nerve-rackingly short, the original director is rarely involved, the production itself must remain relevant despite being displaced from its original context, and no revisions are allowed. If only directors could (and would) refine their productions each time they were mounted anew – if only opera companies had the budget for that – the at form would gain vitality.

Oper Frankfurt's current revival of Handel's _Radamisto_ (directed by Tilmann Köhler) premiered in 2016. A lot has changed since then and a lot of art has become dated in the meantime. How relevant this production was when it premiered, though, is hard to tell.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567790891/media/2019/09/radamisto_2019-20-1_afxv0j.jpg){{% /md %}}

<figcaption>The ensemble of Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

As for the opera's plot, once you get the characters straight, _Radamisto_'s is easy enough to follow. The King of Armenia (Tiridate) no longer cares for his wife (Polissena, Prince Radamisto's sister) so he starts a war to win a noblewoman (Zenobia, Radamisto's wife) and her father's land.

> When will opera's projection fetish end?

The production sets the action on an oversized staircase made of attractive cedar-hewed wood, like designer gym bleachers at a school for giants. It's a blank-ish canvas without much symbolic value. Modern war zones and refugee tent-cities are distortedly projected on the stairs gesturing vaguely toward recent world conflicts. Any connection between the projections and what actually happens on stage is tenuous. When will opera's projection fetish end? It's one of the medium's more embarrassing trends. Low quality, distracting images and hokey acting are the norm. Unless what's on screen is truly compelling and fully integrated into the story telling, it fails.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567790918/media/2019/09/radamisto_2019-20_02_e6tnby.jpg){{% /md %}}

<figcaption>Zanda Švēde (Zenobia) and Dmitry Egorov (Radamisto) in Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption></figcaption>

</figure>

Though the production avoids nuanced storytelling, it's redeemed by Handel's extraordinary score and a solid cast of voices that includes Zanda Švēda's lacquered, rippling mezzo-soprano (Zenobia), Kihwan Sim's elegant bass (Tiridate), and Vince Yi's (Fraarte) crisp countertenor. Jenny Carlstedt (Polissena, Radamisto's sister) and countertenor Dmitry Egorov (Radamisto) were noble in stature and convincing as siblings. Kateryna Kasper (Tigrane) was energetic and wily. Božidar Smiljanić (Farasmane) had a rich timbre, though his only aria was cut leaving him little to sing.

> He brought the theater to a crystallized standstill.

Pure vocal prowess, however, doesn't guarantee high drama. Throughout the evening, the musical and dramatic delivery was lukewarm, never heating to a simmer. The cast seemed tentative, still feeling their way into the outsized characters, events, and relationships.

Mr. Sim has an innately good-natured presence that he'll need to selectively relinquish to portray evil convincingly. Threatening slow walks and a roughened vocal texture during rage arias isn't enough.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567790987/media/2019/09/radamisto_2019-20_03_fpzfn9.jpg){{% /md %}}

<figcaption>Dmitry Egorov (Radamisto; dressed in black with water bottle) and Ensemble in Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption></figcaption>

</figure>

As the title character, Mr. Egorov's vocalism was inconsistent with moments of questionable intonation. His firecracker showpieces ran at such blazing tempi that, though his coloratura remained clear phrase to phrase, the breakneck pace cost him expressive variety and crippled the orchestra's clarity (conducted by Simone Di Felice). Speed is only thrilling if accompanied by precision, texture, and groove.

> In a world where everything is sung, the lyric voice, given the right phrase, can redeem even the most despicable men.

Egorov's mesmerizing moments were during his arias' cadenzas. He brought the theater to a crystallized standstill with a voluminous suspended straight-tone, like microphone feedback but pleasing, that demonstrated the purity and force of his instrument. Though he repeated the effect a few times throughout the evening, it remained astonishing.

Like many of the era's operas, Radamisto abruptly shifts at the end so the good guys win. The villain Tiridate has a near instant change of heart when he discovers that, while chasing his love interest, he's lost control of the war he started and his own army has betrayed him. His plea for forgiveness predicts the Count's in _Le nozze di Figaro_ ("Contessa, perdono") and provides a brief opportunity for operatic transcendence. In a world where everything is sung, the lyric voice, given the right phrase, can redeem even the most despicable men.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567791027/media/2019/09/radamisto_2019-20_04_u0f2y7.jpg){{% /md %}}

<figcaption>Zanda Švēde (Zenobia) and in the background Dmitry Egorov (Radamisto) in Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption></figcaption>

</figure>

Then the production succumbs to another tired trope in an attempt to solve the problem of too little too late. Tiridate slits everyone's throat in the midst of their celebratory epilogue as if to ask: is it still opera if no one dies?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567791063/media/2019/09/radamisto_2019-20_05_tnkwcz.jpg)

{{% /md %}}

<figcaption>Kateryna Kasper (Tigrane) and Dmitry Egorov (Radamisto) in Radamisto, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption></figcaption>

</figure>