+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-05-12T17:27:00-04:00"
lastmod = "2018-05-15T12:11:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526160248240/sq2018BLO-TAHITI-l-r-NFerreira-HJohnson-MBonde-VTurregano_sm.jpg.jpg"
primary_image_credit = "(l-r) Neal Ferreira, Heather Johnson (Dinah), Mara Bonde, and Vincent Turregano in Trouble in Tahiti, Boston Lyric Opera, 2018. Photo: Liza Voll."
publishDate = "2018-05-13T19:32:00-04:00"
related_companies = ["scene/companies/boston-lyric-opera.md"]
short_description = "As it turns out: with some very intelligent staging and committed performances from the cast, the tale of Sam and Dinah&#039;s dysfunctional marriage became the perfect backdrop for Arias. Thus, it became the kind of thought-provoking evening that I think Bernstein always strived for but never seemed to get through his music."
slug = "profound-moving-bernstein-double-bill"
title = "Profound, moving Bernstein double-bill"

+++
I have never particularly liked a lot of Leonard Bernstein's concert music. For me, many of Bernstein's more serious works are marred by a sense that he is trying too hard to be serious and profound, and this quality of his music only seems to grow stronger the later into his output one dives. Thus, when the Boston Lyric Opera opted to pair [*Trouble in Tahiti* with the *Arias and Barcarolles*](https://blo.org/tahiti/?hsCtaTracking=7d1ec0b4-6415-4b37-8209-06d5d9b0fcb3%7C933d4a83-99ff-44a2-8a81-abe2356e440b), I was admittedly rather apprehensive: I like *Trouble in Tahiti* given that it doesn't take itself too seriously, but the *Arias and Barcarolles* comes from Bernstein's extremely late period where his pretensions got the better of his music. What would pairing *Trouble in Tahiti* with *Arias* do for the evening?

As it turns out: with some very intelligent staging and committed performances from the cast, the tale of Sam and Dinah's dysfunctional marriage became the perfect backdrop for *Arias*. Thus, it became the kind of thought-provoking evening that I think Bernstein always strived for but never seemed to get through his music.

The brilliance, of course, mostly stems from the conceit of the production design: this double-bill of *Trouble in Tahiti* with *Arias and Barcarolles* was staged in an installation set up at the DCR Steriti Memoral Rink in the North End: within the area that the ice would normally be placed, BLO erected a full 1950s-style nightclub, complete with sangria and little bar bites. (Full disclosure: I did indulge in one glass of sangria before the show.) The space was absolutely beautiful, and it leant a quietly intimate air to the whole night. However, what it also did was eliminate the use of sets and props: this permitted the staging to get inventive throughout *Trouble in Tahiti*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526160368904/2018BLO-TAHITI-HeatherJohnson_sm.jpg.jpg)
<figcaption>Heather Johnson (Dinah) in *Trouble in Tahiti*, Boston Lyric Opera, 2018. Photo: Liza Voll.</figcaption>
</figure>

Stage director David Schweizer added plenty of little subtle touches, which were all the more effective for being unfettered by the need for props. For instance, during Dinah's therapy session part of the way through *Trouble*, he placed one of the members of the doo-op trio into the audience, standing under spotlights as Dinah described the dream and the apparition that called to her throughout it: she sang to him, then, and almost made to grasp at her. This is clever staging, but the real brilliance is that he takes the staging of the therapist scene in *Trouble* and then transmutes it to Little Smary in *Arias*, an aria about loss. The key difference, however, is that Schweizer keeps the entire trio onstage, so that when "Dinah" looks for the trio member within the audience as she did in *Trouble*, there's nobody in the audience to answer her visually. The impact of that one little change was incredibly profound, and it made quite the statement that I don't know that either *Trouble* or *Arias* could have made on their own.

These little staging transmutations permeated the evening, and they were all incredibly brilliant touches that highlighted thematic connections without it feeling like *Trouble* was imposing thematic significance on *Arias*. What was an argument over breakfast in *Trouble* found a striking thematic parallel in "Love Duet", where the meta-textual commentary on the state of music in the late 80s became a metaphor for Sam and Dinah's inability to really talk about their problems throughout *Trouble*. "The Love of My Life" revealed Sam's extreme egotism for the over-masculine toxicity that it was almost soley through having "Sam" going through the same motions throughout "Love of my Life" that he did in the office and gym scenes of *Trouble*. "Mr. and Mrs. Webb Say Goodnight" capped off the evening and stood in stark contrast to the conclusion of *Trouble*, where Sam and Dinah avoid talking about their marital troubles to see the titular movie: Mr. and Mrs. Webb ended the evening on a more hopeful note, implying that perhaps there was room for Sam and Dinah to meaningfully discuss their marital problems after all.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526160382291/2018BLO-TAHITI-HeatherJohnson-MarcusDeLoach_sm.jpg.jpg)
<figcaption>Heather Johnson (Dinah) and Marcus DeLoach (Sam) in *Trouble in Tahiti*, Boston Lyric Opera, 2018. Photo: Liza Voll.</figcaption>
</figure>

The result was two-fold. First, it electrified *Arias and Barcaroles*, even in the parts in which there was no clear parallel with *Trouble*. Oif Mayn Khas'neh, for instance, became more than just a surreal scene: it became a dark premonition of the difficult marriage Sam and Dinah try to sort through in *Trouble*. It also shone new meaning on "Greeting", which clearly addresses the Junior character in this context. Additionally, it served to add layers of complexity to *Trouble in Tahiti*, and in doing so placed the onus not on the extreme materialism of post-WWII American society but on the insecurities of the characters.

In short, this staging of these works deftly produced the more serious expansion on *Trouble in Tahiti* that Bernstein attempted — and notably failed to achieve — with *A Quiet Place*. The result was thrilling and dynamic, and it overrode my fears both that *Arias and Barcarolles* would come off as pretentious, and that *Trouble in Tahiti* would prove to be too disparate a work from *Arias* to provide a thematically cohesive evening. (It should be noted that BLO made a few alterations to *Arias* to give the Trio things to do during the work, and to make explicit references to "Sam and Dinah". The Bernstein Estate permitted these edits, and from where I stand, I am very glad they did.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526160396345/2018BLO-TAHITI-MarcusDeLoach-as-Sam_sm.jpg.jpg)
<figcaption>Marcus DeLoach (Sam) in *Trouble in Tahiti*, Boston Lyric Opera, 2018. Photo: Liza Voll.</figcaption>
</figure>

The singers were up to the task of realizing this ambitious pairing of the two works, and they shone equally in both. Mara Bonde, Neal Ferreira, and Vincent Turregano all made for a delightfully irreverent Trio, whose crystalline voices that effectively called back to the radio presenters Bernstein used as inspiration for the Trio. 

Marcus DeLoach also made for a proud, self-assured Sam, whose voice was as powerful as his overly macho mannerisms. However, he also managed to dial it back as the "Sam" in *Arias and Barcarolles*, as his voice revealed the characters' insecurities. 

But Heather Johnson easily stole the night as Dinah: her aria detailing the fictional movie from which *Trouble* takes its title was a riot, but she also managed to convey how the hyper-romantic nature of what is ultimately a silly musical swept her off her feet almost purely through vocal skill. She also brought a quiet, mellow voice to "Greeting", and in doing so provided one of the most moving moments of the whole night. They were also aptly supported by excellent playing from its chamber orchestra and its pianists Brett Hodgdon and David Angus: the accompaniment almost provided its own character to the performance, particularly Hodgdon with his performance of Bernstein tunes from other shows before the performance proper began.

If I had to find any fault with the production, it is that, unfortunately, the venue's acoustics are not really suited for opera singing. The singers were singing inside of a space that would typically be used for ice hockey games, which meant that they were singing to a very open space with very few points for sound to reflect back at the audience: as such, the singers very frequently got swallowed up by the space even despite everyone's best efforts to make sure they were heard. (Full disclosure: my seat was towards the back of the auditorium space, so those sitting closer to the stage might have a better experience there.) There were also unwanted intrusions of outside noise from time to time: the program book even mentioned this, going so far as to point out the exact times of day when the nearby USS Constitution would fire its cannons at sundown so as not to startle patrons.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526160424149/2018BLO-TAHITI-The-Cast-of-Trouble-in-Tahiti-2_sm.jpg.jpg)
<figcaption>The cast of *Trouble in Tahiti*/*Arias and Barcarolles*, Boston Lyric Opera, 2018. Photo: Liza Voll.</figcaption>
</figure>

Still, it did not take away from the power of this most interesting of pairings. The Bernstein estate would be smart to encourage more opera companies to present these two works together, as the combination actually works exceedingly well on a thematic level. At long last, here we have an evening of Bernstein's more serious concert music that lives up to the ambitions Lenny always had for that part of his output, and the result should not be missed.

>Boston Lyric Opera's production of *Trouble in Tahiti*/*Arias and Barcarolles* is onstage through May 20. For details and tickets, [click here.](https://blo.org/tahiti/)