+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2022-10-23T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Enigma Chamber Opera's production of _Prodigal Son_ is [available to stream](https://www.eventbrite.com/e/enigma-chamber-opera-presents-benjamin-brittens-the-prodigal-son-tickets-428822960017) through November 4, 2022."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1666563829/media/2022/10/sqEnigma_Matthew_DiBattista_in_Enigma_Chamber_Opera_s_PRODIGAL_SON_Photo_by_Ashlee_Rose_Scott_ml8lq3.jpg"
primary_image_credit = "Matthew DiBattista in Enigma Chamber Opera’s PRODIGAL SON. Photo by Ashlee Rose Scott."
related_articles = ["articles/catharsis-is-the-wrong-word-brittens-war-requiem.md", "articles/enigma-opera-s-curlew-river-a-transcendent-experience.md"]
related_companies = []
related_people = []
short_description = "The attention to detail in the characterizations extended to everyone else afterwards, as well. Matthew DiBattista brought a certain hesitancy to the Younger Son that made him endearing, even when he sang more confidently."
slug = "show-stealers-in-enigma-chamber-operas-prodigal-son"
title = "Show stealers in Enigma Chamber Opera's Prodigal Son"
youtube_url = ""

+++
In last year’s opera season, I had the chance to review [Enigma Chamber Opera](https://enigmachamberopera.org/)'s luminous production of Benjamin Britten’s [_Curlew River_](/enigma-operas-curlew-river-a-transcendent-experience/), a production that still lives on in my mind an entire year later. It is perhaps fortunate, then, that Enigma Chamber Opera has decided to dedicate its next offerings on producing the other two church operas in Britten's arsenal, and they have elected to start with [_Prodigal Son_](https://www.eventbrite.com/e/enigma-chamber-opera-presents-benjamin-brittens-the-prodigal-son-tickets-428822960017). It is always risky to go on a series in the same venue that uses a surprisingly similar staging conceit of performers using found objects as props in a church; unless the works are sufficiently different from each other, you are going to inevitably draw comparisons between all three.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666563933/media/2022/10/Enigma_The_cast_of_Enigma_Chamber_Opera_s_PRODIGAL_SON_Photo_by_Ashlee_Rose_Scott_icjcfr.jpg){{% /md %}}

<figcaption>The cast of Engima Chamber Opera's Prodigal Son, 2022. Photo by Ashlee Rose Scott.</figcaption>  
</figure>

But what helps is that _Prodigal Son_ is a very different creature from _Curlew River_; whereas _Curlew River_ is all about nailing a single moment in the climax, _Prodigal Son_ is about sustaining much more interest throughout the opera's entire runtime. Dramatically, I found it much more interesting across the whole than I did _Curlew River_: it is a combination of how the characters are developed across the runtime, how the pacing functions, and how the various musical gestures in its sound world come together, but I found _Prodigal Son_ to be more engaging across the whole. You are also talking a very different class of story, and at the very least this was reflected in the aesthetics of the production: whereas _Curlew River_'s aesthetic was much more run-down with its broken umbrellas and tattered clothes, _Prodigal Son_ was able to make do with clean rustic flannel, sports watches, and projections of middle-American farm life on the walls.

But more than any of these things was the conceit at the heart of Enigma Chamber Opera's production, and this is something that I think is much easier to demonstrate with _Prodigal Son_ than with _Curlew River_: this production also sought to produce some distance with the liturgical origins of the story, and see what lessons the parable can tell without the religious overtones. This conceit might sound sacrilegious to everyone who has heard the parable, but to my mind it makes a certain amount of sense considering the speculation that Britten was agnostic for at least part of his life. I also do think that, as a parable, examining any adaptations of the _Prodigal Son_ story is actually truer to the spirit of how a parable functions than anything else.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666563952/media/2022/10/Enigma_David_McFerrin_center_in_vest_in_Enigma_Chamber_Opera_s_PRODIGAL_SON_Photo_by_Ashlee_Rose_Scott_qbunn7.jpg){{% /md %}}

<figcaption>David McFerrin (front, in vest) in Engima Chamber Opera's Prodigal Son, 2022. Photo by Ashlee Rose Scott.</figcaption>  
</figure>

And indeed, they did somewhat manage to find their way. For one thing, the attention to characterization is stronger in _Prodigal Son_'s libretto, and it felt much easier for the production team to structure the story according to the characterizations they were given. They also chose to focus as much as they could on the father's unconditional love of his youngest son, something that actually did come across quite well even if he was absent in the entire middle third. The production made sure to keep him centered in all parts where he was onstage, but most of all it allowed Aaron Engebreth's performance to shine through: there were certainly times where the chamber ensemble overpowered his singing slightly, but he was always warm, both in how he acted the part with the right amount of resignation and love and in how he sang it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666563973/media/2022/10/Enigma_ProdigalSon2_q9dnqv.jpg){{% /md %}}

<figcaption>Matthew DiBattista (left) and Omar Najmi in Engima Chamber Opera's Prodigal Son, 2022. Photo by Ashlee Rose Scott.</figcaption>  
</figure>

The attention to detail in the characterizations extended to everyone else afterwards, as well. Matthew DiBattista brought a certain hesitancy to the Younger Son that made him endearing, even when he sang more confidently. David McFerrin imbued the Elder Son with just the right amount of rage, barking a few of his lines and acting the hell out of the part. But for my money, the one who stole the show was Omar Najmi as the tempter and the eventual abbot: Najmi was clearly having a ton of fun as the voice of the younger son’s temptation, with the way his vocal lines lilted playfully, and it was an absolute joy to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666564026/media/2022/10/Enigma_ProdigalSon1_uvweif.jpg){{% /md %}}

<figcaption>(front, l-r) Omar Najmi and Matthew DiBattista in Engima Chamber Opera's Prodigal Son, 2022. Photo by Ashlee Rose Scott.</figcaption>  
</figure>

Overall, the individual performances grabbed me much more strongly in _Prodigal Son_, and this filtered into everything else in the production. Of course, with the way Britten opens and closes the show with Latin chanting, I don’t think they were ever going to fully get away from the religious themes at the core of the show, but I think they mostly managed to get it across because they accented what William Plomer's libretto already laid the groundwork for; the characterizations were incredibly strong, and it livened up a piece that certainly feels tricky to stage. I do not know if Enigma Chamber Opera hit the heights that they did with _Curlew River_, but I was still very pleased with the result in the end. Ultimately, it makes me excited to see what they do with _Burning Fiery Furnace_ next year, as they have announced they will do.