+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2016-05-06T10:04:00+01:00"
lastmod = "2016-05-06T11:14:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462528557238/2016-05-06---Surtitles.jpg.jpg"
publishDate = "2016-05-06T11:00:00+01:00"
related_articles = ["articles/michelle-telford.md","articles/are-printed-translations-screwing-up-recitals.md"]
short_description = "Sustained sound is different from regular speech, and there&#039;s a reason why composers take an opera libretto and divide it into recitatives, arias, ensembles, etc. This text is different than that text, and the music delivers this message loudly. But with those blasé slides popping up in the surtitle box, it&#039;s like the the titles themselves are bored, and contemptuous of any textual subtleties woven by a composer into their opera."
slug = "problems-we-didnt-know-we-had-surtitles"
title = "Problems we didn&#039;t know we had: surtitles"
+++

Over lunch the other day, a conductor brought up an interesting problem with the surtitle method in opera. Sure, surtitles are really great at helping an audience understand what the singers are saying in foreign languages (or English librettos by W.H. Auden), but they're pretty poor indicators of *how* the lines of text are delivered.

Think about it: you go hear a production of *Don Giovanni*, where you'll find speech-like *secco* recitative, lyrically sung arias, and dramatic *accompagnato* recitative that lies somewhere in between. Yet when the audience glances at the titles throughout all of these major musical shifts, the text pops up unceremoniously, with the same blunt pacing, as if to say, "read this sentence quickly so you can get back to the show."

It's a bit like that adage about how Shakespeare should be read aloud, never simply read; with great pieces of poetry (and it's fair to include opera libretti in the poetry category), the written words are only part of the puzzle. An opera libretto is quite sparse, bland, even, when it's read on its own, separated from any musical setting. It's not necessarily that a libretto is an incomplete document without a composer's touch, but it's written to be sung, not just spoken.

Sung, meaning sustained. Sustained sound is different from regular speech, and there's a reason why composers take an opera libretto and divide it into recitatives, arias, ensembles, etc. This text is different than that text, and the music delivers this message loudly. But with those blasé slides popping up in the surtitle box, it's like the the titles themselves are bored, and contemptuous of any textual subtleties woven by a composer into their opera.

It's not just "They call me Mimì, and I don't know why," it's "They call me...\**swell of music as Lucia thinks of all the neat people who have ever nicknamed her Mimì, and how it has shaped her identity*\*...Mimì. AndIdunnowhy. \**giggle*\*"

So what does this mean for for the way surtitles display text? How can surtitles step up to the challenge of not only translating, but representing the words in an opera? A few solutions:

We could have a bam-bam-bam approach for *secco* recitatives, lines flying at that Mozart-comedy pace; and then when it's time for an aria, the titles could switch over to karaoke-style, a slowly bouncing ball hopping along each syllable, guiding the audience's eyes so they don't read the last word too soon.

Or, there could be a hilarious system of repeated vowels, proportionate to the length of time a singer holds a note. Something like, "No-o-on mi di-i-ir, bel i-i-i-dol mi-io," or "Ce-e-e-le-e-ste Aï-ï-ï-da-a-a-a..." How annoying/hilarious would that be?

Or even better, a rolling marquee style of displaying the titles, where the pacing adjusts to the tempo of the text. That would keep the audience on its toes, if not make them a teensy bit dizzy. And with Baroque, Classical, and *bel canto* opera, where there are one or two lines of text for every five minutes of singing, does that line get rolled out gracefully at the top of the show, then fade to black? Or would the rolling marquee be at a glacial pace, churning out the A-section text gradually over the first four pages of Handel's coloratura?

Important questions, these. We've seen operatic stutters represented in surtitles, so really, where's the line? And who wouldn't want to go hear a Rossini comedy with bouncing-karaoke-ball surtitles? Hilarity.
