+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2023-06-04T00:00:00+00:00"
lastmod = "2023-06-04T00:00:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1685916500/sqNAO_Borgia.jpg"
publishDate = "2023-06-04T00:00:00+00:00"
related_articles = ["articles/two-different-servings-from-the-opera-fest-menu.md"]
related_people = ["scene/people/eric-lindsey.md", "scene/people/toni-marie-palmertree.md", "scene/people/madison-marie-mcintosh.md"]
related_companies = ["scene/companies/new-amsterdam-opera.md"]
short_description = "New Amsterdam presents works in a concert-style, with performers at music stands, and the only staging is the exits and entrances of principals who are in each scene. This leaves them free to invest donors' dollars in the music and that certainly pays dividends to the audience."
slug = "pretty-poison-lucrezia-borgia-at-new-amsterdam-opera"
title = "Pretty poison: Lucrezia Borgia at New Amsterdam Opera"
+++
Some of Donizetti's most famous tragic operas have a lot in common - in some ways a formula: a big orchestra, a big chorus, act-ending sextets (or variations on that number) and, most importantly, multiple arias from a Donizetti diva in the title role. To check all these boxes, one need only think of _Lucrezia Borgia_.
 
[New Amsterdam Opera](https://www.newamsterdamopera.org/) continues its tradition of bringing infrequently produced operas to their audience, such as the seldom-seen _Herodiade_ by Massenet ([reviewed here](https://www.schmopera.com/two-different-servings-from-the-opera-fest-menu/)), and, in this case Donizetti's _Lucrezia Borgia_, which is much less known than, say, his big hit _Lucia di Lamermoor_.
 
_Lucrezia Borgia_ is usually chosen in a season by companies that have a star soprano already attached – think of Joan Sutherland, Beverly Sills, Reneé Fleming, etc. New Amsterdam has a singing star in [Toni Marie Palmertree](/scene/people/toni-marie-palmertree/), in the title role.

The House of Borgia, an infamous family in Renaissance Italy, has inspired many books, novels, plays, films and a soapy Showtime series starring Jeremy Irons. There appears to be a great deal of poetic license in all these works – the Borgias were certainly an immoral, criminal enterprise but how many stories about them are historically accurate is difficult to determine. Lucrezia, a prominent member of the family, is famously depicted as an assassin who poisons many rivals in politics and love. Whether true or not, it makes for a good evening at the opera.

In the hands of librettist Felice Romani, Lucrezia is vengeful and murderous but also sympathetic, having been separated from her baby son (now grown) whom she has only been able to observe from afar. While political intrigue serves as the backdrop – there are many who want Lucrezia dead and vice-versa – it's the smaller, intimate story of an unrequited mother's love that propels all the drama.

From the first note, Ms. Palmertree was in complete command vocally, though acting-wise, she was a little slow to warm into the role. Her performance really took off, however, about halfway through Act I when Lucrezia battles with her husband Don Alfonso (the formidable bass [Eric Lindsey](/scene/people/eric-lindsey/)). Mr. Lindsey, a magnetic presence, brought out the very best in Ms. Palmertree (which, ironically, turned out to be Lucrezia Borgia's worst). Don Alfonso's growing jealous fury, matched against Lucrezia's alternating guilty and defiance made for quite a duet, with Mr. Lindsey's profound resonance up against Ms. Palmertree's unrestrained high notes. Incidentally, those high notes were a highlight at the end of every chorus number, with Ms. Palmertree capping things off in a big finish each time, in traditional Donizetti fashion.

Mezzo [Madison Marie McIntosh](/scene/people/madison-marie-mcintosh/), in the musico or "pants" role of Orsini, was believable as the male "buddy". Though physically a little stiff, she gets to shine in her (his?) brief arias such as "Il segreto per esser felici". It was a double pleasure to hear bass-baritone Nate Mattingly do double-duty as both Gazella and Gubetta, and along with baritone Wilbert Kellerman, tenor Scott Ruben La Marca and tenor Pedro Barrera, Mr. Mattingly anchored an excellent quartet (or rather quintet because you have add Mr. Mattingly twice).

Tenor James Danner was convincingly cut-throat as the murderous henchman Rustighello and he was equal to the task in his duets with the uber-talented Mr. Lindsey (who, as Don Alfonso, was Rustighello's employer in the plotline). Mr. Danner was even memorable in the scenes where he didn't sing at all, off to the side of the stage, listening to the action and planning his next move.

The first-rate Men's Chorus gave the entire proceedings a powerful base (and by that I'm referring to both the basses and the tenors). Under the baton of Keith Chambers the 31-piece orchestra was in good form with the exception of an occasionally challenged brass section.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1685916500/NAO_Borgia_1.jpg){{% /md %}}

<figcaption>New Amsterdam Opera's in-concert production of Lucrezia Borgia, May 2023. Photo courtesy of New Amsterdam Opera.</figcaption>
</figure>

New Amsterdam presents works in a concert-style, with performers at music stands, and the only staging is the exits and entrances of principals who are in each scene. This leaves them free to invest donors' dollars in the music and that certainly pays dividends to the audience. Fund-raising is always a challenge, but one wishes that they could find the money to rent a supertitle system. It would enhance the experience tremendously, especially if they are trying to expand their audiences beyond those who are already opera lovers. Devout opera nerds may have no issue reading translations via cellphone light, but it's too much to ask today's younger audiences to commit a libretto to memory – the way we had to in the olden days. Also, the lights in the audience are a distraction and nothing should distract from the fine work up on the stage.