+++
author = ["authors/frank-pesci.md"]
categories = "Op-ed"
date = "2017-06-25T09:58:00-06:00"
lastmod = "2017-06-26T21:55:00-06:00"
preamble = "This is the third in a series of essays by composer and guest contributor Frank Pesci. In four installments originally published on [New Music Box](http://www.newmusicbox.org/articles/author/frank-pesci/), Pesci recounts his participation in Fort Worth Opera's [Frontiers](http://www.fwopera.org/operas/frontiers/) showcase, a major opportunity for emerging American composers. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498407470673/2017-06-25---Performance.jpg.jpg"
publishDate = "2017-06-26T21:22:00-06:00"
related_articles = ["articles/taking-tweed-seriously-lessons-for-the-emerging-opera-composer.md","articles/fine-mess-composer-new-opera.md","articles/the-big-and-everpresent-whats-next.md"]
related_companies = ["scene/companies/fort-worth-opera.md"]
short_description = "I&#039;ve always been amazed how the rehearsal process produces in me a higher awareness of what I have written. To think that I know every motivation behind every note and gesture is, for me, conceit. I need another&#039;s inquiries to drag out the nuggets of meaning and all the things I didn&#039;t know I knew about the piece. "
slug = "preparing-for-performance-what-i-didnt-know-i-knew"
title = "Preparing for performance: what I didn&#039;t know I knew"
+++

On the plane, somewhere between Frankfurt, Germany and the Dallas-Fort Worth Airport, I decided that I was going to crash the first rehearsal. It was explained to me that this was to be an initial, getting-to-know-you music rehearsal for only singers and music staff, but my excitement was such that I simply had to jump in to this experience as quickly as possible. Bleary-eyed, I asked my cab driver to drop me off in the 90-degree soup in front of the opera building at Texas Christian University. Unexpected as my presence was, dropped jaws and raised eyebrows quickly melted into warm greetings from the music and administrative staff who were collected to dig into my score.

In retrospect, perhaps jetlag and hubris played a role is this decision, but this initial greeting set the tone for the ten days that would follow. In that first rehearsal, any trepidation I had vanished in the face of the care and interest that the music staff — conductor Stephen Dubberly and pianist Matthew Stevens — had for my music.

The next day was "First Day of School," as it is known in the opera world, and the composers and librettists assembled at McDavid Studio in downtown Fort Worth, which was to be both our rehearsal and performance space. Directly adjacent to the formidable and gorgeously designed Bass Performance Hall, McDavid is a sleek, multidimensional space, part of which had been transformed into a black box for Fort Worth Opera's use.

Nervous, excited, and jetlagged out of my gourd (I had woken up at 4:30 a.m.) I was struck by a familiar serenity upon entering the theater. With lush, velvet black curtains hanging floor to ceiling, and rows of simple single chairs, this was the type of space in which I had worked for a decade as a musical theater director and conductor. What it lacked in acoustics (those hangs ate all the sound) it excelled at in terms of both intimacy and possibility. As for my new colleagues, we instantly got on like a house on fire. They brought a wealth of experience and a devotion to the art form, and for a week, we geeked out over performances we had attended, technique, our teachers, our "real jobs," other projects we were starting, and what notation programs we used.

## The excavation of artistic knowledge

The terror and exhilaration of having nothing to do in rehearsal is both a welcome and dreaded experience. Once the double bar is printed, there is, theoretically, a point in time when a piece is handed over. My role in the process having come to a pause, I'm then overshadowed so that well-trained conductors, pianists, and singers may immerse themselves in the piece. In rehearsal, my dictum is "less talk, more music," which puts the pressure on me to make sure that my score is impeccable. During the Frontiers rehearsal process (in which I was afforded more than four hours of rehearsal time — an embarrassment of riches for 20 minutes of music), I was able to allow the cast and music staff to explore the score, organically extending their interpretation throughout the process, and encouraging me to add dramaturgical and compositional nuance, when appropriate.

I've always been amazed how the rehearsal process produces in me a higher awareness of what I have written. To think that I know every motivation behind every note and gesture is, for me, conceit. I need another's inquiries to drag out the nuggets of meaning and all the things I didn't know I knew about the piece. The particulars of melodic gesture, harmonic choice, or rhythmic figure are made in private, worked out in the vacuum of the studio. While they are important to me as a composer, overt knowledge of these details, in my experience, does not necessarily inform the application or performance of the score.

Until it does. Case in point: at the end of the soprano aria, there is a section marked "suddenly cheery," in contrast to previous sections. It wasn't working, and I soon realized that it was because this marking had not made it to the soprano's part. Further, I was able to connect this hopeful moment to a later arietta, in which she sings to her estranged father of her hope that he see the light, metaphorically, which presents blindness as another example of perception, the work's general theme. Light bulbs went on across the rehearsal space and the impact on everyone's performance was immediate.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498406591993/Rehearsal_in_McDavid5.jpg.jpg)
<figcaption>The rehearsal for the reading of my opera The System of Soothing at the McDavid Studio.</figcaption>
</figure>

## The joy of live performance

Arriving at McDavid Studio on show day came on the heels of an outpouring of support from the Fort Worth Opera staff and my composer colleagues. (Side note: The administrative staff at Fort Worth Opera is a typical collection of dedicated administrators, all of whom — each wearing too many hats — collectively bust their cans to put up a good product and engage the community. Their encouragement and handling of our Frontiers composer clique contributed to a relaxed atmosphere that made the work process easy and productive.)

In the months preceding Frontiers, I admit that I obsessed over the gravity of the opportunity. While the upside of this manifested itself in intense and detailed preparation, especially in how I talk about myself and my operas (detailed in the second essay of this series), the downside for me dragged into the success or failure of the showcase itself:  whether anyone would come; whether anyone in attendance would be a decision maker in the field; and whether those decision makers would take an interest in my work. These thoughts exist in the bubble of the solitary artistic practitioner. But while composing is a lonely endeavor, collaboration is not. As the work with my cast and music staff progressed, my concern about the work's impression dissipated. I became enveloped in the process of rehearsal, in the drawing out of character, in the communication between conductor, pianist, and singer that squeezed every drop of music out of my arias.

Some of the show is blurry in my memory (this is normal for me – thank God it was recorded), but most of it is crystal clear. Amanda Robie, who ably administered Frontiers, opted for a live, pre-showcase discussion of each work, in which my preparation and practice paid off. One by one, my cast nailed each aria, and when the cloudy penultimate chord of the last aria resolved to a ringing open fifth, I rose to hug my conductor, thank my pianist and cast, raise my hands to the audience, and bow in honor of the work we had done together.
