+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-03-30T22:31:00+01:00"
lastmod = "2016-03-31T10:09:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459373195766/2016-03-31---Rough-Waters.jpg.jpg"
publishDate = "2016-03-31T10:09:00+01:00"
related_articles = ["articles/at-the-podium-jordan-de-souza.md","articles/in-defence-of-singers.md","articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/overthinking-it-and-other-traps.md","articles/operas-sexual-assault-secret.md"]
short_description = "So, it comes down to an imbalance of power, and a blurry line between standing up for oneself and pissing off someone who can give an artist a serious leg up in their career. People who take advantage of their power within a competitive industry aren&#039;t good people - that&#039;s simple. And it&#039;s only fair to point out that the majority of people with whom I&#039;ve worked have passed The Dad Test with flying colours. "
slug = "power-plays-and-crossing-lines-"
title = "Power plays and crossing lines "
+++

[Jeff Melanson has resigned](http://www.theglobeandmail.com/arts/music/toronto-symphony-orchestra-president-and-ceo-jeff-melanson-resigns/article29431208/) as President and CEO of the Toronto Symphony Orchestra, following [allegations made by his ex-wife](http://www.theglobeandmail.com/news/national/mccain-and-melanson-an-arts-world-marriage-unravels/article29204852/), Eleanor McCain, about his conduct at work and within their marriage. The claims brought up an alleged history of sexual harassment, on-the-job drinking, and other questionable behaviour during his time at the TSO, as well as The Banff Centre and the National Ballet School. 

Melanson has said little about the allegations, except that they are "grossly inaccurate", and that his detailed responses will be "through the courts and not through the press." It's important to remember that while the claims are nasty, when one side of a dispute offers up more details than the other, it doesn't mean those details add up to more truth. 

This bit of writing is not about the validity of the allegations against Melanson.  Instead, I see this (incomplete) case as representative of a larger story, and I do want to take the opportunity to write about my own experiences as an arts worker. The arts industries are like any other industry, in that there are people working within them that behave badly. Often, bad behaviour comes from people in positions of power - again, not a trait unique to the arts. 

Look. I'm a woman in the opera and classical music industry, and I've seen this type of thing happen. I've been in situations where superiors cross lines. Not big, criminal-behaviour lines, but lines nonetheless. I tend to put actions like these up against a private test of my own, that I've called The Dad Test. It goes: if my dad were in the room, and saw what just happened, would he want to kick someone's ass? The Dad Test isn't meant to separate the decent from the I-should-report-this type of behaviour; it's meant to be a personal barometer for my own level of comfort at work.

Sexism happens, too; and it doesn't always come from heterosexual men. Boys clubs come in a few forms, and as far as women are concerned, the results are the same. More often than not, sexism is paired with a healthy dose of career ambition (or insecurity, depending on how you look at it); in this combination, not only is sexism a tricky claim to make in an explicit way, it's actually not threatening at all. "Threatening" and "not a fun place to work" are different things, and women fortunately have the opportunity to choose which problem to pursue. And who knows - I may have gotten as many gigs through sexism as I perceive to have lost.

Like I said: the arts aren't unique when it comes to powerful people overstepping their job descriptions. Yet, the industry may indeed be more subjective than some when it comes to getting a job. For centuries, musicians have been hired, and not hired, because of personal relationships; these include the platonic as well as the romantic. I don't think it's true that power alone leads to sexual harassment allegations. There are people who are attracted to leadership positions, and there are people who cross boundaries. It makes me think of that [Dylan Moran](https://youtu.be/lpkiIaFv5As) bit:

"Every so often, some politician or footballer or actor or whoever it is is caught in a hotel room, surrounded by hookers and cocaine. And everybody else goes: 'Oh, the shame of it! How could he? How absolutely dreadful! I'd *never* do that... I've never had the chance, but I'd never ***ever*** do that!'"

The point lies under a similar umbrella as any sexual assault or harassment case, in which the victim feels scared or uncomfortable coming forward with their claim. For young, aspiring musicians in a competitive industry, we are taught that we must put in our dues in order to "make it". There's a vague concept of what this means, but being a "good colleague" is a big factor. We're told that we should be team players, agreeable and fun in the rehearsal room, and that we shouldn't put forward any sense that we may be "difficult" to work with. 

So, it comes down to an imbalance of power, and a blurry line between standing up for oneself and pissing off someone who can give an artist a serious leg up in their career. People who take advantage of their power within a competitive industry aren't good people - that's simple. And it's only fair to point out that the majority of people with whom I've worked have passed The Dad Test with flying colours. 

I suppose all I'm trying to say is: young artists, be armed with information, and know that relationships are a powerful tool in the industry you aspire to join. Hope for the best, but plan for the worst, and learn to discern danger from the habits of powerful people.
