+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = 2020-02-26T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1582569947/media/2020/02/sqPOVFLightFlight_0174_ixyoy6.jpg"
primary_image_credit = "William Towers as the Refugee in Pacific Opera Victoria's national premiere of Flight at Victoria's Royal Theatre, Feb. 20-Mar. 1, 2020."
related_articles = ["articles/flight.md", "articles/talking-with-composers-jonathan-dove.md"]
related_companies = ["scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/jacqueline-woodley.md", "scene/people/john-brancy.md", "scene/people/allyson-mchardy.md", "scene/people/sharleen-joynt.md"]
short_description = "In Flight, the characters arrive at the airport one by one, en route to their various destinations, and bringing their various problems with them. As all flights are cancelled due to a huge storm, and the passengers are stranded in the airport, their problems come to the forefront and are highlighted by each character in turn. "
slug = "well-cast-vignettes-in-povs-flight"
title = "Well-cast vignettes in POV's Flight"
youtube_url = ""

+++
[Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/) has had a history of taking on risks with some off-the-beaten-path productions, from last season's [_Rinaldo_](/pacific-opera-victorias-steampunk-meets-fantasy-rinaldo/), to 2017’s _Jenufa_, to 2019’s _Countess Maritza_. This season’s selection is Jonathan Dove’s _Flight_. The opera premiered at Glyndebourne Festival Opera in 1998 and has been performed around the world since.

The story is very loosely based on the story of [Mehran Karimi Nasseri](https://en.wikipedia.org/wiki/Mehran_Karimi_Nasseri), a refugee who lived at Paris' Charles de Gaulle airport for 18 years from 1988-2006. In this production, however, the setting is a very Pan-Am, 1960s mod airport, temporally removed from the real timeline of Nasseri's life.

In _Flight_, the characters arrive at the airport one by one, en route to their various destinations, and bringing their various problems with them. As all flights are cancelled due to a huge storm, and the passengers are stranded in the airport, their problems come to the forefront and are highlighted by each character in turn.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582570251/media/2020/02/POVFlightFlight_0145_pzjsis.jpg){{% /md %}}

<figcaption>Pacific Opera Victoria presents the national premiere of Flight at Victoria's Royal Theatre, February 20 - March 1, 2020. Photo: David Cooper Photography.</figcaption>  
</figure>

At the center of this is the Refugee, whose story we aren't told until the very end of the show while he aimlessly wanders around the airport, and the Controller, who stands in the control tower and varies between commenting on the story, and announcing the status of the flights.

Dove's score is very post-minimalist in style, and borrows from several themes of John Adams'. In fact, the score seems very reminiscent of Adams’ style, full of interesting musical punctuation, sudden changes of tempo, tone painting, and other more modern musical elements that all serve to create a busy, dynamic score with a great sense of forward momentum.

As the Controller, [Sharleen Joynt](/scene/people/sharleen-joynt/) was stellar. Singing a stratospherically high part with absolute ease, it was hard to tell that that kind of range should actually be difficult. As the Refugee (most characters are not named), countertenor William Towers performed as an awkward character, feeling very removed and Other in comparison to the other characters, which made their discomfort with him seem very genuine.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582570265/media/2020/02/POVFlightFlight_0122_rmdyca.jpg){{% /md %}}

<figcaption>Sharleen Joynt as the Controller in Pacific Opera Victoria's national premiere of Flight at Victoria's Royal Theatre, Feb. 20-Mar. 1, 2020. Photo: David Cooper Photography.</figcaption>  
</figure>

The Minskwoman, performed by mezzo-soprano [Allyson McHardy](/scene/people/allyson-mchardy/), had a great moment near the end of the show where she comes to terms with her life. McHardy's voice was beautiful and smooth, and her interpretation was very sad and poignant about her feeling lost in her own choices. As her husband, Minskman, bass-baritone [Neil Craighead](/talking-with-singers-neil-craighead/) was powerful and wonderfully resonant, with great stage presence and sincerity.

The entire ensemble was well cast, full of beautiful voices who tackled a very difficult score with great artistry. The Act I ensemble number was particularly lovely, I only wish it had lasted longer.

The score was brought to life with consummate skill by conductor Timothy Vernon. With a complex, layered, dynamic piece to conduct, Vernon kept the entire ensemble and orchestra together with dozens of difficult cues and precise pieces of timing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582570192/media/2020/02/POVFlightFlight_0729_yj0unx.jpg){{% /md %}}

<figcaption>Pacific Opera Victoria presents the national premiere of Flight at Victoria's Royal Theatre, February 20 - March 1, 2020. Photo: David Cooper Photography.</figcaption>  
</figure>

Unfortunately the cast were hampered by a less-than-stellar libretto, and a story where very little actually happens. As the characters go through their various struggles, they either resolve them without any major reason, or fail to resolve them and simply board their flight. The Refugee's narrative isn't shown until the final scene, at which point it feels far too late to feel the sympathy for his plight that the story and character deserve.

The plot also had many sex jokes, including having the flight staff having sex on the counter right in front of all the passengers for no real reason, and a gay sex scene later in the second act. Both of these seemed very crude, and seemed to exist solely as punchlines, rather than being moments that were earned by the narrative. The gay relationship comes out of nowhere, and felt like it was meant to be entirely transgressive, rather than anything genuine or sincere. Everyone laughs at it, and then the character goes back to his wife after she finds out, and they simply board their place together as if nothing had happened.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582570170/media/2020/02/POVFlightFlight_07131_imzqun.jpg){{% /md %}}

<figcaption>Pacific Opera Victoria presents the national premiere of Flight at Victoria's Royal Theatre, February 20 - March 1, 2020. Photo: David Cooper Photography.</figcaption>  
</figure>

In general, the show felt like a series of vignettes, rather than any cohesive story. The characters didn’t really change or grow during the course of events, and don’t feel as sympathetic as they should have given the talent and effort all the performers were putting forward.