+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-12-12T12:39:00-05:00"
lastmod = "2018-12-12T13:36:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544636303849/sqOnSiteOpera-AmahlandtheNightVisitors01.jpg.jpg"
primary_image_credit = "Amahl (Devin Zamir Coleman) in Amahl and the Night Visitors, On Site Opera, 2018. Photo: Pavel Antonov."
publishDate = "2018-12-12T12:39:00-05:00"
related_articles = ["articles/amahl-production-a-charming-gift-of-youthful-energy.md"]
related_companies = ["scene/companies/on-site-opera.md"]
short_description = "Menotti holds an unusual niche in musical history – he&#039;s one of the rare post-Puccini composers who continued in the romantic or verismo style while the opera world became mostly atonal and minimalist. He is also one of only a handful of composers – like Wagner – who wrote his own libretti."
slug = "pop-up-opera"
title = "&quot;Pop-Up Opera&quot;"

+++
The idea of the "pop-up" restaurant or store has become part of the culture here in New York City. Thanks to On Site Opera (OSO), the city has also enjoyed "pop-up" opera in such eclectic locations as the Eldrige Street Synagogue and a Hell's Kitchen garage. Their latest, Menotti's *Amahl and the Night Visitors*, was presented at the Holy Apostles Church on Ninth Avenue for four sold-out and free-to-the-public performances (patrons were required only to bring a non-perishable food item). Although a community project to call attention to the homeless, it was anything but community theatre. 

Menotti's *Amahl and the Night Visitors* was written in 1951 for a live television broadcast. For the TV-less, under-thirty generation, the nearest thing these days would be the live Broadway musicals on Fox and NBC. But those are merely revivals of shows that have already been presented on the stage.  There was a time when radio and, by extension, broadcast television, was generating so much revenue they could afford to do "crazy" things like commission original plays and operas.

Menotti's short one-act opera was one such work, and it became a Christmas mainstay, rebroadcast every year, as anticipated by viewers as the reruns of the *Peanuts* cartoon specials or the stop-action Rudolph the Red-Nosed Reindeer and Frosty the Snowman.

Menotti holds an unusual niche in musical history – he's one of the rare post-Puccini composers who continued in the romantic or verismo style while the opera world became mostly atonal and minimalist. He is also one of only a handful of composers – like Wagner – who wrote his own libretti.

But *Amahl* is one of the only Menotti pieces still performed by opera companies today, and only during the holiday season since it's a Christmas story. Here, the famous Three Kings stop at a home during their long journey toward the Christmas Star. A woman (The Mother) offers them shelter and shares with them what little she has.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544636165402/OnSiteOpera-AmahlandtheNightVisitors02.jpg.jpg)
<figcaption>Amahl (Devin Zamir Coleman) and his Mother (Aundi Marie Moore) in *Amahl and the Night Visitors*, On Site Opera, 2018. Photo: Pavel Antonov.</figcaption>
</figure>

Director Eric Einhorn has given us food for thought, ironically set in a soup kitchen. 

He has reimagined the Three Kings as part of the homeless population. They enter pushing a baby carriage and grocery basket filled with "found" odds and ends. Until we find out that they're packing quite a bit of gold, Mr. Einhorn makes us ask the question: are they really who they say they are? After all, their attire is far from resplendent – just the opposite. Costumer Jessica Jahn must have had a ball picking out the eclectic ensemble for each. She also has some clever and subtle "royal" touches – a Renaissance ruff, a court jester's skirt, a paper birthday crown from Burger King, etc.

Mr. Einhorn has carefully crafted his staging to use every bit of the church sanctuary.  It's essentially performed in the round, but the characters use the audience space to great effect. When Amahl goes to the door three times to greet the Three Kings he crosses through the audience and goes to the actual church door. Chorus members surprise us as they are discovered sitting among the audience members. (A note about the chorus: some are professional singers and some are amateurs who have actually experienced homelessness.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544636154828/OnSiteOpera-AmahlandtheNightVisitors04.jpg.jpg)
<figcaption>(l-r) Kaspar (Joseph Gaines) and Amahl (Devin Zamir Coleman) in *Amahl and the Night Visitors*, On Site Opera, 2018. Photo: Pavel Antonov.</figcaption>
</figure>

The six principal cast members in this OSO production aren't familiar faces or voices in New York City - hopefully their performances here will help change that.

As Amahl, ten-year-old boy soprano Devin Zamir Coleman makes a spectacular debut.  He is sweetness personified, both in his voice and in his sympathetic portrayal of the title character. He also has the professional poise of singers twice his age. (Master Coleman alternated in the role with Luciano Pantano.)

As written, the focal point of the piece is not just Amahl, however, but also his mother (Aundi Marie Moore). Ms. Moore filled every arch of the church with her powerhouse soprano. The poor and long suffering Mother must face a moral dilemma and requires a gifted actress like Ms. Moore. She was able to take us through the character's expressions of love for her son while at the same time struggling with her own fears. When Ms. Moore and Master Coleman have a short duet, prepare yourself for a short gasp and a tear in your eye.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544636146560/OnSiteOpera-AmahlandtheNightVisitors09.jpg.jpg)
<figcaption>(l-r) Kaspar (Joseph Gaines), Balthazar (Musa Ngqungwana), Amahl (Devin Zamir Coleman), Amahl's Mother (Aundi Marie Moore), and members of the community chorus in *Amahl and the Night Visitors*, On Site Opera, 2018. Photo: Pavel Antonov.</figcaption>
</figure>

As the tenor-baritone-bass trio of the Three Kings, you couldn't ask for a better blend than Joseph Gaines, Daniel Belcher and Musa Ngqungwana.  Individually, each voice is perfection, so together their harmonies are nothing short of splendid. The three offer depth and dimensions to familiar personas that we recognize from denizens of the street: Mr. Belcher is a hopeless dreamer, Mr. Gaines appears to be quite mad and Mr. Ngqungwana struggles with physical disability.

Jonathan R. Green brings both empathy and gravitas to the small but important role of The Page (repurposed here as a security guard.)

All of this accompanied by Geoffrey MacDonald, who was in full command of his vibrant orchestra. (The producers must be commended for budgeting 18 pieces to give Menotti's music what it deserves.)

And if it wasn't enough to get a memorable night of opera, there was also a knockout dance in the middle of the show from choreographer Winson A. Benons, Jr.  Five dancers gave us a ballet with a modern and Middle Eastern twist. Their turns and twirls were as in sync as the Rockettes (without the kicks).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544636137991/OnSiteOpera-AmahlandtheNightVisitors11.jpg.jpg)
<figcaption> Dancers (l-r) Marlene Desiree Watts, Dana Thomas, and Frances Barker in *Amahl and the Night Visitors*, On Site Opera, 2018. Photo: Pavel Antonov.</figcaption>
</figure>

OSO produced in partnership with the [Holy Apostles Soup Kitchen](https://holyapostlessoupkitchen.org/) and [Breaking Ground](https://breakingground.org/), an organization finding permanent housing solutions for the homeless.