+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-05-08T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_Pomegranate_](http://buddiesinbadtimes.com/show/pomegranate/) runs at Buddies in Bad Times Theatre June 5-9."
preamble = "Next month, Toronto's Buddies in Bad Times Theatre sees the world premiere of [_Pomegranate_](http://buddiesinbadtimes.com/show/pomegranate/), the lesbian chamber opera by Kye Marshall and Amanda Hale. The story of time-travel and love is directed by Michael Mori, and runs June 5-9.\n\nWe spoke with Hale and Marshall about their work, and the story they hope to tell with _Pomegranate_."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557424860/media/2019/05/sqPOM.jpg"
primary_image_credit = "Camille Rogers and Rebecca Gray as Suzie and Cass in Pomegranate."
related_articles = []
related_companies = []
related_people = []
short_description = "\"It shows how lovers can be so deeply bonded that they remain loyal to each other across huge time spans and are once again drawn together, even without recognizing why, just acting on instinct.\""
slug = "a-lesbian-chamber-opera-to-span-centuries-pomegranate"
title = "A lesbian chamber opera to span centuries: Pomegranate"
youtube_url = ""

+++
## What inspired this story of time-travel and love?

**Amanda:** I've always been drawn to the Classical era of the Mediterranean – especially Greco-Roman culture and its accompanying mythologies. In the early 2000s I visited the ruins of Pompeii and was intrigued with the frescoes in the Villa of Mysteries – a building on the edge of the town of Pompeii, housing a wine press, and a Hall with walls covered in fresco fragments.

The scenes I saw there, which I interpreted as ritualistic, stayed with me, working on my imagination until, a couple of years later, I wrote a series of poems about two young girls in the Villa – which I took to be something like a Roman girls' boarding school – girls who slept behind the wine press and passed through daily rituals as they were prepared for initiation into the Dionysian Mysteries, to become Maenads in the Bacchanalian revelries.

My writing tends towards the historical so I am accustomed to imagining the past and fantasizing how people lived and felt. This, combined with research, resulted in an intense love story within a very specific social structure – the clandestine Mysteries of ancient Pompeii.

I self-published the poems under the title _Pomegranate_ and began selling, and distributing to friends.

Kye Marshall and I are members of Yorkville's Heliconian Club, an interestingly named women's arts club formed in 1909 in response to the exclusion of women from Toronto's Arts & Letters Club. Mount Helicon in ancient Greece was said to be a haunt of the Muses. When Kye approached me about setting the Pomegranate poems to music I was thrilled, because I have always admired her skills as a cellist and composer. We presented the beginnings of _Pomegranate_ as five songs at the Heliconian for International Women's Day in 2014.

>"The Pomegranate story shows the power of romantic connection that can absorb two people and make them oblivious to the larger issues surrounding them."

Our audience loved the presentation, so, with the inspiration of the Muses and audience applause, we took a leap into the opera world and began expanding the plot of Act I, and created a second and somewhat parallel act situated in a downtown lesbian bar in 1980s Toronto. The inspiration for Act II came from our mutual experience of 1980s Toronto – a time of political turbulence and revolutionary change for the lesbian and gay communities; and a time in which, unlike today, there were many lesbian bars with a clandestine atmosphere similar to the Villa of Mysteries – places where we could take refuge and feel free to be our true selves.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557425024/media/2019/05/Amanda%20by%20Pyx%20-%20Copy.jpg){{% /md %}}

<figcaption>Amanda Hale, librettist, Pomegranate.</figcaption>

</figure>

## What sort of musical aesthetic does this opera use to span across two thousand years?

**Kye:** Creating music that spans 2000 years is a welcome challenge for me. As an eclectic musician, I compose and perform on the cello - jazz, classical and free improv music - so I have many styles and genres in my musical toolkit. I have written for many combinations of instruments from solo piano to full orchestra, as well as for dance, poetry and film.

In the score I have created for _Pomegranate_ I use an eclectic mix of classical, jazz/pop, Latin, avant-garde and balladic genres. With a limited budget I decided to go with harp and electric piano as the mainstay instruments, but have added three cellos for their 4-octave range, lush sound and many sound colors which I know about from my cello practise.  Flute and oboe were included for their unique color palettes. As a contemporary composer I like to create music that is memorably melodic, accessible and enjoyable, but also includes colourful and interesting modern compositional techniques.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557425011/media/2019/05/KYE%20pic%20cello-promo.jpg){{% /md %}}

<figcaption>Kye Marshall, composer, Pomegranate.</figcaption>

</figure>

## What does this story have to say about human nature and romantic relationships?

**Amanda:** The _Pomegranate_ story shows the power of romantic connection that can absorb two people and make them oblivious to the larger issues surrounding them. Or, even when the lovers are aware of life's challenges – trying to live within families and communities with different values, required to manoeuvre their way through the differences – their sexual and emotional connection is the stronger pull, and can carry them above it all. In this particular case it shows how lovers can be so deeply bonded that they remain loyal to each other across huge time spans and are once again drawn together, even without recognizing why, just acting on instinct. That strange feeling that you have known someone before, even though you've just met; that you are picking up on something uncompleted.

>"I would like people to feel their hearts opened by this tender love story and by the courage, loyalty, and vulnerability of the young women trying to make their way, together or apart, in a wounded world."

The story demonstrates the old saying, _plus ça change, plus la même chose_. It shows that conflict is inherent to the human condition, operating not only within each individual, but within the societies we have created, rife with conflict as an animating, though often destructive force. Our lives are a struggle to resolve conflict but, according to the direction a particular society has taken in a specific time, conflict is in fact what animates us and keeps us in a perpetual state of dialectical struggle.

The arts allow us to demonstrate the limitations of language. Even where human connection is profound, we often fall short of communicating thoughts and feelings that then remain buried in our inner lives. The traditions of opera make it a perfect vehicle for expressing these passionate emotions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557424937/media/2019/05/PomegranatePOSTER.jpg){{% /md %}}

</figure>

## What do you hope people will take away from this premiere production at Buddies in Bad Times?

**Kye**: I hope that the music has filled them up emotionally and aesthetically and that they leave the theatre with melodies still reverberating through their bodies. Also I would he pleased if audience members were filled up with the very moving experience that the two young women have gone through, and that this experience may open them up to other types of discrimination that exist.

**Amanda**: I hope people will leave the theatre with an expanded feeling of women's experience across the centuries, and with a feeling of our endurance in the face of challenge. I hope our audiences will be prompted to think too of how hostage we are to Nature, and how quickly all our plans can be scooped by an event like the eruption of Mount Vesuvius. I don't mean this in a negative sense, but simply as a perspective; for all of us to be aware of our place in the universe, and of the work that we need to do within our limitations. Most of all I would like people to feel their hearts opened by this tender love story and by the courage, loyalty, and vulnerability of the young women trying to make their way, together or apart, in a wounded world.