+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-14T14:46:00-05:00"
lastmod = "2015-11-15T11:18:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447534683353/2015-11-14---WateringPlants.jpg.jpg"
publishDate = "2015-11-15T11:18:00-05:00"
related_articles = ["articles/shhdont-tell-them-its-opera.md","articles/the-case-for-music-education.md"]
short_description = "The only necessary ingredient in bringing up a generation of respect for the arts is constant exposure. It&#039;s not a passive thing at all, and what makes me nervous is that it&#039;s largely up to the grown-ups to plant the seeds."
slug = "playing-the-long-game-fostering-artistic-respect"
title = "Playing the long game: fostering artistic respect"
+++

I've been going to concerts since I could walk. Growing up, I lived in a city with a great concert series and a few theatre companies; [my mother is a musician](/talking-with-voice-teachers-or-meet-my-mother/), and not only did she know the value of dragging her daughter to show after show, she knew what to look for. We went to Stratford for Shakespeare and musicals, to Toronto for the TSO (and musicals), and at home there was a constant flow of *Messiahs* and piano concerti to hear.

Now, I didn't love all of it; there were a few tedious choir concerts, and I didn't even love my first opera outing (I spent it frustrated with Cio-Cio San). It wasn't even the poor attention span of my youth; I remember divising a system for figuring out how many minutes each piece would be, based on educated guesses that improved with time. But the stuff I did love, it all seemed to brand itself on me like a musical impression; with almost three decades of concertgoing experience, these special musical relationships don't seem to fade.

A perfect example: Disney's *Fantasia*. As a kid I watched it on VHS *endlessly*, especially the whole thing with [Beethoven's "Pastoral" Symphony](https://vimeo.com/85093232) and all the cherubs and centaurs and winged horses. Oh, or the [*Rite of Spring*](https://vimeo.com/44676300) bit with the dinosaurs? Couldn't get enough of that Tyrannosaurus rex scene with the thumping celli. It's no mystery why I still love those pieces today.

I remember seeing a [*Messiah*](https://www.youtube.com/watch?v=ZuGSOkYWfDQ) with my mom where there were two medical incidents; first, an oboist had an epileptic seizure in the middle of "Comfort Ye," and later in the evening a man in the audience had a heart attack. They announced that both people were fine, and the "Hallelujah chorus" still has that hilarious connotation that makes me smile.

When I first got my driver's license, I was pretty excited about having authority over car music. At the time I was obsessed with two recordings, one of both of Glenn Gould's recordings of the [*Goldberg Variations*](https://www.youtube.com/watch?v=Ah392lnFHxM) (1955 and 1981), and one of Emil Gilels playing both the Brahms Piano Concerti (I couldn't get enough of the last movement of the [First Concerto]((https://www.youtube.com/watch?v=CqYzBCk_tm4&feature=youtu.be)), personally). Those pieces will forever go hand in hand with those years; I suppose they were good years, because I love those pieces, too.

The first bit of opera I remember hearing was as a teenager, on the CDs that came with my edition of the Norton Anthology of Western Music (textbook buddies, raise your hands!). Included was Strauss' famous [*Der Rosenkavalier* trio](https://www.youtube.com/watch?v=KdHjUZLe5W8). Of course, I didn't know that; I don't even think I knew they were singing in German. All I remember is that amazing moment at the beginning when the Marschallin is singing alone, and Sophie joins seamlessly, like the voice splits into two. It was the first time I remember music making me giddy. 

During university, my music preferences came in waves of one obsession after another; one week it was [Hugo Wolf](https://www.youtube.com/watch?v=tkuQi_PS1hE), the next it was [Bartók](https://www.youtube.com/watch?v=FMTuOsGE9ho). I had pieces like Verdi's ["Ave Maria"](https://www.youtube.com/watch?v=Z9nrtFkj6Bo) from *Otello* or ["Pur ti miro"](https://www.youtube.com/watch?v=-26AS6DhHbY) from *L'incoronazione di Poppea* playing on loop. 

Since I've started this blog, I've been able to go [hear and see performances](/categories/reviews/) at a higher frequency than ever before in my life (perhaps save for those university years, where you had to go to *everyone's* grad recital). Only recently have I been conscious of the fact that listening to live music and theatre is one of my favourite things in the world. Somewhere along the way, Mozart's music went from drab to perfect, and Beethoven went from bangy-sounding-Mozart to something entirely revolutionary. In opera, long arias went from annoyances that stopped the action, to luxurious unpackings of emotional webs.

I say all this not to use you, readers, as an audience for my own personal music diary. Like with most things, you get out of music and the arts what you put in; through a combination of curiosity and luck (savvy mom, great music teachers, etc.), I can now feel myself reaping the rewards of decades of attention to music. I think about that a lot when we talk about bringing in new audiences. I'm not saying an adult at his or her first classical concert or opera won't be wowed, or won't want to come back; I do know that there are more layers to this music that my background and training allows me to hear, and it's a shame that not everyone can experience that. 

It's not dependent on kids growing up and hearing specifically *Messiah*, followed by *Fantasia*, then *Madama Butterfly*, and so on; it's not even dependent on classical or art music. My brother is a perfect example of someone whose music bug led him to jazz and bluegrass, and hearing an opera or an orchestra still thrills him. It's because he knows *something* about it, and with music, there are so many ways in. The only necessary ingredient in bringing up a generation of respect for the arts is constant exposure. It's not a passive thing at all, and what makes me nervous is that it's largely up to the grown-ups to plant the seeds. 

I've had plenty of experiences at concerts where I see kids bouncing with glee, and looking at nearby adults with wonder (that one pulls at my heart). I've seen just as many with horridly disrespectful adults who show up late and let their kids do anything but pay attention to what's going on onstage. I've watched school teachers show their students with their own actions that performers *don't* need your respect or attention. It would be easy for me to voice my distrust in adults like this, whom I don't count on to introduce their kids to the arts. A better use of my time, and that of anyone else who feels this kind of despair, is to take positive action. From whatever place of power you come, it's about making music and live performance *the norm* for young people. Parents, take your kids to a [sing-along *Messiah*](http://www.tafelmusik.org/concert-calendar/concert/sing-along-messiah-massey-hall-0) this Christmas. Teachers, classical music is not too lofty a topic for kids of any age to learn about. Artists, value your young audiences, and be available for them to idolize you, and be willing to respect their curiosity.

It's a collective, long-term investment, and it can only start with the people who already understand the value of the arts. Readers, I believe that's you!
