+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-09-04T16:48:00+01:00"
lastmod = "2016-06-08T10:14:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441388095638/DomingoRigolettoSquare.jpg.jpg"
primary_image_credit = "A scene from Rigoletto a Mantova. Photo: © RadaFilm/C. Gigliotti, 2010."
publishDate = "2015-09-08T13:00:00+01:00"
related_articles = ["articles/operalia-advertising.md","articles/graceful-exits-double-standards.md","articles/nabucco-is-hard-to-find-in-the-latest-la-opera-production.md","articles/a-great-loss-hvorostovsky-passes-at-55.md"]
related_companies = ["scene/companies/los-angeles-opera.md","scene/companies/washington-national-opera.md"]
related_people = ["scene/people/plcido-domingo.md"]
short_description = "The complaint is: legendary tenor Plácido Domingo has retired his notorious Don José, Cavaradossi, and Otello, and has started taking on baritone roles (Oreste in Iphigénie en Tauride, and the title roles in Simon Boccanegra and Rigoletto). The argument is that his singing these roles takes away a potential gig from a hard-working, vocally appropriate Verdi baritone."
slug = "placido-baritones-ripple"
title = "Plácido Domingo, Verdi baritones, and the ripple effect"
+++

The other day, a friend and colleague posted a curious paragraph on Facebook:

>"Nice to see a new full production of *Rigoletto* on TV tonight. My only real sadness goes out to the actual Verdi Baritone who has kids to feed and a mortgage to pay but lost the contract because Maestro Domingo (who let's not kid ourselves... is arguably one of the greatest operatic artists in history) could do one more baritone project because... he can? Not a criticism... just an observation."

So, to be clear, the complaint is: legendary tenor Plácido Domingo has retired his notorious Don José, Cavaradossi, and Otello, and has started taking on baritone roles (Oreste in [*Iphigénie en Tauride*](http://www.nytimes.com/2011/02/14/arts/music/14iphi.html), and the title roles in [*Simon Boccanegra*](http://www.nytimes.com/2010/01/20/arts/music/20simon.html) and [*Rigoletto*](https://www.youtube.com/watch?v=Zun2x42BY1Y)). The argument is that his singing these roles takes away a potential gig from a hard-working, vocally appropriate Verdi baritone.

Are these the ramblings of an eager, young baritone itching to sing his first Rigoletto? Is this resistance to the big changes in this star tenor's career? Is this the ultimate #FirstWorldProblem?

Perhaps the answer to all my above hypotheticals is yes; still, there's an important point being made. I'll be honest; I agree with the implications of my colleague on Facebook, and I think it comes down to self-awareness. This goes both for the young artist, struggling and insatiable, and for the established singer, even Plácido Domingo, who has achieved the status of a contemporary historical figure of the operatic stage.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/Zun2x42BY1Y" frameborder="0" allowfullscreen></iframe>
<figcaption>A scene from *Rigoletto a Mantova*, with Plácido Domingo in the title role, 2010.</figcaption>
</figure>

Now, when it comes to the question of "fair casting" in opera, you couldn't find a more slippery slope. My more naïve side wants good opportunities for singers who work at their craft, and idealistic as that may sound, it comes from a desire for more consistent patterns of business and aesthetic in this weird and wild industry. To be fair, any objections to someone like Domingo singing Rigoletto fall under the same umbrella as arguments against your average too-light Lucia, or too-dramatic Count Almaviva; it all comes down to taste.

There are a few things at play. Not just any tenor could retire from high notes and move into a different *fach* world entirely, and at top level houses, too. Domingo must know he's influential enough to gain these types of gigs, right? There are musical questions, like the difference between range and tessitura, or how Verdi writes climactic moments for a baritone versus a tenor. I doubt these are things Domingo doesn't understand about this music, after a career of singing it so expertly; again, I think there's something to be said for being self-aware.

Personal taste aside, I think in the case of a big-name tenor "taking potential baritone gigs," the most important point is this: Domingo works with enough young singers to know that there are thousands of hard-working, fab-sounding singers of all voice types. Between his [Operalia Competition](http://www.operaliacompetition.org/placido), the [Domingo-Cafritz Young Artist Program](http://www.kennedy-center.org/wno/edu/dcyap/) at [Washington National Opera](/scene/companies/washington-national-opera/), the [Domingo-Colburn-Stein Young Artist Program](http://www.laopera.org/company/yap/) at [Los Angeles Opera](/scene/companies/los-angeles-opera/), and the [Centre de Perfeccionament Plácido Domingo](http://www.lesarts.com/Palau/CentredePerfeccionament/Presentation/seccion=1223&idioma=en_GB.do), it strikes me that the famed tenor would hear loads of young and skilled singers, not all of whom are consistently employed. 

I realized Domingo is an adult, and whether or not he takes a gig isn't dependent on the relative success of other singers; but if there's any singer who could turn down a questionable role offer *and* get a deserving Verdi baritone a job, it's Plácido. So, I suppose I mean to say Domingo should, well, *know better*.

I'm reminded a bit of the generation gap that exists between teachers and students of opera. Often voice teachers working out of major academic institutions (Indiana, MSM, Rice, etc.) are removed from the current working environment, and the concept of what it takes to be an employable singer today. It doesn't mean they're not great teachers, but I've noticed a sort of generational ignorance in the advice and priorities of singers who had the bulk of their performing career in the 1980s. So, is Plácido taking "roles that aren't his" without being aware of the small yet notable ripple effect among more suited baritones? Or is he simply doing what we encourage each other to do, and creating performance opportunities for himself?
